pageTitle: Contributing to Karma


You wanna contribute to Karma? That is truly great!
Here are some tips to get you started...

### Help others
The best way to start contributing to any open source project is to help other people.
You can answer questions on the [mailing list] or [Stack Overflow].
Either find something you already know the answer for, or something you feel interested in and
dig into it a little bit to find the answer.

Soon, you will realize you know Karma pretty well...


### Improve the documentation
You don’t feel like hacking on the code, but still wanna help?
Improving the documentation is very valuable as it will help many others.

All the source code is in [`docs/`].


### Fix something that bothers you
You found a bug that really bothers you? It’s more likely it bothers other users too and maybe
it’s not that hard to fix it! Try to find an existing issue. If it does not exist yet, create one.
Look into the code and let others know what solution you are thinking about.
Then, send a pull request and let other contributors to review.

[Here](./making-changes.html) is some more info on how to set up your workspace and send a pull
request.


### Fix something else
You want to contribute some code but not sure where to start? That's cool. Fortunately,
there are many issues labeled as "PR please". These are typically fairly simple issues with
a well-known, waiting just for you...

[Here](https://github.com/karma-runner/karma/issues?labels=PR+please&page=1&state=open) is a list
of all the issues for the core repo. In the same way, each plugin has "PR please" label as well...


### Review others work
Check out the list of outstanding pull requests if there is something you might be interested in.
Maybe somebody is trying to fix that stupid bug that bothers you. Review the PR.
Do you have any better ideas how to fix this problem? Let us know...

### I wanna help more
Check out [Maintaining Karma]. Becoming a Karma maintainer is simple.
You just do it. There is no test to pass ;-)

[mailing list]: https://groups.google.com/forum/#!forum/karma-users
[Stack Overflow]: http://stackoverflow.com/questions/tagged/karma-runner
[`docs/`]: https://github.com/karma-runner/karma/tree/master/docs
[Maintaining Karma]: ./maintaining.html
