(function(window) {

function createQUnitConfig (karma, defaultConfig) { // eslint-disable-line no-unused-vars
  var config = defaultConfig || {}

  if (!karma.config || !karma.config.qunit) {
    return config
  }

  for (var key in karma.config.qunit) {
    config[key] = karma.config.qunit[key]
  }

  return config
}

function createQUnitStartFn (tc, defObj, loadRunner, runnerPassedIn) { // eslint-disable-line no-unused-vars
  return function () {
    var FIXTURE_ID = 'qunit-fixture'
    var runner = runnerPassedIn || window.QUnit
    //var totalNumberOfTest = 0
    var totalNumberOfTest = ifNull(window.QUnit.config.totalNumberOfTest, 0)
    var timer = null
    var testResult = {}
    var supportsTestTracking = false

    if (loadRunner == undefined) loadRunner = true

    if (loadRunner) {

      if (runner.begin) {
        runner.begin(function (args) {
          if (args && typeof args.totalTests === 'number') {
            tc.info({ total: args.totalTests})
            supportsTestTracking = true
          }
        })
      }

      runner.done(function () {
        //if (!supportsTestTracking) {
        //  tc.info({ total: totalNumberOfTest })
        //}
        //
        //tc.complete({
        //  coverage: window.__coverage__
        //})
        window.QUnit.config.totalNumberOfTest = totalNumberOfTest
        tc.info({ total: totalNumberOfTest })
      })

      runner.testStart(function (test) {
        totalNumberOfTest += 1
        timer = new Date().getTime()
        testResult = { success: true, errors: [] }

        // create a qunit-fixture element to match behaviour of regular qunit
        // runner. The fixture is only removed at the start of a subsequent test
        // so it can be inspected after a test run.
        var fixture = document.getElementById(FIXTURE_ID)
        if (fixture) {
          fixture.parentNode.removeChild(fixture)
        }
        fixture = document.createElement('div')
        fixture.id = FIXTURE_ID
        // style to match qunit runner's CSS
        fixture.style.position = 'absolute'
        fixture.style.left = '-10000px'
        fixture.style.top = '-10000px'
        fixture.style.width = '1000px'
        fixture.style.height = '1000px'
        document.body.appendChild(fixture)
      })

      runner.log(function (details) {
        if (!details.result) {
          var msg = ''

          if (details.message) {
            msg += details.message + '\n'
          }

          if (typeof details.expected !== 'undefined') {
            msg += 'Expected: ' + details.expected + '\n' + 'Actual: ' + details.actual + '\n'
          }

          if (details.source) {
            msg += details.source + '\n'
          }

          testResult.success = false
          testResult.errors.push(msg)
        }
      })

      runner.testDone(function (test) {
        var result = {
          description: test.name,
          suite: test.module && [test.module] || [],
          success: testResult.success,
          log: testResult.errors || [],
          time: new Date().getTime() - timer
        }

        tc.result(result)
      })

      //Load the QUnit only after the test page has the AsyncTest regiestered. for safety adding setTimeout
      setTimeout(function() {
        runner.load()
      }, 50)

    }

    // we need only 2 done callbacks totaly. pop last one if there's already 2
    // before pushing new one.
    if (runner.config.callbacks.done.length > 1) {
      runner.config.callbacks.done.pop();
    }

    // instead of resolving the defObj in the initial done CB, have a second CB pushed with defObj
    runner.done(function (details) {
      if (defObj) defObj.resolve()
    })

    runner.start()
  }
}

var config = createQUnitConfig(window.__karma__, {
  autostart: false
});

for (var key in config) {
  window.QUnit.config[key] = config[key];
}

if (window.removeEventListener) {
  window.removeEventListener('load', window.QUnit.load, false);
} else {
  window.detachEvent('onload', window.QUnit.load);
}

window.__karma__.start = function(defObj, loadRunner){
  return createQUnitStartFn(window.__karma__, defObj, loadRunner);
}
})(window);
