# csslint-stylish
> Stylish formatter for CSSLint

[![NPM version][npm-image]][npm-url]
[![Linux Build Status][travis-image]][travis-url]
[![Windows Build Status][appveyor-image]][appveyor-url]
[![Coverage Status][coveralls-image]][coveralls-url]
[![Codeclimate Status][codeclimate-image]][codeclimate-url]

[![bitHound Dependencies][bithound-image]][bithound-url]
[![Dependency status][david-image]][david-url]
[![Dev Dependency Status][david-dev-image]][david-dev-url]

## Screenshots
![This reporter][new-image]

vs original:

![Original reporter][orig-image]

## Usage

### CSSLint Node.js API

To use it with the `csslint` api, you will have to call `csslint`, as well as assemble the report, manually.

```js
var csslint = require('csslint');
var csslintStylish = require('csslint-stylish');

var report = csslint.verify(/* css as string here */);

// Format the report stylishly
var stylishReport = csslintStylish.startFormat() + csslintStylish.formatResult(report) + csslintStylish.endFormat();

// Then write it to the console
console.log(stylishReport);
```

### `csslint` CLI
It's currently not possible to use a custom formatter with the CLI.

I have a PR with `csslint` that would make it possible. See <https://github.com/CSSLint/csslint/pull/593>

### `gulp-csslint`
It's currently not possible to use a custom formatter with the gulp-plugin.

See <https://github.com/lazd/gulp-csslint/pull/29>

### `grunt-contrib-csslint`
Starting with version `0.5.0`, it's possible to use custom formatters with `grunt`.

See the [example](https://github.com/gruntjs/grunt-contrib-csslint#providing-a-custom-formatter) in their repo

## API

### csslintStylish.formatResult(report, filename, options)

#### report
Type: `Object`
Optional: false

The report generated by calling `csslint.verify`.

#### filename
Type: `String`
Optional: true

The name of the file linted.

#### options
Type: `Object`
Optional: true

An options-object. Valid options are:

##### absoluteFilePathsForFormatters
Type: `Boolean`
Default: `false`

If `true`, will print the absolute path of the file linted, instead of the relative.


[travis-url]: https://travis-ci.org/SimenB/csslint-stylish
[travis-image]: https://img.shields.io/travis/SimenB/csslint-stylish.svg
[appveyor-url]: https://ci.appveyor.com/project/SimenB/csslint-stylish
[appveyor-image]: https://ci.appveyor.com/api/projects/status/92exg416gkm4al9r?svg=true
[coveralls-url]: https://coveralls.io/github/SimenB/csslint-stylish
[coveralls-image]: https://img.shields.io/coveralls/SimenB/csslint-stylish.svg
[codeclimate-url]: https://codeclimate.com/github/SimenB/csslint-stylish
[codeclimate-image]: https://img.shields.io/codeclimate/github/SimenB/csslint-stylish.svg
[npm-url]: https://npmjs.org/package/csslint-stylish
[npm-image]: https://img.shields.io/npm/v/csslint-stylish.svg
[bithound-url]: https://www.bithound.io/github/SimenB/csslint-stylish/master/dependencies/npm
[bithound-image]: https://www.bithound.io/github/SimenB/csslint-stylish/badges/dependencies.svg
[david-url]: https://david-dm.org/SimenB/csslint-stylish
[david-image]: https://img.shields.io/david/SimenB/csslint-stylish.svg
[david-dev-url]: https://david-dm.org/SimenB/csslint-stylish#info=devDependencie
[david-dev-image]: https://img.shields.io/david/dev/SimenB/csslint-stylish.svg
[new-image]: screenshots/this.png
[orig-image]: screenshots/original.png
