/*! JointJS v0.8.1 - JavaScript diagramming library  2014-05-13 


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
if("object"==typeof exports)var _=require("lodash");var joint={dia:{},ui:{},layout:{},shapes:{},format:{},connectors:{},routers:{},util:{hashCode:function(a){var b=0;if(0==a.length)return b;for(var c=0;c<a.length;c++){var d=a.charCodeAt(c);b=(b<<5)-b+d,b&=b}return b},getByPath:function(a,b,c){c=c||".";for(var d,e=b.split(c);e.length;){if(d=e.shift(),!(d in a))return void 0;a=a[d]}return a},setByPath:function(a,b,c,d){d=d||".";var e=b.split(d),f=a,g=0;if(b.indexOf(d)>-1){for(var h=e.length;h-1>g;g++)f=f[e[g]]||(f[e[g]]={});f[e[h-1]]=c}else a[b]=c;return a},unsetByPath:function(a,b,c){c=c||".";var d=b.lastIndexOf(c);if(d>-1){var e=joint.util.getByPath(a,b.substr(0,d),c);e&&delete e[b.slice(d+1)]}else delete a[b];return a},flattenObject:function(a,b,c){b=b||".";var d={};for(var e in a)if(a.hasOwnProperty(e)){var f="object"==typeof a[e];if(f&&c&&c(a[e])&&(f=!1),f){var g=this.flattenObject(a[e],b,c);for(var h in g)g.hasOwnProperty(h)&&(d[e+b+h]=g[h])}else d[e]=a[e]}return d},uuid:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(a){var b=0|16*Math.random(),c="x"==a?b:8|3&b;return c.toString(16)})},guid:function(a){return this.guid.id=this.guid.id||1,a.id=void 0===a.id?"j_"+this.guid.id++:a.id,a.id},mixin:function(){for(var a=arguments[0],b=1,c=arguments.length;c>b;b++){var d=arguments[b];(Object(d)===d||_.isFunction(d)||null!==d&&void 0!==d)&&_.each(d,function(b,c){return this.mixin.deep&&Object(b)===b?(a[c]||(a[c]=_.isArray(b)?[]:{}),this.mixin(a[c],b),void 0):(a[c]!==b&&(this.mixin.supplement&&a.hasOwnProperty(c)||(a[c]=b)),void 0)},this)}return a},supplement:function(){this.mixin.supplement=!0;var a=this.mixin.apply(this,arguments);return this.mixin.supplement=!1,a},deepMixin:function(){this.mixin.deep=!0;var a=this.mixin.apply(this,arguments);return this.mixin.deep=!1,a},deepSupplement:function(){this.mixin.deep=this.mixin.supplement=!0;var a=this.mixin.apply(this,arguments);return this.mixin.deep=this.mixin.supplement=!1,a},normalizeEvent:function(a){return a.originalEvent&&a.originalEvent.changedTouches&&a.originalEvent.changedTouches.length?a.originalEvent.changedTouches[0]:a},nextFrame:function(){var a,b="undefined"!=typeof window;if(b&&(a=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame),!a){var c=0;a=function(a){var b=(new Date).getTime(),d=Math.max(0,16-(b-c)),e=setTimeout(function(){a(b+d)},d);return c=b+d,e}}return b?_.bind(a,window):a}(),cancelFrame:function(){var a,b="undefined"!=typeof window;return b&&(a=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.webkitCancelRequestAnimationFrame||window.msCancelAnimationFrame||window.msCancelRequestAnimationFrame||window.oCancelAnimationFrame||window.oCancelRequestAnimationFrame||window.mozCancelAnimationFrame||window.mozCancelRequestAnimationFrame),a=a||clearTimeout,b?_.bind(a,window):a}(),breakText:function(a,b,c,d){d=d||{};var e=b.width,f=b.height,g=d.svgDocument||V("svg").node,h=V("<text><tspan></tspan></text>").attr(c||{}).node,i=h.firstChild,j=document.createTextNode("");i.appendChild(j),g.appendChild(h),d.svgDocument||document.body.appendChild(g);for(var k,l=a.split(" "),m=[],n=[],o=0,p=0,q=l.length;q>o;o++){var r=l[o];if(j.data=n[p]?n[p]+" "+r:r,i.getComputedTextLength()<=e)n[p]=j.data,k&&(m[p++]=!0,k=0);else{if(!n[p]||k){var s=!!k;if(k=r.length-1,s||!k){if(!k){if(!n[p]){n=[];break}l.splice(o,2,r+l[o+1]),q--,m[p++]=!0,o--;continue}l[o]=r.substring(0,k),l[o+1]=r.substring(k)+l[o+1]}else l.splice(o,1,r.substring(0,k),r.substring(k)),q++,p&&!m[p-1]&&p--;o--;continue}p++,o--}if("undefined"!=typeof f){var t=t||1.25*h.getBBox().height;if(t*n.length>f){n.splice(Math.floor(f/t));break}}}return d.svgDocument?g.removeChild(h):document.body.removeChild(g),n.join("\n")},timing:{linear:function(a){return a},quad:function(a){return a*a},cubic:function(a){return a*a*a},inout:function(a){if(0>=a)return 0;if(a>=1)return 1;var b=a*a,c=b*a;return 4*(.5>a?c:3*(a-b)+c-.75)},exponential:function(a){return Math.pow(2,10*(a-1))},bounce:function(a){for(var b=0,c=1;1;b+=c,c/=2)if(a>=(7-4*b)/11){var d=(11-6*b-11*a)/4;return-d*d+c*c}},reverse:function(a){return function(b){return 1-a(1-b)}},reflect:function(a){return function(b){return.5*(.5>b?a(2*b):2-a(2-2*b))}},clamp:function(a,b,c){return b=b||0,c=c||1,function(d){var e=a(d);return b>e?b:e>c?c:e}},back:function(a){return a||(a=1.70158),function(b){return b*b*((a+1)*b-a)}},elastic:function(a){return a||(a=1.5),function(b){return Math.pow(2,10*(b-1))*Math.cos(20*Math.PI*a/3*b)}}},interpolate:{number:function(a,b){var c=b-a;return function(b){return a+c*b}},object:function(a,b){var c=_.keys(a);return function(d){var e,f,g={};for(e=c.length-1;-1!=e;e--)f=c[e],g[f]=a[f]+(b[f]-a[f])*d;return g}},hexColor:function(a,b){var c=parseInt(a.slice(1),16),d=parseInt(b.slice(1),16),e=255&c,f=(255&d)-e,g=65280&c,h=(65280&d)-g,i=16711680&c,j=(16711680&d)-i;return function(a){var b=255&e+f*a,c=65280&g+h*a,d=16711680&i+j*a;return"#"+(1<<24|b|c|d).toString(16).slice(1)}},unit:function(a,b){var c=/(-?[0-9]*.[0-9]*)(px|em|cm|mm|in|pt|pc|%)/,d=c.exec(a),e=c.exec(b),f=e[1].indexOf("."),g=f>0?e[1].length-f-1:0,a=+d[1],h=+e[1]-a,i=d[2];return function(b){return(a+h*b).toFixed(g)+i}}},filter:{blur:function(a){var b=_.isFinite(a.x)?a.x:2;return _.template('<filter><feGaussianBlur stdDeviation="${stdDeviation}"/></filter>',{stdDeviation:_.isFinite(a.y)?[b,a.y]:b})},dropShadow:function(a){var b="SVGFEDropShadowElement"in window?'<filter><feDropShadow stdDeviation="${blur}" dx="${dx}" dy="${dy}" flood-color="${color}" flood-opacity="${opacity}"/></filter>':'<filter><feGaussianBlur in="SourceAlpha" stdDeviation="${blur}"/><feOffset dx="${dx}" dy="${dy}" result="offsetblur"/><feFlood flood-color="${color}"/><feComposite in2="offsetblur" operator="in"/><feComponentTransfer><feFuncA type="linear" slope="${opacity}"/></feComponentTransfer><feMerge><feMergeNode/><feMergeNode in="SourceGraphic"/></feMerge></filter>';return _.template(b,{dx:a.dx||0,dy:a.dy||0,opacity:_.isFinite(a.opacity)?a.opacity:1,color:a.color||"black",blur:_.isFinite(a.blur)?a.blur:4})},grayscale:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${b} ${h} 0 0 0 0 0 1 0"/></filter>',{a:.2126+.7874*(1-b),b:.7152-.7152*(1-b),c:.0722-.0722*(1-b),d:.2126-.2126*(1-b),e:.7152+.2848*(1-b),f:.0722-.0722*(1-b),g:.2126-.2126*(1-b),h:.0722+.9278*(1-b)})},sepia:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feColorMatrix type="matrix" values="${a} ${b} ${c} 0 0 ${d} ${e} ${f} 0 0 ${g} ${h} ${i} 0 0 0 0 0 1 0"/></filter>',{a:.393+.607*(1-b),b:.769-.769*(1-b),c:.189-.189*(1-b),d:.349-.349*(1-b),e:.686+.314*(1-b),f:.168-.168*(1-b),g:.272-.272*(1-b),h:.534-.534*(1-b),i:.131+.869*(1-b)})},saturate:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feColorMatrix type="saturate" values="${amount}"/></filter>',{amount:1-b})},hueRotate:function(a){return _.template('<filter><feColorMatrix type="hueRotate" values="${angle}"/></filter>',{angle:a.angle||0})},invert:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feComponentTransfer><feFuncR type="table" tableValues="${amount} ${amount2}"/><feFuncG type="table" tableValues="${amount} ${amount2}"/><feFuncB type="table" tableValues="${amount} ${amount2}"/></feComponentTransfer></filter>',{amount:b,amount2:1-b})},brightness:function(a){return _.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}"/><feFuncG type="linear" slope="${amount}"/><feFuncB type="linear" slope="${amount}"/></feComponentTransfer></filter>',{amount:_.isFinite(a.amount)?a.amount:1})},contrast:function(a){var b=_.isFinite(a.amount)?a.amount:1;return _.template('<filter><feComponentTransfer><feFuncR type="linear" slope="${amount}" intercept="${amount2}"/><feFuncG type="linear" slope="${amount}" intercept="${amount2}"/><feFuncB type="linear" slope="${amount}" intercept="${amount2}"/></feComponentTransfer></filter>',{amount:b,amount2:.5-b/2})}},format:{number:function(a,b,c){function d(a){for(var b=a.length,d=[],e=0,f=c.grouping[0];b>0&&f>0;)d.push(a.substring(b-=f,b+f)),f=c.grouping[e=(e+1)%c.grouping.length];return d.reverse().join(c.thousands)}c=c||{currency:["$",""],decimal:".",thousands:",",grouping:[3]};var e=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i,f=e.exec(a),g=f[1]||" ",h=f[2]||">",i=f[3]||"",j=f[4]||"",k=f[5],l=+f[6],m=f[7],n=f[8],o=f[9],p=1,q="",r="",s=!1;switch(n&&(n=+n.substring(1)),(k||"0"===g&&"="===h)&&(k=g="0",h="=",m&&(l-=Math.floor((l-1)/4))),o){case"n":m=!0,o="g";break;case"%":p=100,r="%",o="f";break;case"p":p=100,r="%",o="r";break;case"b":case"o":case"x":case"X":"#"===j&&(q="0"+o.toLowerCase());case"c":case"d":s=!0,n=0;break;case"s":p=-1,o="r"}"$"===j&&(q=c.currency[0],r=c.currency[1]),"r"!=o||n||(o="g"),null!=n&&("g"==o?n=Math.max(1,Math.min(21,n)):("e"==o||"f"==o)&&(n=Math.max(0,Math.min(20,n))));var t=k&&m;if(s&&b%1)return"";var u=0>b||0===b&&0>1/b?(b=-b,"-"):i,v=r;if(0>p){var w=this.prefix(b,n);b=w.scale(b),v=w.symbol+r}else b*=p;b=this.convert(o,b,n);var x=b.lastIndexOf("."),y=0>x?b:b.substring(0,x),z=0>x?"":c.decimal+b.substring(x+1);!k&&m&&c.grouping&&(y=d(y));var A=q.length+y.length+z.length+(t?0:u.length),B=l>A?new Array(A=l-A+1).join(g):"";return t&&(y=d(B+y)),u+=q,b=y+z,("<"===h?u+b+B:">"===h?B+u+b:"^"===h?B.substring(0,A>>=1)+u+b+B.substring(A):u+(t?b:B+b))+v},convert:function(a,b,c){switch(a){case"b":return b.toString(2);case"c":return String.fromCharCode(b);case"o":return b.toString(8);case"x":return b.toString(16);case"X":return b.toString(16).toUpperCase();case"g":return b.toPrecision(c);case"e":return b.toExponential(c);case"f":return b.toFixed(c);case"r":return(b=this.round(b,this.precision(b,c))).toFixed(Math.max(0,Math.min(20,this.precision(b*(1+1e-15),c))));default:return b+""}},round:function(a,b){return b?Math.round(a*(b=Math.pow(10,b)))/b:Math.round(a)},precision:function(a,b){return b-(a?Math.ceil(Math.log(a)/Math.LN10):1)},prefix:function(a,b){var c=_.map(["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"],function(a,b){var c=Math.pow(10,3*abs(8-b));return{scale:b>8?function(a){return a/c}:function(a){return a*c},symbol:a}}),d=0;return a&&(0>a&&(a*=-1),b&&(a=d3.round(a,this.precision(a,b))),d=1+Math.floor(1e-12+Math.log(a)/Math.LN10),d=Math.max(-24,Math.min(24,3*Math.floor((0>=d?d+1:d-1)/3)))),c[8+d/3]}}}};if("object"==typeof exports&&(module.exports=joint),"object"==typeof exports)var joint={dia:{Link:require("./joint.dia.link").Link,Element:require("./joint.dia.element").Element},shapes:require("../plugins/shapes")},Backbone=require("backbone"),_=require("lodash"),g=require("./geometry");if(joint.dia.GraphCells=Backbone.Collection.extend({initialize:function(){this.on("change:z",this.sort,this)},model:function(a,b){if("link"===a.type)return new joint.dia.Link(a,b);var c=a.type.split(".")[0],d=a.type.split(".")[1];return joint.shapes[c]&&joint.shapes[c][d]?new joint.shapes[c][d](a,b):new joint.dia.Element(a,b)},comparator:function(a){return a.get("z")||0},getConnectedLinks:function(a,b){b=b||{},_.isUndefined(b.inbound)&&_.isUndefined(b.outbound)&&(b.inbound=b.outbound=!0);var c=[];return this.each(function(d){var e=d.get("source"),f=d.get("target");e&&e.id===a.id&&b.outbound&&c.push(d),f&&f.id===a.id&&b.inbound&&c.push(d)}),c}}),joint.dia.Graph=Backbone.Model.extend({initialize:function(){this.set("cells",new joint.dia.GraphCells),this.get("cells").on("all",this.trigger,this),this.get("cells").on("remove",this.removeCell,this)},toJSON:function(){var a=Backbone.Model.prototype.toJSON.apply(this,arguments);return a.cells=this.get("cells").toJSON(),a},fromJSON:function(a){if(!a.cells)throw new Error("Graph JSON must contain cells array.");var b=a,c=a.cells;delete b.cells,this.set(b),this.resetCells(c)},clear:function(){this.trigger("batch:start"),this.get("cells").remove(this.get("cells").models),this.trigger("batch:stop")},_prepareCell:function(a){return a instanceof Backbone.Model&&_.isUndefined(a.get("z"))?a.set("z",this.maxZIndex()+1,{silent:!0}):_.isUndefined(a.z)&&(a.z=this.maxZIndex()+1),a},maxZIndex:function(){var a=this.get("cells").last();return a?a.get("z")||0:0},addCell:function(a,b){return _.isArray(a)?this.addCells(a,b):(this.get("cells").add(this._prepareCell(a),b||{}),this)},addCells:function(a,b){return _.each(a,function(a){this.addCell(a,b)},this),this},resetCells:function(a){return this.get("cells").reset(_.map(a,this._prepareCell,this)),this},removeCell:function(a,b,c){c&&c.disconnectLinks?this.disconnectLinks(a):this.removeLinks(a),this.get("cells").remove(a,{silent:!0})},getCell:function(a){return this.get("cells").get(a)},getElements:function(){return this.get("cells").filter(function(a){return a instanceof joint.dia.Element})},getLinks:function(){return this.get("cells").filter(function(a){return a instanceof joint.dia.Link})},getConnectedLinks:function(a,b){return this.get("cells").getConnectedLinks(a,b)},getNeighbors:function(a){var b=this.getConnectedLinks(a),c=[],d=this.get("cells");return _.each(b,function(b){var e=b.get("source"),f=b.get("target");if(!e.x){var g=d.get(e.id);g!==a&&c.push(g)}if(!f.x){var h=d.get(f.id);h!==a&&c.push(h)}}),c},disconnectLinks:function(a){_.each(this.getConnectedLinks(a),function(b){b.set(b.get("source").id===a.id?"source":"target",g.point(0,0))})},removeLinks:function(a){_.invoke(this.getConnectedLinks(a),"remove")},findModelsFromPoint:function(a){return _.filter(this.getElements(),function(b){return b.getBBox().containsPoint(a)})},findModelsInArea:function(a){return _.filter(this.getElements(),function(b){return b.getBBox().intersect(a)})}}),"object"==typeof exports&&(module.exports.Graph=joint.dia.Graph),"object"==typeof exports)var joint={util:require("./core").util,dia:{Link:require("./joint.dia.link").Link}},Backbone=require("backbone"),_=require("lodash");if(joint.dia.Cell=Backbone.Model.extend({constructor:function(a,b){var c,d=a||{};this.cid=_.uniqueId("c"),this.attributes={},b&&b.collection&&(this.collection=b.collection),b&&b.parse&&(d=this.parse(d,b)||{}),(c=_.result(this,"defaults"))&&(d=_.merge({},c,d)),this.set(d,b),this.changed={},this.initialize.apply(this,arguments)},toJSON:function(){var a=this.constructor.prototype.defaults.attrs||{},b=this.attributes.attrs,c={};_.each(b,function(b,d){var e=a[d];_.each(b,function(a,b){_.isObject(a)&&!_.isArray(a)?_.each(a,function(a,f){e&&e[b]&&_.isEqual(e[b][f],a)||(c[d]=c[d]||{},(c[d][b]||(c[d][b]={}))[f]=a)}):e&&_.isEqual(e[b],a)||(c[d]=c[d]||{},c[d][b]=a)})});var d=_.cloneDeep(_.omit(this.attributes,"attrs"));return d.attrs=c,d},initialize:function(a){a&&a.id||this.set("id",joint.util.uuid(),{silent:!0}),this._transitionIds={},this.processPorts(),this.on("change:attrs",this.processPorts,this)},processPorts:function(){var a=this.ports,b={};_.each(this.get("attrs"),function(a){a&&a.port&&(_.isUndefined(a.port.id)?b[a.port]={id:a.port}:b[a.port.id]=a.port)});var c={};if(_.each(a,function(a,d){b[d]||(c[d]=!0)}),this.collection&&!_.isEmpty(c)){var d=this.collection.getConnectedLinks(this,{inbound:!0});_.each(d,function(a){c[a.get("target").port]&&a.remove()});var e=this.collection.getConnectedLinks(this,{outbound:!0});_.each(e,function(a){c[a.get("source").port]&&a.remove()})}this.ports=b},remove:function(a){var b=this.collection;b&&b.trigger("batch:start");var c=this.get("parent");if(c){var d=this.collection&&this.collection.get(c);d.unembed(this)}_.invoke(this.getEmbeddedCells(),"remove",a),this.trigger("remove",this,this.collection,a),b&&b.trigger("batch:stop")},toFront:function(){this.collection&&this.set("z",(this.collection.last().get("z")||0)+1)},toBack:function(){this.collection&&this.set("z",(this.collection.first().get("z")||0)-1)},embed:function(a){if(this.get("parent")==a.id)throw new Error("Recursive embedding not allowed.");this.trigger("batch:start"),a.set("parent",this.id),this.set("embeds",_.uniq((this.get("embeds")||[]).concat([a.id]))),this.trigger("batch:stop")},unembed:function(a){this.trigger("batch:start");var b=a.id;a.unset("parent"),this.set("embeds",_.without(this.get("embeds"),b)),this.trigger("batch:stop")},getEmbeddedCells:function(){return this.collection?_.map(this.get("embeds")||[],function(a){return this.collection.get(a)},this):[]},clone:function(a){a=a||{};var b=Backbone.Model.prototype.clone.apply(this,arguments);if(b.set("id",joint.util.uuid(),{silent:!0}),b.set("embeds",""),!a.deep)return b;var c=this.getEmbeddedCells(),d=[b],e={};return _.each(c,function(a){var c=a.clone({deep:!0});b.embed(c[0]),_.each(c,function(b){if(d.push(b),!(b instanceof joint.dia.Link)){var c=this.collection.getConnectedLinks(a,{inbound:!0});_.each(c,function(a){var c=e[a.id]||a.clone();e[a.id]=c;var d=_.clone(c.get("target"));d.id=b.id,c.set("target",d)});var f=this.collection.getConnectedLinks(a,{outbound:!0});_.each(f,function(a){var c=e[a.id]||a.clone();e[a.id]=c;var d=_.clone(c.get("source"));d.id=b.id,c.set("source",d)})}},this)},this),d=d.concat(_.values(e))},attr:function(a,b,c){var d=this.get("attrs"),e="/";if(_.isString(a)){if("undefined"!=typeof b){var f={};return joint.util.setByPath(f,a,b,e),this.set("attrs",_.merge({},d,f),c)}return joint.util.getByPath(d,a,e)}return this.set("attrs",_.merge({},d,a),b,c)},removeAttr:function(a,b){if(_.isArray(a))return _.each(a,function(a){this.removeAttr(a,b)},this),this;var c=joint.util.unsetByPath(_.merge({},this.get("attrs")),a,"/");return this.set("attrs",c,_.extend({dirty:!0},b))},transition:function(a,b,c,d){d=d||"/";var e={duration:100,delay:10,timingFunction:joint.util.timing.linear,valueFunction:joint.util.interpolate.number};c=_.extend(e,c);var f,g=a.split(d),h=g[0],i=g.length>1,j=0,k=_.bind(function(b){var e,g,l;if(j=j||b,b-=j,g=b/c.duration,1>g?this._transitionIds[a]=e=joint.util.nextFrame(k):(g=1,delete this._transitionIds[a]),l=f(c.timingFunction(g)),i){var m=joint.util.setByPath({},a,l,d)[h];l=_.merge({},this.get(h),m)}c.transitionId=e,this.set(h,l,c),e||this.trigger("transition:end",this,a)},this),l=_.bind(function(e){this.stopTransitions(a),f=c.valueFunction(joint.util.getByPath(this.attributes,a,d),b),this._transitionIds[a]=joint.util.nextFrame(e),this.trigger("transition:start",this,a)},this);return _.delay(l,c.delay,k)},getTransitions:function(){return _.keys(this._transitionIds)},stopTransitions:function(a,b){b=b||"/";var c=a&&a.split(b);_(this._transitionIds).keys().filter(c&&function(a){return _.isEqual(c,a.split(b).slice(0,c.length))}).each(function(a){joint.util.cancelFrame(this._transitionIds[a]),delete this._transitionIds[a],this.trigger("transition:end",this,a)},this)}}),joint.dia.CellView=Backbone.View.extend({tagName:"g",attributes:function(){return{"model-id":this.model.id}},initialize:function(){_.bindAll(this,"remove","update"),this.$el.data("view",this),this.listenTo(this.model,"remove",this.remove),this.listenTo(this.model,"change:attrs",this.onChangeAttrs)},onChangeAttrs:function(a,b,c){return c.dirty?this.render():this.update()},_configure:function(a){a.id=a.id||joint.util.guid(this),Backbone.View.prototype._configure.apply(this,arguments)},_ensureElement:function(){var a;if(this.el)a=_.result(this,"el");else{var b=_.extend({id:this.id},_.result(this,"attributes"));this.className&&(b["class"]=_.result(this,"className")),a=V(_.result(this,"tagName"),b).node}this.setElement(a,!1)},findBySelector:function(a){var b="."===a?this.$el:this.$el.find(a);return b},notify:function(a){if(this.paper){var b=Array.prototype.slice.call(arguments,1);this.trigger.apply(this,[a].concat(b)),this.paper.trigger.apply(this.paper,[a,this].concat(b))}},getStrokeBBox:function(a){var b=!!a;a=a||this.el;var c,d=V(a).bbox(!1,this.paper.viewport);return c=b?V(a).attr("stroke-width"):this.model.attr("rect/stroke-width")||this.model.attr("circle/stroke-width")||this.model.attr("ellipse/stroke-width")||this.model.attr("path/stroke-width"),c=parseFloat(c)||0,g.rect(d).moveAndExpand({x:-c/2,y:-c/2,width:c,height:c})},getBBox:function(){return V(this.el).bbox()},highlight:function(a){a=a?this.$(a)[0]||this.el:this.el,V(a).addClass("highlighted")},unhighlight:function(a){a=a?this.$(a)[0]||this.el:this.el,V(a).removeClass("highlighted")},findMagnet:function(a){var b=this.$(a);if(0===b.length||b[0]===this.el){var c=this.model.get("attrs")||{};return c["."]&&c["."].magnet===!1?void 0:this.el}return b.attr("magnet")?b[0]:this.findMagnet(b.parent())},applyFilter:function(a,b){var c=this.findBySelector(a),d=b.name+this.paper.svg.id+joint.util.hashCode(JSON.stringify(b));if(!this.paper.svg.getElementById(d)){var e=joint.util.filter[b.name]&&joint.util.filter[b.name](b.args||{});if(!e)throw new Error("Non-existing filter "+b.name);var f=V(e);f.attr("filterUnits","userSpaceOnUse"),b.attrs&&f.attr(b.attrs),f.node.id=d,V(this.paper.svg).defs().append(f)}c.each(function(){V(this).attr("filter","url(#"+d+")")})},applyGradient:function(a,b,c){var d=this.findBySelector(a),e=c.type+this.paper.svg.id+joint.util.hashCode(JSON.stringify(c));if(!this.paper.svg.getElementById(e)){var f=["<"+c.type+">",_.map(c.stops,function(a){return'<stop offset="'+a.offset+'" stop-color="'+a.color+'" stop-opacity="'+(_.isFinite(a.opacity)?a.opacity:1)+'" />'}).join(""),"</"+c.type+">"].join(""),g=V(f);c.attrs&&g.attr(c.attrs),g.node.id=e,V(this.paper.svg).defs().append(g)}d.each(function(){V(this).attr(b,"url(#"+e+")")})},getSelector:function(a,b){if(a===this.el)return b;var c=$(a).index();return b=a.tagName+":nth-child("+(c+1)+")"+" "+(b||""),this.getSelector($(a).parent()[0],b+" ")},pointerdblclick:function(a,b,c){this.notify("cell:pointerdblclick",a,b,c)},pointerclick:function(a,b,c){this.notify("cell:pointerclick",a,b,c)},pointerdown:function(a,b,c){this.model.collection&&(this.model.trigger("batch:start"),this._collection=this.model.collection),this.notify("cell:pointerdown",a,b,c)},pointermove:function(a,b,c){this.notify("cell:pointermove",a,b,c)},pointerup:function(a,b,c){this.notify("cell:pointerup",a,b,c),this._collection&&(this._collection.trigger("batch:stop"),delete this._collection)}}),"object"==typeof exports&&(module.exports.Cell=joint.dia.Cell,module.exports.CellView=joint.dia.CellView),"object"==typeof exports)var joint={util:require("./core").util,dia:{Cell:require("./joint.dia.cell").Cell,CellView:require("./joint.dia.cell").CellView}},Backbone=require("backbone"),_=require("lodash");if(joint.dia.Element=joint.dia.Cell.extend({defaults:{position:{x:0,y:0},size:{width:1,height:1},angle:0},position:function(a,b){this.set("position",{x:a,y:b})},translate:function(a,b,c){if(b=b||0,0===a&&0===b)return this;var d=this.get("position")||{x:0,y:0},e={x:d.x+a||0,y:d.y+b||0};return c&&c.transition?(_.isObject(c.transition)||(c.transition={}),this.transition("position",e,_.extend({},c.transition,{valueFunction:joint.util.interpolate.object}))):(this.set("position",e,c),_.invoke(this.getEmbeddedCells(),"translate",a,b,c)),this},resize:function(a,b){return this.trigger("batch:start"),this.set("size",{width:a,height:b}),this.trigger("batch:stop"),this},rotate:function(a,b){return this.set("angle",b?a:((this.get("angle")||0)+a)%360)},getBBox:function(){var a=this.get("position"),b=this.get("size");return g.rect(a.x,a.y,b.width,b.height)}}),joint.dia.ElementView=joint.dia.CellView.extend({className:function(){return"element "+this.model.get("type").split(".").join(" ")},initialize:function(){_.bindAll(this,"translate","resize","rotate"),joint.dia.CellView.prototype.initialize.apply(this,arguments),this.listenTo(this.model,"change:position",this.translate),this.listenTo(this.model,"change:size",this.resize),this.listenTo(this.model,"change:angle",this.rotate)},update:function(a,b){var c=this.model.get("attrs"),d=V(this.$(".rotatable")[0]);if(d){var e=d.attr("transform");d.attr("transform","")}var f=[];_.each(b||c,function(a,b){var c=this.findBySelector(b);if(0!==c.length){var d=["style","text","html","ref-x","ref-y","ref-dx","ref-dy","ref-width","ref-height","ref","x-alignment","y-alignment","port"];_.isObject(a.filter)&&(d.push("filter"),this.applyFilter(b,a.filter)),_.isObject(a.fill)&&(d.push("fill"),this.applyGradient(b,"fill",a.fill)),_.isObject(a.stroke)&&(d.push("stroke"),this.applyGradient(b,"stroke",a.stroke)),_.isUndefined(a.text)||c.each(function(){V(this).text(a.text+"")});var e=_.omit(a,d);c.each(function(){V(this).attr(e)}),a.port&&c.attr("port",_.isUndefined(a.port.id)?a.port:a.port.id),a.style&&c.css(a.style),_.isUndefined(a.html)||c.each(function(){$(this).html(a.html+"")}),_.isUndefined(a["ref-x"])&&_.isUndefined(a["ref-y"])&&_.isUndefined(a["ref-dx"])&&_.isUndefined(a["ref-dy"])&&_.isUndefined(a["x-alignment"])&&_.isUndefined(a["y-alignment"])&&_.isUndefined(a["ref-width"])&&_.isUndefined(a["ref-height"])||_.each(c,function(a,b,c){var d=$(a);d.selector=c.selector,f.push(d)})}},this);var g=this.el.getBBox();b=b||{},_.each(f,function(a){var d=b[a.selector],e=d?_.merge({},c[a.selector],d):c[a.selector];this.positionRelative(a,g,e)},this),d&&d.attr("transform",e||"")},positionRelative:function(a,b,c){function d(a){return _.isNumber(a)&&!_.isNaN(a)}var e=c.ref,f=parseFloat(c["ref-x"]),g=parseFloat(c["ref-y"]),h=parseFloat(c["ref-dx"]),i=parseFloat(c["ref-dy"]),j=c["y-alignment"],k=c["x-alignment"],l=parseFloat(c["ref-width"]),m=parseFloat(c["ref-height"]),n=_.contains(_.pluck(_.pluck(a.parents("g"),"className"),"baseVal"),"scalable");e&&(b=V(this.findBySelector(e)[0]).bbox(!1,this.el));var o=V(a[0]);o.attr("transform")&&o.attr("transform",o.attr("transform").replace(/translate\([^)]*\)/g,"")||"");var p=0,q=0;if(d(l)&&(l>=0&&1>=l?o.attr("width",l*b.width):o.attr("width",Math.max(l+b.width,0))),d(m)&&(m>=0&&1>=m?o.attr("height",m*b.height):o.attr("height",Math.max(m+b.height,0))),d(h))if(n){var r=V(this.$(".scalable")[0]).scale();p=b.x+b.width+h/r.sx}else p=b.x+b.width+h;if(d(i))if(n){var r=V(this.$(".scalable")[0]).scale();q=b.y+b.height+i/r.sy}else q=b.y+b.height+i;if(d(f))if(f>0&&1>f)p=b.x+b.width*f;else if(n){var r=V(this.$(".scalable")[0]).scale();p=b.x+f/r.sx}else p=b.x+f;if(d(g))if(g>0&&1>g)q=b.y+b.height*g;else if(n){var r=V(this.$(".scalable")[0]).scale();q=b.y+g/r.sy}else q=b.y+g;var s=o.bbox(!1,this.paper.viewport);"middle"===j?q-=s.height/2:d(j)&&(q+=j>-1&&1>j?s.height*j:j),"middle"===k?p-=s.width/2:d(k)&&(p+=k>-1&&1>k?s.width*k:k),o.translate(p,q)},renderMarkup:function(){var a=this.model.markup||this.model.get("markup");if(!a)throw new Error("properties.markup is missing while the default render() implementation is used.");var b=V(a);V(this.el).append(b)},render:function(){return this.$el.empty(),this.renderMarkup(),this.update(),this.resize(),this.rotate(),this.translate(),this},scale:function(a,b){V(this.el).scale(a,b)},resize:function(){var a=this.model.get("size")||{width:1,height:1},b=this.model.get("angle")||0,c=V(this.$(".scalable")[0]);if(c){var d=c.bbox(!0);c.attr("transform","scale("+a.width/d.width+","+a.height/d.height+")");var e=V(this.$(".rotatable")[0]),f=e&&e.attr("transform");if(f&&"null"!==f){e.attr("transform",f+" rotate("+-b+","+a.width/2+","+a.height/2+")");var g=c.bbox(!1,this.paper.viewport);this.model.set("position",{x:g.x,y:g.y}),this.rotate()}this.update()}},translate:function(){var a=this.model.get("position")||{x:0,y:0};V(this.el).attr("transform","translate("+a.x+","+a.y+")")},rotate:function(){var a=V(this.$(".rotatable")[0]);if(a){var b=this.model.get("angle")||0,c=this.model.get("size")||{width:1,height:1},d=c.width/2,e=c.height/2;a.attr("transform","rotate("+b+","+d+","+e+")")}},pointerdown:function(a,b,c){if(a.target.getAttribute("magnet")&&this.paper.options.validateMagnet.call(this.paper,this,a.target)){this.model.trigger("batch:start");var d=this.paper.getDefaultLink(this,a.target);d.set({source:{id:this.model.id,selector:this.getSelector(a.target),port:$(a.target).attr("port")},target:{x:b,y:c}}),this.paper.model.addCell(d),this._linkView=this.paper.findViewByModel(d),this._linkView.startArrowheadMove("target")}else this._dx=b,this._dy=c,joint.dia.CellView.prototype.pointerdown.apply(this,arguments)},pointermove:function(a,b,c){if(this._linkView)this._linkView.pointermove(a,b,c);else{var d=this.paper.options.gridSize;if(this.options.interactive!==!1){var e=this.model.get("position");this.model.translate(g.snapToGrid(e.x,d)-e.x+g.snapToGrid(b-this._dx,d),g.snapToGrid(e.y,d)-e.y+g.snapToGrid(c-this._dy,d))}this._dx=g.snapToGrid(b,d),this._dy=g.snapToGrid(c,d),joint.dia.CellView.prototype.pointermove.apply(this,arguments)}},pointerup:function(a,b,c){this._linkView?(this._linkView.pointerup(a,b,c),delete this._linkView,this.model.trigger("batch:stop")):joint.dia.CellView.prototype.pointerup.apply(this,arguments)}}),"object"==typeof exports&&(module.exports.Element=joint.dia.Element,module.exports.ElementView=joint.dia.ElementView),"object"==typeof exports)var joint={dia:{Cell:require("./joint.dia.cell").Cell,CellView:require("./joint.dia.cell").CellView}},Backbone=require("backbone"),_=require("lodash"),g=require("./geometry");if(joint.dia.Link=joint.dia.Cell.extend({markup:['<path class="connection" stroke="black"/>','<path class="marker-source" fill="black" stroke="black" />','<path class="marker-target" fill="black" stroke="black" />','<path class="connection-wrap"/>','<g class="labels"/>','<g class="marker-vertices"/>','<g class="marker-arrowheads"/>','<g class="link-tools"/>'].join(""),labelMarkup:['<g class="label">',"<rect />","<text />","</g>"].join(""),toolMarkup:['<g class="link-tool">','<g class="tool-remove" event="remove">','<circle r="11" />','<path transform="scale(.8) translate(-16, -16)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z"/>',"<title>Remove link.</title>","</g>",'<g class="tool-options" event="link:options">','<circle r="11" transform="translate(25)"/>','<path fill="white" transform="scale(.55) translate(29, -16)" d="M31.229,17.736c0.064-0.571,0.104-1.148,0.104-1.736s-0.04-1.166-0.104-1.737l-4.377-1.557c-0.218-0.716-0.504-1.401-0.851-2.05l1.993-4.192c-0.725-0.91-1.549-1.734-2.458-2.459l-4.193,1.994c-0.647-0.347-1.334-0.632-2.049-0.849l-1.558-4.378C17.165,0.708,16.588,0.667,16,0.667s-1.166,0.041-1.737,0.105L12.707,5.15c-0.716,0.217-1.401,0.502-2.05,0.849L6.464,4.005C5.554,4.73,4.73,5.554,4.005,6.464l1.994,4.192c-0.347,0.648-0.632,1.334-0.849,2.05l-4.378,1.557C0.708,14.834,0.667,15.412,0.667,16s0.041,1.165,0.105,1.736l4.378,1.558c0.217,0.715,0.502,1.401,0.849,2.049l-1.994,4.193c0.725,0.909,1.549,1.733,2.459,2.458l4.192-1.993c0.648,0.347,1.334,0.633,2.05,0.851l1.557,4.377c0.571,0.064,1.148,0.104,1.737,0.104c0.588,0,1.165-0.04,1.736-0.104l1.558-4.377c0.715-0.218,1.399-0.504,2.049-0.851l4.193,1.993c0.909-0.725,1.733-1.549,2.458-2.458l-1.993-4.193c0.347-0.647,0.633-1.334,0.851-2.049L31.229,17.736zM16,20.871c-2.69,0-4.872-2.182-4.872-4.871c0-2.69,2.182-4.872,4.872-4.872c2.689,0,4.871,2.182,4.871,4.872C20.871,18.689,18.689,20.871,16,20.871z"/>',"<title>Link options.</title>","</g>","</g>"].join(""),vertexMarkup:['<g class="marker-vertex-group" transform="translate(<%= x %>, <%= y %>)">','<circle class="marker-vertex" idx="<%= idx %>" r="10" />','<path class="marker-vertex-remove-area" idx="<%= idx %>" d="M16,5.333c-7.732,0-14,4.701-14,10.5c0,1.982,0.741,3.833,2.016,5.414L2,25.667l5.613-1.441c2.339,1.317,5.237,2.107,8.387,2.107c7.732,0,14-4.701,14-10.5C30,10.034,23.732,5.333,16,5.333z" transform="translate(5, -33)"/>','<path class="marker-vertex-remove" idx="<%= idx %>" transform="scale(.8) translate(9.5, -37)" d="M24.778,21.419 19.276,15.917 24.777,10.415 21.949,7.585 16.447,13.087 10.945,7.585 8.117,10.415 13.618,15.917 8.116,21.419 10.946,24.248 16.447,18.746 21.948,24.248z">',"<title>Remove vertex.</title>","</path>","</g>"].join(""),arrowheadMarkup:['<g class="marker-arrowhead-group marker-arrowhead-group-<%= end %>">','<path class="marker-arrowhead" end="<%= end %>" d="M 26 0 L 0 13 L 26 26 z" />',"</g>"].join(""),defaults:{type:"link"},disconnect:function(){return this.set({source:g.point(0,0),target:g.point(0,0)})
},label:function(a,b){a=a||0;var c=this.get("labels")||[];if(0===arguments.length||1===arguments.length)return c[a];var d=_.merge({},c[a],b),e=c.slice();return e[a]=d,this.set({labels:e})}}),joint.dia.LinkView=joint.dia.CellView.extend({className:function(){return _.unique(this.model.get("type").split(".").concat("link")).join(" ")},options:{shortLinkLength:100},initialize:function(){joint.dia.CellView.prototype.initialize.apply(this,arguments),"function"!=typeof this.constructor.prototype.watchSource&&(this.constructor.prototype.watchSource=this._createWatcher("source"),this.constructor.prototype.watchTarget=this._createWatcher("target")),this._labelCache={},this._markerCache={},this.startListening()},startListening:function(){this.listenTo(this.model,"change:markup",this.render),this.listenTo(this.model,"change:smooth change:manhattan change:router change:connector",this.update),this.listenTo(this.model,"change:toolMarkup",function(){this.renderTools().updateToolsPosition()}),this.listenTo(this.model,"change:labels change:labelMarkup",function(){this.renderLabels().updateLabelPositions()}),this.listenTo(this.model,"change:vertices change:vertexMarkup",function(){this.renderVertexMarkers().update()}),this.listenTo(this.model,"change:source",function(a,b){this.watchSource(a,b).update()}),this.listenTo(this.model,"change:target",function(a,b){this.watchTarget(a,b).update()})},render:function(){this.$el.empty();var a=V(this.model.get("markup")||this.model.markup);if(_.isArray(a)||(a=[a]),this._V={},_.each(a,function(a){var b=a.attr("class");b&&(this._V[$.camelCase(b)]=a)},this),!this._V.connection)throw new Error("link: no connection path in the markup");return this.renderTools(),this.renderVertexMarkers(),this.renderArrowheadMarkers(),V(this.el).append(a),this.renderLabels(),this.watchSource(this.model,this.model.get("source")).watchTarget(this.model,this.model.get("target")).update(),this},renderLabels:function(){if(!this._V.labels)return this;this._labelCache={};var a=$(this._V.labels.node).empty(),b=this.model.get("labels")||[];if(!b.length)return this;var c=_.template(this.model.get("labelMarkup")||this.model.labelMarkup),d=V(c());return _.each(b,function(b,c){var e=d.clone().node;this._labelCache[c]=V(e);var f=$(e).find("text"),g=$(e).find("rect"),h=_.extend({"text-anchor":"middle","font-size":14},joint.util.getByPath(b,"attrs/text","/"));f.attr(_.omit(h,"text")),_.isUndefined(h.text)||V(f[0]).text(h.text+""),a.append(e);var i=V(f[0]).bbox(!0,a[0]);V(f[0]).translate(0,-i.height/2);var j=_.extend({fill:"white",rx:3,ry:3},joint.util.getByPath(b,"attrs/rect","/"));g.attr(_.extend(j,{x:i.x,y:i.y-i.height/2,width:i.width,height:i.height}))},this),this},renderTools:function(){if(!this._V.linkTools)return this;var a=$(this._V.linkTools.node).empty(),b=_.template(this.model.get("toolMarkup")||this.model.toolMarkup),c=V(b());return a.append(c.node),this._toolCache=c,this},renderVertexMarkers:function(){if(!this._V.markerVertices)return this;var a=$(this._V.markerVertices.node).empty(),b=_.template(this.model.get("vertexMarkup")||this.model.vertexMarkup);return _.each(this.model.get("vertices"),function(c,d){a.append(V(b(_.extend({idx:d},c))).node)}),this},renderArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;var a=$(this._V.markerArrowheads.node);a.empty();var b=_.template(this.model.get("arrowheadMarkup")||this.model.arrowheadMarkup);return this._V.sourceArrowhead=V(b({end:"source"})),this._V.targetArrowhead=V(b({end:"target"})),a.append(this._V.sourceArrowhead.node,this._V.targetArrowhead.node),this},update:function(){_.each(this.model.get("attrs"),function(a,b){_.isObject(a.filter)?(this.findBySelector(b).attr(_.omit(a,"filter")),this.applyFilter(b,a.filter)):this.findBySelector(b).attr(a)},this);var a=this.route=this.findRoute(this.model.get("vertices")||[]);this._findConnectionPoints(a);var b=this.getPathData(a);return this._V.connection.attr("d",b),this._V.connectionWrap&&this._V.connectionWrap.attr("d",b),this._translateAndAutoOrientArrows(this._V.markerSource,this._V.markerTarget),this.updateLabelPositions(),this.updateToolsPosition(),this.updateArrowheadMarkers(),delete this.options.perpendicular,this},_findConnectionPoints:function(a){var b,c,d,e,f=_.first(a);b=this.getConnectionPoint("source",this.model.get("source"),f||this.model.get("target")).round();var h=_.last(a);c=this.getConnectionPoint("target",this.model.get("target"),h||b).round();var i=this._markerCache;this._V.markerSource&&(i.sourceBBox=i.sourceBBox||this._V.markerSource.bbox(!0),d=g.point(b).move(f||c,-1*i.sourceBBox.width*this._V.markerSource.scale().sx).round()),this._V.markerTarget&&(i.targetBBox=i.targetBBox||this._V.markerTarget.bbox(!0),e=g.point(c).move(h||b,-1*i.targetBBox.width*this._V.markerTarget.scale().sx).round()),i.sourcePoint=d||b,i.targetPoint=e||c,this.sourcePoint=b,this.targetPoint=c},updateLabelPositions:function(){if(!this._V.labels)return this;var a=this.model.get("labels")||[];if(!a.length)return this;var b=this._V.connection.node,c=b.getTotalLength();return _.each(a,function(a,d){var e=a.position;e=e>c?c:e,e=0>e?c+e:e,e=e>1?e:c*e;var f=b.getPointAtLength(e);this._labelCache[d].attr("transform","translate("+f.x+", "+f.y+")")},this),this},updateToolsPosition:function(){if(!this._V.linkTools)return this;var a="",b=40;this.getConnectionLength()<this.options.shortLinkLength&&(a="scale(.5)",b/=2);var c=this.getPointAtLength(b);return this._toolCache.attr("transform","translate("+c.x+", "+c.y+") "+a),this},updateArrowheadMarkers:function(){if(!this._V.markerArrowheads)return this;if("none"===$.css(this._V.markerArrowheads.node,"display"))return this;var a=this.getConnectionLength()<this.options.shortLinkLength?.5:1;return this._V.sourceArrowhead.scale(a),this._V.targetArrowhead.scale(a),this._translateAndAutoOrientArrows(this._V.sourceArrowhead,this._V.targetArrowhead),this},_createWatcher:function(a){function b(b,c){c=c||{};var d=b.previous(a)||{},e=this["_"+a+"BBoxUpdate"];return this._isModel(d)&&this.stopListening(this.paper.getModelById(d.id),"change",e),this._isModel(c)&&this.listenTo(this.paper.getModelById(c.id),"change",e),_.bind(e,this)({cacheOnly:!0}),this}return b},_sourceBBoxUpdate:function(a){this.lastEndChange="source",a=a||{};var b=this.model.get("source");if(this._isModel(b)){var c=this._makeSelector(b),d=this.paper.findViewByModel(b.id),e=this.paper.viewport.querySelector(c);this.sourceBBox=d.getStrokeBBox(e)}else this.sourceBBox=g.rect(b.x,b.y,1,1);a.cacheOnly||this.update()},_targetBBoxUpdate:function(a){this.lastEndChange="target",a=a||{};var b=this.model.get("target");if(this._isModel(b)){var c=this._makeSelector(b),d=this.paper.findViewByModel(b.id),e=this.paper.viewport.querySelector(c);this.targetBBox=d.getStrokeBBox(e)}else this.targetBBox=g.rect(b.x,b.y,1,1);a.cacheOnly||this.update()},_translateAndAutoOrientArrows:function(a,b){a&&a.translateAndAutoOrient(this.sourcePoint,_.first(this.route)||this.targetPoint,this.paper.viewport),b&&b.translateAndAutoOrient(this.targetPoint,_.last(this.route)||this.sourcePoint,this.paper.viewport)},removeVertex:function(a){var b=_.clone(this.model.get("vertices"));return b&&b.length&&(b.splice(a,1),this.model.set("vertices",b)),this},addVertex:function(a){this.model.set("attrs",this.model.get("attrs")||{}),this.model.get("attrs");for(var b,c=(this.model.get("vertices")||[]).slice(),d=c.slice(),e=this._V.connection.node.cloneNode(!1),f=e.getTotalLength(),g=20,h=c.length+1;h--&&(c.splice(h,0,a),V(e).attr("d",this.getPathData(this.findRoute(c))),b=e.getTotalLength(),b-f>g);)c=d.slice();return this.model.set("vertices",c),Math.max(h,0)},findRoute:function(a){var b=this.model.get("router");if(!b){if(!this.model.get("manhattan"))return a;b={name:"orthogonal"}}var c=joint.routers[b.name];if(!_.isFunction(c))throw"unknown router: "+b.name;var d=c.call(this,a||[],b.args||{},this);return d},getPathData:function(a){var b=this.model.get("connector");if(b||(b=this.model.get("smooth")?{name:"smooth"}:{name:"normal"}),!_.isFunction(joint.connectors[b.name]))throw"unknown connector: "+b.name;var c=joint.connectors[b.name].call(this,this._markerCache.sourcePoint,this._markerCache.targetPoint,a||this.model.get("vertices")||{},b.args||{},this);return c},getConnectionPoint:function(a,b,c){var d;if(this._isPoint(b))d=g.point(b);else{var e,f="source"===a?this.sourceBBox:this.targetBBox;if(this._isPoint(c))e=g.point(c);else{var h="source"===a?this.targetBBox:this.sourceBBox;e=g.rect(h).intersectionWithLineFromCenterToPoint(g.rect(f).center()),e=e||g.rect(h).center()}if(this.paper.options.perpendicularLinks||this.options.perpendicular){var i,j=g.rect(0,e.y,this.paper.options.width,1),k=g.rect(e.x,0,1,this.paper.options.height);if(j.intersect(g.rect(f)))switch(i=g.rect(f).sideNearestToPoint(e)){case"left":d=g.point(f.x,e.y);break;case"right":d=g.point(f.x+f.width,e.y);break;default:d=g.rect(f).center()}else if(k.intersect(g.rect(f)))switch(i=g.rect(f).sideNearestToPoint(e)){case"top":d=g.point(e.x,f.y);break;case"bottom":d=g.point(e.x,f.y+f.height);break;default:d=g.rect(f).center()}else d=g.rect(f).intersectionWithLineFromCenterToPoint(e),d=d||g.rect(f).center()}else d=g.rect(f).intersectionWithLineFromCenterToPoint(e),d=d||g.rect(f).center()}return d},_isModel:function(a){return a&&a.id},_isPoint:function(a){return!this._isModel(a)},_makeSelector:function(a){var b='[model-id="'+a.id+'"]';return a.port?b+=' [port="'+a.port+'"]':a.selector&&(b+=" "+a.selector),b},getConnectionLength:function(){return this._V.connection.node.getTotalLength()},getPointAtLength:function(a){return this._V.connection.node.getPointAtLength(a)},_beforeArrowheadMove:function(){this.model.trigger("batch:start"),this._z=this.model.get("z"),this.model.set("z",Number.MAX_VALUE),this.el.style.pointerEvents="none"},_afterArrowheadMove:function(){this._z&&(this.model.set("z",this._z),delete this._z),this.el.style.pointerEvents="visiblePainted",this.model.trigger("batch:stop")},_createValidateConnectionArgs:function(a){function b(a,b){return c[f]=a,c[f+1]=a.el===b?void 0:b,c}var c=[];c[4]=a,c[5]=this;var d,e=0,f=0;"source"===a?(e=2,d="target"):(f=2,d="source");var g=this.model.get(d);return g.id&&(c[e]=this.paper.findViewByModel(g.id),c[e+1]=g.selector&&c[e].el.querySelector(g.selector)),b},startArrowheadMove:function(a){this._action="arrowhead-move",this._arrowhead=a,this._beforeArrowheadMove(),this._validateConnectionArgs=this._createValidateConnectionArgs(this._arrowhead)},pointerdown:function(a,b,c){if(joint.dia.CellView.prototype.pointerdown.apply(this,arguments),this._dx=b,this._dy=c,this.options.interactive!==!1){var d=a.target.getAttribute("class");switch(d){case"marker-vertex":this._action="vertex-move",this._vertexIdx=a.target.getAttribute("idx");break;case"marker-vertex-remove":case"marker-vertex-remove-area":this.removeVertex(a.target.getAttribute("idx"));break;case"marker-arrowhead":this.startArrowheadMove(a.target.getAttribute("end"));break;default:var e=a.target.parentNode.getAttribute("event");e?"remove"===e?this.model.remove():this.paper.trigger(e,a,this,b,c):(this._vertexIdx=this.addVertex({x:b,y:c}),this._action="vertex-move")}}},pointermove:function(a,b,c){switch(joint.dia.CellView.prototype.pointermove.apply(this,arguments),this._action){case"vertex-move":var d=_.clone(this.model.get("vertices"));d[this._vertexIdx]={x:b,y:c},this.model.set("vertices",d);break;case"arrowhead-move":if(this.paper.options.snapLinks){var e=this.paper.options.snapLinks.radius||50,f=this.paper.findViewsInArea({x:b-e,y:c-e,width:2*e,height:2*e});this._closestView&&this._closestView.unhighlight(this._closestEnd.selector),this._closestView=this._closestEnd=null;var h,i=g.point(b,c),j=Number.MAX_VALUE;_.each(f,function(a){"false"!==a.el.getAttribute("magnet")&&(h=a.model.getBBox().center().distance(i),e>h&&j>h&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(a,null))&&(j=h,this._closestView=a,this._closestEnd={id:a.model.id})),a.$("[magnet]").each(_.bind(function(b,c){var d=V(c).bbox(!1,this.paper.viewport);h=i.distance({x:d.x+d.width/2,y:d.y+d.height/2}),e>h&&j>h&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(a,c))&&(j=h,this._closestView=a,this._closestEnd={id:a.model.id,selector:a.getSelector(c),port:c.getAttribute("port")})},this))},this),this._closestView&&this._closestView.highlight(this._closestEnd.selector),this.model.set(this._arrowhead,this._closestEnd||{x:b,y:c})}else{var k="mousemove"===a.type?a.target:document.elementFromPoint(a.clientX,a.clientY);this._targetEvent!==k&&(this._magnetUnderPointer&&this._viewUnderPointer.unhighlight(this._magnetUnderPointer),this._viewUnderPointer=this.paper.findView(k),this._viewUnderPointer?(this._magnetUnderPointer=this._viewUnderPointer.findMagnet(k),this._magnetUnderPointer&&this.paper.options.validateConnection.apply(this.paper,this._validateConnectionArgs(this._viewUnderPointer,this._magnetUnderPointer))?this._magnetUnderPointer&&this._viewUnderPointer.highlight(this._magnetUnderPointer):this._magnetUnderPointer=null):this._magnetUnderPointer=null),this._targetEvent=k,this.model.set(this._arrowhead,{x:b,y:c})}}this._dx=b,this._dy=c},pointerup:function(){joint.dia.CellView.prototype.pointerup.apply(this,arguments),"arrowhead-move"===this._action&&(this.paper.options.snapLinks?(this._closestView&&this._closestView.unhighlight(this._closestEnd.selector),this._closestView=this._closestEnd=null):(this._magnetUnderPointer&&(this._viewUnderPointer.unhighlight(this._magnetUnderPointer),this.model.set(this._arrowhead,{id:this._viewUnderPointer.model.id,selector:this._viewUnderPointer.getSelector(this._magnetUnderPointer),port:$(this._magnetUnderPointer).attr("port")})),delete this._viewUnderPointer,delete this._magnetUnderPointer,delete this._staticView,delete this._staticMagnet),this._afterArrowheadMove()),delete this._action}}),"object"==typeof exports&&(module.exports.Link=joint.dia.Link,module.exports.LinkView=joint.dia.LinkView),joint.dia.Paper=Backbone.View.extend({options:{width:800,height:600,gridSize:50,perpendicularLinks:!1,elementView:joint.dia.ElementView,linkView:joint.dia.LinkView,snapLinks:!1,defaultLink:new joint.dia.Link,validateMagnet:function(a,b){return"passive"!==b.getAttribute("magnet")},validateConnection:function(a,b,c,d,e){return("target"===e?c:a)instanceof joint.dia.ElementView}},events:{mousedown:"pointerdown",dblclick:"mousedblclick",click:"mouseclick",touchstart:"pointerdown",mousemove:"pointermove",touchmove:"pointermove"},initialize:function(){_.bindAll(this,"addCell","sortCells","resetCells","pointerup"),this.svg=V("svg").node,this.viewport=V("g").node,V(this.svg).append(V("defs").node),V(this.viewport).attr({"class":"viewport"}),V(this.svg).append(this.viewport),this.$el.append(this.svg),this.setDimensions(),this.listenTo(this.model,"add",this.addCell),this.listenTo(this.model,"reset",this.resetCells),this.listenTo(this.model,"sort",this.sortCells),$(document).on("mouseup touchend",this.pointerup),this._mousemoved=!1},remove:function(){$(document).off("mouseup touchend",this.pointerup),Backbone.View.prototype.remove.call(this)},setDimensions:function(a,b){a&&(this.options.width=a),b&&(this.options.height=b),V(this.svg).attr("width",this.options.width),V(this.svg).attr("height",this.options.height),this.trigger("resize")},fitToContent:function(a,b,c){a=a||1,b=b||1,c=c||0;var d=V(this.viewport).bbox(!0,this.svg),e=Math.ceil((d.width+d.x)/a)*a,f=Math.ceil((d.height+d.y)/b)*b;e+=c,f+=c,(e!=this.options.width||f!=this.options.height)&&this.setDimensions(e||this.options.width,f||this.options.height)},getContentBBox:function(){var a=this.viewport.getBoundingClientRect(),b=this.viewport.getScreenCTM(),c=g.rect(Math.abs(a.left-b.e),Math.abs(a.top-b.f),a.width,a.height);return c},createViewForModel:function(a){var b,c=a.get("type"),d=c.split(".")[0],e=c.split(".")[1];return b=joint.shapes[d]&&joint.shapes[d][e+"View"]?new joint.shapes[d][e+"View"]({model:a,interactive:this.options.interactive}):a instanceof joint.dia.Element?new this.options.elementView({model:a,interactive:this.options.interactive}):new this.options.linkView({model:a,interactive:this.options.interactive})},addCell:function(a){var b=this.createViewForModel(a);V(this.viewport).append(b.el),b.paper=this,b.render(),$(b.el).find("image").on("dragstart",function(){return!1})},resetCells:function(a){$(this.viewport).empty();var b=a.models.slice();b.sort(function(a){return a instanceof joint.dia.Link?1:-1}),_.each(b,this.addCell,this),this.sortCells()},sortCells:function(){var a=$(this.viewport).children("[model-id]"),b=this.model.get("cells");this.sortElements(a,function(a,c){var d=b.get($(a).attr("model-id")),e=b.get($(c).attr("model-id"));return(d.get("z")||0)>(e.get("z")||0)?1:-1})},sortElements:function(a,b){var c=$(a),d=c.map(function(){var a=this,b=a.parentNode,c=b.insertBefore(document.createTextNode(""),a.nextSibling);return function(){if(b===this)throw new Error("You can't sort elements if any one is a descendant of another.");b.insertBefore(this,c),b.removeChild(c)}});return Array.prototype.sort.call(c,b).each(function(a){d[a].call(this)})},scale:function(a,b,c,d){return c||(c=0,d=0),V(this.viewport).attr("transform",""),(c||d)&&V(this.viewport).translate(-c*(a-1),-d*(b-1)),V(this.viewport).scale(a,b),this.trigger("scale",c,d),this},rotate:function(a,b,c){if(_.isUndefined(b)){var d=this.viewport.getBBox();b=d.width/2,c=d.height/2}V(this.viewport).rotate(a,b,c)},findView:function(a){var b=this.$(a);return 0===b.length||b[0]===this.el?void 0:b.data("view")?b.data("view"):this.findView(b.parent())},findViewByModel:function(a){var b=_.isString(a)?a:a.id,c=this.$('[model-id="'+b+'"]');return c.length?c.data("view"):void 0},findViewsFromPoint:function(a){a=g.point(a);var b=_.map(this.model.getElements(),this.findViewByModel);return _.filter(b,function(b){return g.rect(V(b.el).bbox(!1,this.viewport)).containsPoint(a)},this)},findViewsInArea:function(a){a=g.rect(a);var b=_.map(this.model.getElements(),this.findViewByModel);return _.filter(b,function(b){return a.intersect(g.rect(V(b.el).bbox(!1,this.viewport)))},this)},getModelById:function(a){return this.model.getCell(a)},snapToGrid:function(a){var b=V(this.viewport).toLocalPoint(a.x,a.y);return{x:g.snapToGrid(b.x,this.options.gridSize),y:g.snapToGrid(b.y,this.options.gridSize)}},getDefaultLink:function(a,b){return _.isFunction(this.options.defaultLink)?this.options.defaultLink.call(this,a,b):this.options.defaultLink.clone()},mousedblclick:function(a){a.preventDefault(),a=joint.util.normalizeEvent(a);var b=this.findView(a.target),c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.pointerdblclick(a,c.x,c.y):this.trigger("blank:pointerdblclick",a,c.x,c.y)},mouseclick:function(a){if(!this._mousemoved){a.preventDefault(),a=joint.util.normalizeEvent(a);var b=this.findView(a.target),c=this.snapToGrid({x:a.clientX,y:a.clientY});b?b.pointerclick(a,c.x,c.y):this.trigger("blank:pointerclick",a,c.x,c.y)}this._mousemoved=!1},pointerdown:function(a){a.preventDefault(),a=joint.util.normalizeEvent(a);var b=this.findView(a.target),c=this.snapToGrid({x:a.clientX,y:a.clientY});b?(this.sourceView=b,b.pointerdown(a,c.x,c.y)):this.trigger("blank:pointerdown",a,c.x,c.y)},pointermove:function(a){if(a.preventDefault(),a=joint.util.normalizeEvent(a),this.sourceView){this._mousemoved=!0;var b=this.snapToGrid({x:a.clientX,y:a.clientY});this.sourceView.pointermove(a,b.x,b.y)}},pointerup:function(a){a=joint.util.normalizeEvent(a);var b=this.snapToGrid({x:a.clientX,y:a.clientY});this.sourceView?(this.sourceView.pointerup(a,b.x,b.y),this.sourceView=null):this.trigger("blank:pointerup",a,b.x,b.y)}}),"object"==typeof exports)var joint={util:require("../src/core").util,shapes:{},dia:{Element:require("../src/joint.dia.element").Element,ElementView:require("../src/joint.dia.element").ElementView}},_=require("lodash");if(joint.shapes.basic={},joint.shapes.basic.Generic=joint.dia.Element.extend({defaults:joint.util.deepSupplement({type:"basic.Generic",attrs:{".":{fill:"#FFFFFF",stroke:"none"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.basic.Rect=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><rect/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Rect",attrs:{rect:{fill:"#FFFFFF",stroke:"black",width:100,height:60},text:{"font-size":14,text:"","ref-x":.5,"ref-y":.5,ref:"rect","y-alignment":"middle","x-alignment":"middle",fill:"black","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Text=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><text/></g></g>',defaults:joint.util.deepSupplement({type:"basic.Text",attrs:{text:{"font-size":18,fill:"black"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Circle=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Circle",size:{width:60,height:60},attrs:{circle:{fill:"#FFFFFF",stroke:"black",r:30,transform:"translate(30, 30)"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-y":.5,ref:"circle","y-alignment":"middle",fill:"black","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Image=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><image/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Image",attrs:{text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,ref:"image","y-alignment":"middle",fill:"black","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.Path=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path/></g><text/></g>',defaults:joint.util.deepSupplement({type:"basic.Path",size:{width:60,height:60},attrs:{path:{fill:"#FFFFFF",stroke:"black"},text:{"font-size":14,text:"","text-anchor":"middle","ref-x":.5,"ref-dy":20,ref:"path","y-alignment":"middle",fill:"black","font-family":"Arial, helvetica, sans-serif"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.basic.PortsModelInterface={initialize:function(){this.updatePortsAttrs(),this.on("change:inPorts change:outPorts",this.updatePortsAttrs,this),this.constructor.__super__.constructor.__super__.initialize.apply(this,arguments)},updatePortsAttrs:function(){var a=this.get("attrs");_.each(this._portSelectors,function(b){a[b]&&delete a[b]}),this._portSelectors=[];var b={};_.each(this.get("inPorts"),function(a,c,d){var e=this.getPortAttrs(a,c,d.length,".inPorts","in");this._portSelectors=this._portSelectors.concat(_.keys(e)),_.extend(b,e)},this),_.each(this.get("outPorts"),function(a,c,d){var e=this.getPortAttrs(a,c,d.length,".outPorts","out");this._portSelectors=this._portSelectors.concat(_.keys(e)),_.extend(b,e)},this),this.attr(b,{silent:!0}),this.processPorts(),this.trigger("process:ports")},getPortSelector:function(a){var b=".inPorts",c=this.get("inPorts").indexOf(a);if(0>c&&(b=".outPorts",c=this.get("outPorts").indexOf(a),0>c))throw new Error("getPortSelector(): Port doesn't exist.");return b+">g:nth-child("+(c+1)+")>circle"}},joint.shapes.basic.PortsViewInterface={initialize:function(){this.listenTo(this.model,"process:ports",this.update),joint.dia.ElementView.prototype.initialize.apply(this,arguments)},update:function(){this.renderPorts(),joint.dia.ElementView.prototype.update.apply(this,arguments)},renderPorts:function(){var a=this.$(".inPorts").empty(),b=this.$(".outPorts").empty(),c=_.template(this.model.portMarkup);_.each(_.filter(this.model.ports,function(a){return"in"===a.type}),function(b,d){a.append(V(c({id:d,port:b})).node)}),_.each(_.filter(this.model.ports,function(a){return"out"===a.type}),function(a,d){b.append(V(c({id:d,port:a})).node)})}},joint.shapes.basic.TextBlock=joint.shapes.basic.Generic.extend({markup:['<g class="rotatable"><g class="scalable"><rect/></g><switch>','<foreignObject requiredFeatures="http://www.w3.org/TR/SVG11/feature#Extensibility" class="fobj">','<body xmlns="http://www.w3.org/1999/xhtml"><div/></body>',"</foreignObject>",'<text class="content"/>',"</switch></g>"].join(""),defaults:joint.util.deepSupplement({type:"basic.TextBlock",attrs:{rect:{fill:"#ffffff",stroke:"#000000",width:80,height:100},text:{fill:"#000000","font-size":14,"font-family":"Arial, helvetica, sans-serif"},".content":{text:"",ref:"rect","ref-x":.5,"ref-y":.5,"y-alignment":"middle","x-alignment":"middle"}},content:""},joint.shapes.basic.Generic.prototype.defaults),initialize:function(){"undefined"!=typeof SVGForeignObjectElement&&(this.setForeignObjectSize(this,this.get("size")),this.setDivContent(this,this.get("content")),this.listenTo(this,"change:size",this.setForeignObjectSize),this.listenTo(this,"change:content",this.setDivContent)),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},setForeignObjectSize:function(a,b){a.attr({".fobj":_.clone(b),div:{style:_.clone(b)}})},setDivContent:function(a,b){a.attr({div:{html:b}})}}),joint.shapes.basic.TextBlockView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),"undefined"==typeof SVGForeignObjectElement&&(this.noSVGForeignObjectElement=!0,this.listenTo(this.model,"change:content",function(a){this.updateContent(a)}))},update:function(a,b){if(this.noSVGForeignObjectElement){var c=this.model,d=_.omit(b||c.get("attrs"),".content");joint.dia.ElementView.prototype.update.call(this,c,d),(!b||_.has(b,".content"))&&this.updateContent(c,b)}else joint.dia.ElementView.prototype.update.call(this,c,b)},updateContent:function(a,b){var c=_.merge({},(b||a.get("attrs"))[".content"]);delete c.text;var d=joint.util.breakText(a.get("content"),a.get("size"),c,{svgDocument:this.paper.svg}),e=joint.util.setByPath({},".content",c,"/");e[".content"].text=d,joint.dia.ElementView.prototype.update.call(this,a,e)}}),"object"==typeof exports&&(module.exports=joint.shapes.basic),joint.routers.orthogonal=function(){function a(a,b){return a.y<b.y&&a.x===b.x?"down":a.y>b.y&&a.x===b.x?"up":a.x<b.x&&a.y===b.y?"right":"left"}function b(a,b,c){var d;if(d=a.x<b.x?a.y>b.y?["up","right"]:a.y<b.y?["down","right"]:["right"]:a.x>b.x?a.y>b.y?["up","left"]:a.y<b.y?["down","left"]:["left"]:a.y>b.y?["up"]:["down"],_.contains(d,c))return c;var e=_.first(d);switch(c){case"down":if("up"===e)return _.last(d);break;case"up":if("down"===e)return _.last(d);break;case"left":if("right"===e)return _.last(d);break;case"right":if("left"===e)return _.last(d)}return e}function c(a,c,d){var e=b(a,c,d);return"down"===e||"up"===e?{x:a.x,y:c.y,d:e}:{x:c.x,y:a.y,d:e}}function d(b){b=(b||[]).slice();var d=[],h=e.center(),i=f.center();b.length||(Math.abs(h.x-i.x)<e.width/2||Math.abs(h.y-i.y)<e.height/2)&&(b=[{x:Math.min(h.x,i.x)+Math.abs(h.x-i.x)/2,y:Math.min(h.y,i.y)+Math.abs(h.y-i.y)/2}]),b.unshift(h),b.push(i);for(var j,k,l,m,n=0;n<b.length-1;n++){l=b[n],m=b[n+1],k=_.last(d),n>0&&(j=l,j.d=k?a(k,l):"top",d.push(j),k=j);var o=k&&k.d;j=c(l,m,o),g.point(j).equals(g.point(l))||g.point(j).equals(g.point(m))||d.push(j)}return d}var e,f;return function(a){return e=this.sourceBBox,f=this.targetBBox,d(a)}}(),joint.routers.manhattan=function(){"use strict";function a(a,b){for(var c,d=[],e={x:0,y:0},f=b;c=a[f];){var g=c.difference(f);g.equals(e)||(d.unshift(f),e=g),f=c}return d.unshift(f),d}function b(a,b,c){var d=c.step,e=a.center(),f=_.chain(c.directionMap).pick(b).map(function(b){var c=b.x*a.width/2,f=b.y*a.height/2,h=g.point(e).offset(c,f).snapToGrid(d);return a.containsPoint(h)&&h.offset(b.x*d,b.y*d),h}).value();return f}function c(a,b,c){var d=360/c,e=Math.floor(a.theta(b)/d);return c-e}function d(d,e,f,h){var i=h.reversed?h.endDirections:h.startDirections,j=h.reversed?h.startDirections:h.endDirections,k=d instanceof g.rect?b(d,i,h):[d],l=e instanceof g.rect?b(e,j,h):[e],m=k.length>1?d.center():k[0],n=l.length>1?e.center():l[0],o=_.filter(l,function(a){var b=g.point(a).snapToGrid(h.mapGridSize).toString(),c=_.every(f[b],function(b){return!b.containsPoint(a)});return c});if(o.length)for(var p=h.step,q=h.penalties,r=_.chain(o).invoke("snapToGrid",p).min(function(a){return h.estimateCost(m,a)}).value(),s={},t={},u={},v=h.directions,w=v.length,x=w/2,y=h.previousDirIndexes||{},z={},A={},B=_.chain(k).invoke("snapToGrid",p).each(function(a){var b=a.toString();t[b]=0,u[b]=h.estimateCost(a,r),y[b]=y[b]||c(m,a,w),A[b]=!0}).map(function(a){return a.toString()}).sortBy(function(a){return u[a]}).value(),C=h.maximumLoops,D=h.maxAllowedDirectionChange;B.length&&C--;){var E=B[0],F=g.point(E);if(r.equals(F))return h.previousDirIndexes=_.pick(y,E),a(s,F);B.splice(0,1),A[M]=null,z[M]=!0;for(var G=y[E],H=t[E],I=0;w>I;I++){var J=Math.abs(I-G);if(J>x&&(J=w-J),!(J>D)){var K=v[I],L=g.point(F).offset(K.offsetX,K.offsetY),M=L.toString();if(!z[M]){var N=g.point(L).snapToGrid(h.mapGridSize).toString(),O=_.every(f[N],function(a){return!a.containsPoint(L)});if(O){var P=_.has(A,M),Q=H+K.cost;if((!P||Q<t[M])&&(s[M]=F,y[M]=I,t[M]=Q,u[M]=Q+h.estimateCost(L,r)+q[J],!P)){var R=_.sortedIndex(B,M,function(a){return u[a]});B.splice(R,0,M),A[M]=!0}}}}}}return h.fallbackRoute(m,n,h)}function e(a,b){b.directions=_.result(b,"directions"),b.penalties=_.result(b,"penalties"),b.paddingBox=_.result(b,"paddingBox"),this.options.perpendicular=!!b.perpendicular;var c=b.reversed="source"===this.lastEndChange,e=c?g.rect(this.targetBBox):g.rect(this.sourceBBox),f=c?g.rect(this.sourceBBox):g.rect(this.targetBBox);e.moveAndExpand(b.paddingBox),f.moveAndExpand(b.paddingBox);for(var h=this.model,i=this.paper.model,j=_.chain(b.excludeEnds).map(h.get,h).pluck("id").map(i.getCell,i).value(),k=b.mapGridSize,l=_.chain(i.getElements()).difference(j).reject(function(a){return _.contains(b.excludeTypes,a.get("type"))}).invoke("getBBox").invoke("moveAndExpand",b.paddingBox).foldl(function(a,b){for(var c=b.origin().snapToGrid(k),d=b.corner().snapToGrid(k),e=c.x;e<=d.x;e+=k)for(var f=c.y;f<=d.y;f+=k){var g=e+"@"+f;a[g]=a[g]||[],a[g].push(b)}return a},{}).value(),m=[],n=_.map(a,g.point),o=e.center(),p=0,q=n.length;q>=p;p++){var r=null,s=t||e,t=n[p];if(!t){t=f;var u=!this.model.get("source").id||!this.model.get("target").id;if(u&&_.isFunction(b.draggingRoute)){var v=s instanceof g.rect?s.center():s;r=b.draggingRoute(v,t.origin(),b)}}r=r||d(s,t,l,b);var w=_.first(r);w&&w.equals(o)&&r.shift(),o=_.last(r)||o,m=m.concat(r)}return c?m.reverse():m}var f={step:10,perpendicular:!0,mapGridSize:100,excludeEnds:[],excludeTypes:["basic.Text"],maximumLoops:500,startDirections:["left","right","top","bottom"],endDirections:["left","right","top","bottom"],directionMap:{right:{x:1,y:0},bottom:{x:0,y:1},left:{x:-1,y:0},top:{x:0,y:-1}},maxAllowedDirectionChange:1,paddingBox:function(){var a=this.step;return{x:-a,y:-a,width:2*a,height:2*a}},directions:function(){var a=this.step;return[{offsetX:a,offsetY:0,cost:a},{offsetX:0,offsetY:a,cost:a},{offsetX:-a,offsetY:0,cost:a},{offsetX:0,offsetY:-a,cost:a}]},penalties:function(){return[0,this.step/2,this.step]},estimateCost:function(a,b){return a.manhattanDistance(b)},fallbackRoute:function(a,b,c){var d=c.prevDirIndexes||{},e=(d[a]||0)%2?g.point(a.x,b.y):g.point(b.x,a.y);return[e,b]},draggingRoute:null};return function(a,b,c){return e.call(c,a,_.extend({},f,b))}}(),joint.routers.metro=function(){if(!_.isFunction(joint.routers.manhattan))throw"Metro requires the manhattan router.";var a={diagonalCost:null,directions:function(){var a=this.step,b=this.diagonalCost||Math.ceil(Math.sqrt(a*a<<1));return[{offsetX:a,offsetY:0,cost:a},{offsetX:a,offsetY:a,cost:b},{offsetX:0,offsetY:a,cost:a},{offsetX:-a,offsetY:a,cost:b},{offsetX:-a,offsetY:0,cost:a},{offsetX:-a,offsetY:-a,cost:b},{offsetX:0,offsetY:-a,cost:a},{offsetX:a,offsetY:-a,cost:b}]},fallbackRoute:function(a,b){var c=a.theta(b),d={x:b.x,y:a.y},e={x:a.x,y:b.y};
if(c%180>90){var f=d;d=e,e=f}var h=45>c%90?d:e,i=g.line(a,h),j=90*Math.ceil(c/90),k=g.point.fromPolar(i.squaredLength(),g.toRad(j+135),h),l=g.line(b,k),m=i.intersection(l);return m?[m.round(),b]:[b]}};return function(b,c,d){return joint.routers.manhattan(b,_.extend({},a,c),d)}}(),joint.connectors.normal=function(a,b,c){var d=["M",a.x,a.y];return _.each(c,function(a){d.push(a.x,a.y)}),d.push(b.x,b.y),d.join(" ")},joint.connectors.rounded=function(a,b,c,d){var e,f,h,i,j,k,l=d.radius||10,m=["M",a.x,a.y];return _.each(c,function(d,n){j=c[n-1]||a,k=c[n+1]||b,h=i||g.point(d).distance(j)/2,i=g.point(d).distance(k)/2,e=g.point(d).move(j,-Math.min(l,h)).round(),f=g.point(d).move(k,-Math.min(l,i)).round(),m.push(e.x,e.y,"S",d.x,d.y,f.x,f.y,"L")}),m.push(b.x,b.y),m.join(" ")},joint.connectors.smooth=function(a,b,c){var d;if(c.length)d=g.bezier.curveThroughPoints([a].concat(c).concat([b]));else{var e=a.x<b.x?b.x-(b.x-a.x)/2:a.x-(a.x-b.x)/2;d=["M",a.x,a.y,"C",e,a.y,e,b.y,b.x,b.y]}return d.join(" ")},"object"==typeof exports)var joint={util:require("../src/core").util,shapes:{},dia:{Element:require("../src/joint.dia.element").Element,Link:require("../src/joint.dia.link").Link}};if(joint.shapes.erd={},joint.shapes.erd.Entity=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><polygon class="outer"/><polygon class="inner"/></g><text/></g>',defaults:joint.util.deepSupplement({type:"erd.Entity",size:{width:150,height:60},attrs:{".outer":{fill:"#2ECC71",stroke:"#27AE60","stroke-width":2,points:"100,0 100,60 0,60 0,0"},".inner":{fill:"#2ECC71",stroke:"#27AE60","stroke-width":2,points:"95,5 95,55 5,55 5,5",display:"none"},text:{text:"Entity","font-family":"Arial","font-size":14,ref:".outer","ref-x":.5,"ref-y":.5,"x-alignment":"middle","y-alignment":"middle"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.erd.WeakEntity=joint.shapes.erd.Entity.extend({defaults:joint.util.deepSupplement({type:"erd.WeakEntity",attrs:{".inner":{display:"auto"},text:{text:"Weak Entity"}}},joint.shapes.erd.Entity.prototype.defaults)}),joint.shapes.erd.Relationship=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><polygon class="outer"/><polygon class="inner"/></g><text/></g>',defaults:joint.util.deepSupplement({type:"erd.Relationship",size:{width:80,height:80},attrs:{".outer":{fill:"#3498DB",stroke:"#2980B9","stroke-width":2,points:"40,0 80,40 40,80 0,40"},".inner":{fill:"#3498DB",stroke:"#2980B9","stroke-width":2,points:"40,5 75,40 40,75 5,40",display:"none"},text:{text:"Relationship","font-family":"Arial","font-size":12,ref:".","ref-x":.5,"ref-y":.5,"x-alignment":"middle","y-alignment":"middle"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.erd.IdentifyingRelationship=joint.shapes.erd.Relationship.extend({defaults:joint.util.deepSupplement({type:"erd.IdentifyingRelationship",attrs:{".inner":{display:"auto"},text:{text:"Identifying"}}},joint.shapes.erd.Relationship.prototype.defaults)}),joint.shapes.erd.Attribute=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><ellipse class="outer"/><ellipse class="inner"/></g><text/></g>',defaults:joint.util.deepSupplement({type:"erd.Attribute",size:{width:100,height:50},attrs:{ellipse:{transform:"translate(50, 25)"},".outer":{stroke:"#D35400","stroke-width":2,cx:0,cy:0,rx:50,ry:25,fill:"#E67E22"},".inner":{stroke:"#D35400","stroke-width":2,cx:0,cy:0,rx:45,ry:20,fill:"transparent",display:"none"},text:{"font-family":"Arial","font-size":14,ref:".","ref-x":.5,"ref-y":.5,"x-alignment":"middle","y-alignment":"middle"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.erd.Multivalued=joint.shapes.erd.Attribute.extend({defaults:joint.util.deepSupplement({type:"erd.Multivalued",attrs:{".inner":{display:"block"},text:{text:"multivalued"}}},joint.shapes.erd.Attribute.prototype.defaults)}),joint.shapes.erd.Derived=joint.shapes.erd.Attribute.extend({defaults:joint.util.deepSupplement({type:"erd.Derived",attrs:{".outer":{"stroke-dasharray":"3,5"},text:{text:"derived"}}},joint.shapes.erd.Attribute.prototype.defaults)}),joint.shapes.erd.Key=joint.shapes.erd.Attribute.extend({defaults:joint.util.deepSupplement({type:"erd.Key",attrs:{ellipse:{"stroke-width":4},text:{text:"key","font-weight":"bold","text-decoration":"underline"}}},joint.shapes.erd.Attribute.prototype.defaults)}),joint.shapes.erd.Normal=joint.shapes.erd.Attribute.extend({defaults:joint.util.deepSupplement({type:"erd.Normal",attrs:{text:{text:"Normal"}}},joint.shapes.erd.Attribute.prototype.defaults)}),joint.shapes.erd.ISA=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><polygon/></g><text/></g>',defaults:joint.util.deepSupplement({type:"erd.ISA",size:{width:100,height:50},attrs:{polygon:{points:"0,0 50,50 100,0",fill:"#F1C40F",stroke:"#F39C12","stroke-width":2},text:{text:"ISA",ref:".","ref-x":.5,"ref-y":.3,"x-alignment":"middle","y-alignment":"middle"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.erd.Line=joint.dia.Link.extend({defaults:{type:"erd.Line"},cardinality:function(a){this.set("labels",[{position:-20,attrs:{text:{dy:-8,text:a}}}])}}),"object"==typeof exports&&(module.exports=joint.shapes.erd),"object"==typeof exports)var joint={util:require("../src/core").util,shapes:{basic:require("./joint.shapes.basic")},dia:{Element:require("../src/joint.dia.element").Element,Link:require("../src/joint.dia.link").Link}};if(joint.shapes.fsa={},joint.shapes.fsa.State=joint.shapes.basic.Circle.extend({defaults:joint.util.deepSupplement({type:"fsa.State",attrs:{circle:{"stroke-width":3},text:{"font-weight":"bold"}}},joint.shapes.basic.Circle.prototype.defaults)}),joint.shapes.fsa.StartState=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><circle/></g></g>',defaults:joint.util.deepSupplement({type:"fsa.StartState",size:{width:20,height:20},attrs:{circle:{transform:"translate(10, 10)",r:10,fill:"black"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.fsa.EndState=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><circle class="outer"/><circle class="inner"/></g></g>',defaults:joint.util.deepSupplement({type:"fsa.EndState",size:{width:20,height:20},attrs:{".outer":{transform:"translate(10, 10)",r:10,fill:"#FFFFFF",stroke:"black"},".inner":{transform:"translate(10, 10)",r:6,fill:"#000000"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.fsa.Arrow=joint.dia.Link.extend({defaults:joint.util.deepSupplement({type:"fsa.Arrow",attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z"}},smooth:!0},joint.dia.Link.prototype.defaults)}),"object"==typeof exports&&(module.exports=joint.shapes.fsa),"object"==typeof exports)var joint={util:require("../src/core").util,shapes:{},dia:{Element:require("../src/joint.dia.element").Element,Link:require("../src/joint.dia.link").Link}};if(joint.shapes.org={},joint.shapes.org.Member=joint.dia.Element.extend({markup:'<g class="rotatable"><g class="scalable"><rect class="card"/><image/></g><text class="rank"/><text class="name"/></g>',defaults:joint.util.deepSupplement({type:"org.Member",size:{width:180,height:70},attrs:{rect:{width:170,height:60},".card":{fill:"#FFFFFF",stroke:"#000000","stroke-width":2,"pointer-events":"visiblePainted",rx:10,ry:10},image:{width:48,height:48,ref:".card","ref-x":10,"ref-y":5},".rank":{"text-decoration":"underline",ref:".card","ref-x":.9,"ref-y":.2,"font-family":"Courier New","font-size":14,"text-anchor":"end"},".name":{"font-weight":"bold",ref:".card","ref-x":.9,"ref-y":.6,"font-family":"Courier New","font-size":14,"text-anchor":"end"}}},joint.dia.Element.prototype.defaults)}),joint.shapes.org.Arrow=joint.dia.Link.extend({defaults:{type:"org.Arrow",source:{selector:".card"},target:{selector:".card"},attrs:{".connection":{stroke:"#585858","stroke-width":3}},z:-1}}),"object"==typeof exports&&(module.exports=joint.shapes.org),"object"==typeof exports)var joint={util:require("../src/core").util,shapes:{basic:require("./joint.shapes.basic")},dia:{}};if(joint.shapes.chess={},joint.shapes.chess.KingWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;"><path      d="M 22.5,11.63 L 22.5,6"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path      d="M 20,8 L 25,8"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path      d="M 22.5,25 C 22.5,25 27,17.5 25.5,14.5 C 25.5,14.5 24.5,12 22.5,12 C 20.5,12 19.5,14.5 19.5,14.5 C 18,17.5 22.5,25 22.5,25"      style="fill:#ffffff; stroke:#000000; stroke-linecap:butt; stroke-linejoin:miter;" />    <path      d="M 11.5,37 C 17,40.5 27,40.5 32.5,37 L 32.5,30 C 32.5,30 41.5,25.5 38.5,19.5 C 34.5,13 25,16 22.5,23.5 L 22.5,27 L 22.5,23.5 C 19,16 9.5,13 6.5,19.5 C 3.5,25.5 11.5,29.5 11.5,29.5 L 11.5,37 z "      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 11.5,30 C 17,27 27,27 32.5,30"      style="fill:none; stroke:#000000;" />    <path      d="M 11.5,33.5 C 17,30.5 27,30.5 32.5,33.5"      style="fill:none; stroke:#000000;" />    <path      d="M 11.5,37 C 17,34 27,34 32.5,37"      style="fill:none; stroke:#000000;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.KingWhite",size:{width:42,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.KingBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path       d="M 22.5,11.63 L 22.5,6"       style="fill:none; stroke:#000000; stroke-linejoin:miter;"       id="path6570" />    <path       d="M 22.5,25 C 22.5,25 27,17.5 25.5,14.5 C 25.5,14.5 24.5,12 22.5,12 C 20.5,12 19.5,14.5 19.5,14.5 C 18,17.5 22.5,25 22.5,25"       style="fill:#000000;fill-opacity:1; stroke-linecap:butt; stroke-linejoin:miter;" />    <path       d="M 11.5,37 C 17,40.5 27,40.5 32.5,37 L 32.5,30 C 32.5,30 41.5,25.5 38.5,19.5 C 34.5,13 25,16 22.5,23.5 L 22.5,27 L 22.5,23.5 C 19,16 9.5,13 6.5,19.5 C 3.5,25.5 11.5,29.5 11.5,29.5 L 11.5,37 z "       style="fill:#000000; stroke:#000000;" />    <path       d="M 20,8 L 25,8"       style="fill:none; stroke:#000000; stroke-linejoin:miter;" />    <path       d="M 32,29.5 C 32,29.5 40.5,25.5 38.03,19.85 C 34.15,14 25,18 22.5,24.5 L 22.51,26.6 L 22.5,24.5 C 20,18 9.906,14 6.997,19.85 C 4.5,25.5 11.85,28.85 11.85,28.85"       style="fill:none; stroke:#ffffff;" />    <path       d="M 11.5,30 C 17,27 27,27 32.5,30 M 11.5,33.5 C 17,30.5 27,30.5 32.5,33.5 M 11.5,37 C 17,34 27,34 32.5,37"       style="fill:none; stroke:#ffffff;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.KingBlack",size:{width:42,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.QueenWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(-1,-1)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(15.5,-5.5)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(32,-1)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(7,-4.5)" />    <path      d="M 9 13 A 2 2 0 1 1  5,13 A 2 2 0 1 1  9 13 z"      transform="translate(24,-4)" />    <path      d="M 9,26 C 17.5,24.5 30,24.5 36,26 L 38,14 L 31,25 L 31,11 L 25.5,24.5 L 22.5,9.5 L 19.5,24.5 L 14,10.5 L 14,25 L 7,14 L 9,26 z "      style="stroke-linecap:butt;" />    <path      d="M 9,26 C 9,28 10.5,28 11.5,30 C 12.5,31.5 12.5,31 12,33.5 C 10.5,34.5 10.5,36 10.5,36 C 9,37.5 11,38.5 11,38.5 C 17.5,39.5 27.5,39.5 34,38.5 C 34,38.5 35.5,37.5 34,36 C 34,36 34.5,34.5 33,33.5 C 32.5,31 32.5,31.5 33.5,30 C 34.5,28 36,28 36,26 C 27.5,24.5 17.5,24.5 9,26 z "      style="stroke-linecap:butt;" />    <path      d="M 11.5,30 C 15,29 30,29 33.5,30"      style="fill:none;" />    <path      d="M 12,33.5 C 18,32.5 27,32.5 33,33.5"      style="fill:none;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.QueenWhite",size:{width:42,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.QueenBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#000000; stroke:none;">      <circle cx="6"    cy="12" r="2.75" />      <circle cx="14"   cy="9"  r="2.75" />      <circle cx="22.5" cy="8"  r="2.75" />      <circle cx="31"   cy="9"  r="2.75" />      <circle cx="39"   cy="12" r="2.75" />    </g>    <path       d="M 9,26 C 17.5,24.5 30,24.5 36,26 L 38.5,13.5 L 31,25 L 30.7,10.9 L 25.5,24.5 L 22.5,10 L 19.5,24.5 L 14.3,10.9 L 14,25 L 6.5,13.5 L 9,26 z"       style="stroke-linecap:butt; stroke:#000000;" />    <path       d="M 9,26 C 9,28 10.5,28 11.5,30 C 12.5,31.5 12.5,31 12,33.5 C 10.5,34.5 10.5,36 10.5,36 C 9,37.5 11,38.5 11,38.5 C 17.5,39.5 27.5,39.5 34,38.5 C 34,38.5 35.5,37.5 34,36 C 34,36 34.5,34.5 33,33.5 C 32.5,31 32.5,31.5 33.5,30 C 34.5,28 36,28 36,26 C 27.5,24.5 17.5,24.5 9,26 z"       style="stroke-linecap:butt;" />    <path       d="M 11,38.5 A 35,35 1 0 0 34,38.5"       style="fill:none; stroke:#000000; stroke-linecap:butt;" />    <path       d="M 11,29 A 35,35 1 0 1 34,29"       style="fill:none; stroke:#ffffff;" />    <path       d="M 12.5,31.5 L 32.5,31.5"       style="fill:none; stroke:#ffffff;" />    <path       d="M 11.5,34.5 A 35,35 1 0 0 33.5,34.5"       style="fill:none; stroke:#ffffff;" />    <path       d="M 10.5,37.5 A 35,35 1 0 0 34.5,37.5"       style="fill:none; stroke:#ffffff;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.QueenBlack",size:{width:42,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.RookWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9,39 L 36,39 L 36,36 L 9,36 L 9,39 z "      style="stroke-linecap:butt;" />    <path      d="M 12,36 L 12,32 L 33,32 L 33,36 L 12,36 z "      style="stroke-linecap:butt;" />    <path      d="M 11,14 L 11,9 L 15,9 L 15,11 L 20,11 L 20,9 L 25,9 L 25,11 L 30,11 L 30,9 L 34,9 L 34,14"      style="stroke-linecap:butt;" />    <path      d="M 34,14 L 31,17 L 14,17 L 11,14" />    <path      d="M 31,17 L 31,29.5 L 14,29.5 L 14,17"      style="stroke-linecap:butt; stroke-linejoin:miter;" />    <path      d="M 31,29.5 L 32.5,32 L 12.5,32 L 14,29.5" />    <path      d="M 11,14 L 34,14"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.RookWhite",size:{width:32,height:34}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.RookBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 9,39 L 36,39 L 36,36 L 9,36 L 9,39 z "      style="stroke-linecap:butt;" />    <path      d="M 12.5,32 L 14,29.5 L 31,29.5 L 32.5,32 L 12.5,32 z "      style="stroke-linecap:butt;" />    <path      d="M 12,36 L 12,32 L 33,32 L 33,36 L 12,36 z "      style="stroke-linecap:butt;" />    <path      d="M 14,29.5 L 14,16.5 L 31,16.5 L 31,29.5 L 14,29.5 z "      style="stroke-linecap:butt;stroke-linejoin:miter;" />    <path      d="M 14,16.5 L 11,14 L 34,14 L 31,16.5 L 14,16.5 z "      style="stroke-linecap:butt;" />    <path      d="M 11,14 L 11,9 L 15,9 L 15,11 L 20,11 L 20,9 L 25,9 L 25,11 L 30,11 L 30,9 L 34,9 L 34,14 L 11,14 z "      style="stroke-linecap:butt;" />    <path      d="M 12,35.5 L 33,35.5 L 33,35.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 13,31.5 L 32,31.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 14,29.5 L 31,29.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 14,16.5 L 31,16.5"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />    <path      d="M 11,14 L 34,14"      style="fill:none; stroke:#ffffff; stroke-width:1; stroke-linejoin:miter;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.RookBlack",size:{width:32,height:34}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.BishopWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-rule:evenodd; fill-opacity:1; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:round; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#ffffff; stroke:#000000; stroke-linecap:butt;">       <path        d="M 9,36 C 12.39,35.03 19.11,36.43 22.5,34 C 25.89,36.43 32.61,35.03 36,36 C 36,36 37.65,36.54 39,38 C 38.32,38.97 37.35,38.99 36,38.5 C 32.61,37.53 25.89,38.96 22.5,37.5 C 19.11,38.96 12.39,37.53 9,38.5 C 7.646,38.99 6.677,38.97 6,38 C 7.354,36.06 9,36 9,36 z" />      <path        d="M 15,32 C 17.5,34.5 27.5,34.5 30,32 C 30.5,30.5 30,30 30,30 C 30,27.5 27.5,26 27.5,26 C 33,24.5 33.5,14.5 22.5,10.5 C 11.5,14.5 12,24.5 17.5,26 C 17.5,26 15,27.5 15,30 C 15,30 14.5,30.5 15,32 z" />      <path        d="M 25 8 A 2.5 2.5 0 1 1  20,8 A 2.5 2.5 0 1 1  25 8 z" />    </g>    <path      d="M 17.5,26 L 27.5,26 M 15,30 L 30,30 M 22.5,15.5 L 22.5,20.5 M 20,18 L 25,18"      style="fill:none; stroke:#000000; stroke-linejoin:miter;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.BishopWhite",size:{width:38,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.BishopBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-rule:evenodd; fill-opacity:1; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:round; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <g style="fill:#000000; stroke:#000000; stroke-linecap:butt;">       <path        d="M 9,36 C 12.39,35.03 19.11,36.43 22.5,34 C 25.89,36.43 32.61,35.03 36,36 C 36,36 37.65,36.54 39,38 C 38.32,38.97 37.35,38.99 36,38.5 C 32.61,37.53 25.89,38.96 22.5,37.5 C 19.11,38.96 12.39,37.53 9,38.5 C 7.646,38.99 6.677,38.97 6,38 C 7.354,36.06 9,36 9,36 z" />      <path        d="M 15,32 C 17.5,34.5 27.5,34.5 30,32 C 30.5,30.5 30,30 30,30 C 30,27.5 27.5,26 27.5,26 C 33,24.5 33.5,14.5 22.5,10.5 C 11.5,14.5 12,24.5 17.5,26 C 17.5,26 15,27.5 15,30 C 15,30 14.5,30.5 15,32 z" />      <path        d="M 25 8 A 2.5 2.5 0 1 1  20,8 A 2.5 2.5 0 1 1  25 8 z" />    </g>    <path       d="M 17.5,26 L 27.5,26 M 15,30 L 30,30 M 22.5,15.5 L 22.5,20.5 M 20,18 L 25,18"       style="fill:none; stroke:#ffffff; stroke-linejoin:miter;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.BishopBlack",size:{width:38,height:38}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.KnightWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 22,10 C 32.5,11 38.5,18 38,39 L 15,39 C 15,30 25,32.5 23,18"      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 24,18 C 24.38,20.91 18.45,25.37 16,27 C 13,29 13.18,31.34 11,31 C 9.958,30.06 12.41,27.96 11,28 C 10,28 11.19,29.23 10,30 C 9,30 5.997,31 6,26 C 6,24 12,14 12,14 C 12,14 13.89,12.1 14,10.5 C 13.27,9.506 13.5,8.5 13.5,7.5 C 14.5,6.5 16.5,10 16.5,10 L 18.5,10 C 18.5,10 19.28,8.008 21,7 C 22,7 22,10 22,10"      style="fill:#ffffff; stroke:#000000;" />    <path      d="M 9.5 25.5 A 0.5 0.5 0 1 1 8.5,25.5 A 0.5 0.5 0 1 1 9.5 25.5 z"      style="fill:#000000; stroke:#000000;" />    <path      d="M 15 15.5 A 0.5 1.5 0 1 1  14,15.5 A 0.5 1.5 0 1 1  15 15.5 z"      transform="matrix(0.866,0.5,-0.5,0.866,9.693,-5.173)"      style="fill:#000000; stroke:#000000;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.KnightWhite",size:{width:38,height:37}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.KnightBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><g style="opacity:1; fill:none; fill-opacity:1; fill-rule:evenodd; stroke:#000000; stroke-width:1.5; stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;">    <path      d="M 22,10 C 32.5,11 38.5,18 38,39 L 15,39 C 15,30 25,32.5 23,18"      style="fill:#000000; stroke:#000000;" />    <path      d="M 24,18 C 24.38,20.91 18.45,25.37 16,27 C 13,29 13.18,31.34 11,31 C 9.958,30.06 12.41,27.96 11,28 C 10,28 11.19,29.23 10,30 C 9,30 5.997,31 6,26 C 6,24 12,14 12,14 C 12,14 13.89,12.1 14,10.5 C 13.27,9.506 13.5,8.5 13.5,7.5 C 14.5,6.5 16.5,10 16.5,10 L 18.5,10 C 18.5,10 19.28,8.008 21,7 C 22,7 22,10 22,10"      style="fill:#000000; stroke:#000000;" />    <path      d="M 9.5 25.5 A 0.5 0.5 0 1 1 8.5,25.5 A 0.5 0.5 0 1 1 9.5 25.5 z"      style="fill:#ffffff; stroke:#ffffff;" />    <path      d="M 15 15.5 A 0.5 1.5 0 1 1  14,15.5 A 0.5 1.5 0 1 1  15 15.5 z"      transform="matrix(0.866,0.5,-0.5,0.866,9.693,-5.173)"      style="fill:#ffffff; stroke:#ffffff;" />    <path      d="M 24.55,10.4 L 24.1,11.85 L 24.6,12 C 27.75,13 30.25,14.49 32.5,18.75 C 34.75,23.01 35.75,29.06 35.25,39 L 35.2,39.5 L 37.45,39.5 L 37.5,39 C 38,28.94 36.62,22.15 34.25,17.66 C 31.88,13.17 28.46,11.02 25.06,10.5 L 24.55,10.4 z "      style="fill:#ffffff; stroke:none;" />  </g></g></g>',defaults:joint.util.deepSupplement({type:"chess.KnightBlack",size:{width:38,height:37}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.PawnWhite=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path d="M 22,9 C 19.79,9 18,10.79 18,13 C 18,13.89 18.29,14.71 18.78,15.38 C 16.83,16.5 15.5,18.59 15.5,21 C 15.5,23.03 16.44,24.84 17.91,26.03 C 14.91,27.09 10.5,31.58 10.5,39.5 L 33.5,39.5 C 33.5,31.58 29.09,27.09 26.09,26.03 C 27.56,24.84 28.5,23.03 28.5,21 C 28.5,18.59 27.17,16.5 25.22,15.38 C 25.71,14.71 26,13.89 26,13 C 26,10.79 24.21,9 22,9 z "  style="opacity:1; fill:#ffffff; fill-opacity:1; fill-rule:nonzero; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:miter; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;" /></g></g>',defaults:joint.util.deepSupplement({type:"chess.PawnWhite",size:{width:28,height:33}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.chess.PawnBlack=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><path d="M 22,9 C 19.79,9 18,10.79 18,13 C 18,13.89 18.29,14.71 18.78,15.38 C 16.83,16.5 15.5,18.59 15.5,21 C 15.5,23.03 16.44,24.84 17.91,26.03 C 14.91,27.09 10.5,31.58 10.5,39.5 L 33.5,39.5 C 33.5,31.58 29.09,27.09 26.09,26.03 C 27.56,24.84 28.5,23.03 28.5,21 C 28.5,18.59 27.17,16.5 25.22,15.38 C 25.71,14.71 26,13.89 26,13 C 26,10.79 24.21,9 22,9 z "  style="opacity:1; fill:#000000; fill-opacity:1; fill-rule:nonzero; stroke:#000000; stroke-width:1.5; stroke-linecap:round; stroke-linejoin:miter; stroke-miterlimit:4; stroke-dasharray:none; stroke-opacity:1;" /></g></g>',defaults:joint.util.deepSupplement({type:"chess.PawnBlack",size:{width:28,height:33}},joint.shapes.basic.Generic.prototype.defaults)}),"object"==typeof exports&&(module.exports=joint.shapes.chess),"object"==typeof exports)var joint={util:require("../src/core").util,shapes:{basic:require("./joint.shapes.basic")},dia:{ElementView:require("../src/joint.dia.element").ElementView,Link:require("../src/joint.dia.link").Link}};if(joint.shapes.pn={},joint.shapes.pn.Place=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle class="root"/><g class="tokens" /></g><text class="label"/></g>',defaults:joint.util.deepSupplement({type:"pn.Place",size:{width:50,height:50},attrs:{".root":{r:25,fill:"white",stroke:"black",transform:"translate(25, 25)"},".label":{"text-anchor":"middle","ref-x":.5,"ref-y":-20,ref:".root",fill:"black","font-size":12},".tokens > circle":{fill:"black",r:5},".tokens.one > circle":{transform:"translate(25, 25)"},".tokens.two > circle:nth-child(1)":{transform:"translate(19, 25)"},".tokens.two > circle:nth-child(2)":{transform:"translate(31, 25)"},".tokens.three > circle:nth-child(1)":{transform:"translate(18, 29)"},".tokens.three > circle:nth-child(2)":{transform:"translate(25, 19)"},".tokens.three > circle:nth-child(3)":{transform:"translate(32, 29)"},".tokens.alot > text":{transform:"translate(25, 18)","text-anchor":"middle",fill:"black"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.pn.PlaceView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.model.on("change:tokens",function(){this.renderTokens(),this.update()},this)},render:function(){joint.dia.ElementView.prototype.render.apply(this,arguments),this.renderTokens(),this.update()},renderTokens:function(){var a=this.$(".tokens").empty();a[0].className.baseVal="tokens";var b=this.model.get("tokens");if(b)switch(b){case 1:a[0].className.baseVal+=" one",a.append(V("<circle/>").node);break;case 2:a[0].className.baseVal+=" two",a.append(V("<circle/>").node,V("<circle/>").node);break;case 3:a[0].className.baseVal+=" three",a.append(V("<circle/>").node,V("<circle/>").node,V("<circle/>").node);break;default:a[0].className.baseVal+=" alot",a.append(V("<text/>").text(b+"").node)}}}),joint.shapes.pn.Transition=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><rect class="root"/></g></g><text class="label"/>',defaults:joint.util.deepSupplement({type:"pn.Transition",size:{width:12,height:50},attrs:{rect:{width:12,height:50,fill:"black",stroke:"black"},".label":{"text-anchor":"middle","ref-x":.5,"ref-y":-20,ref:"rect",fill:"black","font-size":12}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.pn.Link=joint.dia.Link.extend({defaults:joint.util.deepSupplement({attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z"}}},joint.dia.Link.prototype.defaults)}),"object"==typeof exports&&(module.exports=joint.shapes.pn),"object"==typeof exports)var joint={util:require("../src/core").util,shapes:{basic:require("./joint.shapes.basic")},dia:{ElementView:require("../src/joint.dia.element").ElementView,Link:require("../src/joint.dia.link").Link}},_=require("lodash");if(joint.shapes.devs={},joint.shapes.devs.Model=joint.shapes.basic.Generic.extend(_.extend({},joint.shapes.basic.PortsModelInterface,{markup:'<g class="rotatable"><g class="scalable"><rect/></g><text class="label"/><g class="inPorts"/><g class="outPorts"/></g>',portMarkup:'<g class="port<%= id %>"><circle/><text/></g>',defaults:joint.util.deepSupplement({type:"devs.Model",size:{width:1,height:1},inPorts:[],outPorts:[],attrs:{".":{magnet:!1},rect:{width:150,height:250,stroke:"black"},circle:{r:10,magnet:!0,stroke:"black"},text:{fill:"black","pointer-events":"none"},".label":{text:"Model","ref-x":.3,"ref-y":.2},".inPorts text":{x:-15,dy:4,"text-anchor":"end"},".outPorts text":{x:15,dy:4}}},joint.shapes.basic.Generic.prototype.defaults),getPortAttrs:function(a,b,c,d,e){var f={},g="port"+b,h=d+">."+g,i=h+">text",j=h+">circle";return f[i]={text:a},f[j]={port:{id:a||_.uniqueId(e),type:e}},f[h]={ref:"rect","ref-y":(b+.5)*(1/c)},".outPorts"===d&&(f[h]["ref-dx"]=0),f}})),joint.shapes.devs.Atomic=joint.shapes.devs.Model.extend({defaults:joint.util.deepSupplement({type:"devs.Atomic",size:{width:80,height:80},attrs:{rect:{fill:"salmon"},".label":{text:"Atomic"},".inPorts circle":{fill:"PaleGreen"},".outPorts circle":{fill:"Tomato"}}},joint.shapes.devs.Model.prototype.defaults)}),joint.shapes.devs.Coupled=joint.shapes.devs.Model.extend({defaults:joint.util.deepSupplement({type:"devs.Coupled",size:{width:200,height:300},attrs:{rect:{fill:"seaGreen"},".label":{text:"Coupled"},".inPorts circle":{fill:"PaleGreen"},".outPorts circle":{fill:"Tomato"}}},joint.shapes.devs.Model.prototype.defaults)}),joint.shapes.devs.Link=joint.dia.Link.extend({defaults:{type:"devs.Link",attrs:{".connection":{"stroke-width":2}}}}),joint.shapes.devs.ModelView=joint.dia.ElementView.extend(joint.shapes.basic.PortsViewInterface),joint.shapes.devs.AtomicView=joint.shapes.devs.ModelView,joint.shapes.devs.CoupledView=joint.shapes.devs.ModelView,"object"==typeof exports&&(module.exports=joint.shapes.devs),"object"==typeof exports)var joint={util:require("../src/core").util,shapes:{basic:require("./joint.shapes.basic")},dia:{ElementView:require("../src/joint.dia.element").ElementView,Link:require("../src/joint.dia.link").Link}},_=require("lodash");joint.shapes.uml={},joint.shapes.uml.Class=joint.shapes.basic.Generic.extend({markup:['<g class="rotatable">','<g class="scalable">','<rect class="uml-class-name-rect"/><rect class="uml-class-attrs-rect"/><rect class="uml-class-methods-rect"/>',"</g>",'<text class="uml-class-name-text"/><text class="uml-class-attrs-text"/><text class="uml-class-methods-text"/>',"</g>"].join(""),defaults:joint.util.deepSupplement({type:"uml.Class",attrs:{rect:{width:200},".uml-class-name-rect":{stroke:"black","stroke-width":2,fill:"#3498db"},".uml-class-attrs-rect":{stroke:"black","stroke-width":2,fill:"#2980b9"},".uml-class-methods-rect":{stroke:"black","stroke-width":2,fill:"#2980b9"},".uml-class-name-text":{ref:".uml-class-name-rect","ref-y":.5,"ref-x":.5,"text-anchor":"middle","y-alignment":"middle","font-weight":"bold",fill:"black","font-size":12,"font-family":"Times New Roman"},".uml-class-attrs-text":{ref:".uml-class-attrs-rect","ref-y":5,"ref-x":5,fill:"black","font-size":12,"font-family":"Times New Roman"},".uml-class-methods-text":{ref:".uml-class-methods-rect","ref-y":5,"ref-x":5,fill:"black","font-size":12,"font-family":"Times New Roman"}},name:[],attributes:[],methods:[]},joint.shapes.basic.Generic.prototype.defaults),initialize:function(){_.bindAll(this,"updateRectangles"),this.on("change:name change:attributes change:methods",function(){this.updateRectangles(),this.trigger("uml-update")}),this.updateRectangles(),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},getClassName:function(){return this.get("name")},updateRectangles:function(){var a=this.get("attrs"),b=[{type:"name",text:this.getClassName()},{type:"attrs",text:this.get("attributes")},{type:"methods",text:this.get("methods")}],c=0;_.each(b,function(b){var d=_.isArray(b.text)?b.text:[b.text],e=20*d.length+20;a[".uml-class-"+b.type+"-text"].text=d.join("\n"),a[".uml-class-"+b.type+"-rect"].height=e,a[".uml-class-"+b.type+"-rect"].transform="translate(0,"+c+")",c+=e})}}),joint.shapes.uml.ClassView=joint.dia.ElementView.extend({initialize:function(){joint.dia.ElementView.prototype.initialize.apply(this,arguments),this.model.on("uml-update",_.bind(function(){this.update(),this.resize()},this))}}),joint.shapes.uml.Abstract=joint.shapes.uml.Class.extend({defaults:joint.util.deepSupplement({type:"uml.Abstract",attrs:{".uml-class-name-rect":{fill:"#e74c3c"},".uml-class-attrs-rect":{fill:"#c0392b"},".uml-class-methods-rect":{fill:"#c0392b"}}},joint.shapes.uml.Class.prototype.defaults),getClassName:function(){return["<<Abstract>>",this.get("name")]
}}),joint.shapes.uml.AbstractView=joint.shapes.uml.ClassView,joint.shapes.uml.Interface=joint.shapes.uml.Class.extend({defaults:joint.util.deepSupplement({type:"uml.Interface",attrs:{".uml-class-name-rect":{fill:"#f1c40f"},".uml-class-attrs-rect":{fill:"#f39c12"},".uml-class-methods-rect":{fill:"#f39c12"}}},joint.shapes.uml.Class.prototype.defaults),getClassName:function(){return["<<Interface>>",this.get("name")]}}),joint.shapes.uml.InterfaceView=joint.shapes.uml.ClassView,joint.shapes.uml.Generalization=joint.dia.Link.extend({defaults:{type:"uml.Generalization",attrs:{".marker-target":{d:"M 20 0 L 0 10 L 20 20 z",fill:"white"}}}}),joint.shapes.uml.Implementation=joint.dia.Link.extend({defaults:{type:"uml.Implementation",attrs:{".marker-target":{d:"M 20 0 L 0 10 L 20 20 z",fill:"white"},".connection":{"stroke-dasharray":"3,3"}}}}),joint.shapes.uml.Aggregation=joint.dia.Link.extend({defaults:{type:"uml.Aggregation",attrs:{".marker-target":{d:"M 40 10 L 20 20 L 0 10 L 20 0 z",fill:"white"}}}}),joint.shapes.uml.Composition=joint.dia.Link.extend({defaults:{type:"uml.Composition",attrs:{".marker-target":{d:"M 40 10 L 20 20 L 0 10 L 20 0 z",fill:"black"}}}}),joint.shapes.uml.Association=joint.dia.Link.extend({defaults:{type:"uml.Association"}}),joint.shapes.uml.State=joint.shapes.basic.Generic.extend({markup:['<g class="rotatable">','<g class="scalable">',"<rect/>","</g>",'<path/><text class="uml-state-name"/><text class="uml-state-events"/>',"</g>"].join(""),defaults:joint.util.deepSupplement({type:"uml.State",attrs:{rect:{width:200,height:200,fill:"#ecf0f1",stroke:"#bdc3c7","stroke-width":3,rx:10,ry:10},path:{d:"M 0 20 L 200 20",stroke:"#bdc3c7","stroke-width":2},".uml-state-name":{ref:"rect","ref-x":.5,"ref-y":5,"text-anchor":"middle","font-family":"Courier New","font-size":14,fill:"#000000"},".uml-state-events":{ref:"path","ref-x":5,"ref-y":5,"font-family":"Courier New","font-size":14,fill:"#000000"}},name:"State",events:[]},joint.shapes.basic.Generic.prototype.defaults),initialize:function(){_.bindAll(this,"updateEvents","updatePath"),this.on({"change:name":function(){this.updateName(),this.trigger("change:attrs")},"change:events":function(){this.updateEvents(),this.trigger("change:attrs")},"change:size":this.updatePath}),this.updateName(),this.updateEvents(),this.updatePath(),joint.shapes.basic.Generic.prototype.initialize.apply(this,arguments)},updateName:function(){this.get("attrs")[".uml-state-name"].text=this.get("name")},updateEvents:function(){this.get("attrs")[".uml-state-events"].text=this.get("events").join("\n")},updatePath:function(){this.get("attrs").path.d="M 0 20 L "+this.get("size").width+" 20"}}),joint.shapes.uml.StartState=joint.shapes.basic.Circle.extend({defaults:joint.util.deepSupplement({type:"uml.StartState",attrs:{circle:{fill:"#34495e",stroke:"#2c3e50","stroke-width":2,rx:1}}},joint.shapes.basic.Circle.prototype.defaults)}),joint.shapes.uml.EndState=joint.shapes.basic.Generic.extend({markup:'<g class="rotatable"><g class="scalable"><circle class="outer"/><circle class="inner"/></g></g>',defaults:joint.util.deepSupplement({type:"uml.EndState",size:{width:20,height:20},attrs:{"circle.outer":{transform:"translate(10, 10)",r:10,fill:"white",stroke:"#2c3e50"},"circle.inner":{transform:"translate(10, 10)",r:6,fill:"#34495e"}}},joint.shapes.basic.Generic.prototype.defaults)}),joint.shapes.uml.Transition=joint.dia.Link.extend({defaults:{type:"uml.Transition",attrs:{".marker-target":{d:"M 10 0 L 0 5 L 10 10 z",fill:"#34495e",stroke:"#2c3e50"},".connection":{stroke:"#2c3e50"}}}}),"object"==typeof exports&&(module.exports=joint.shapes.uml),function a(b,c,d){function e(g,h){if(!c[g]){if(!b[g]){var i="function"==typeof require&&require;if(!h&&i)return i(g,!0);if(f)return f(g,!0);throw new Error("Cannot find module '"+g+"'")}var j=c[g]={exports:{}};b[g][0].call(j.exports,function(a){var c=b[g][1][a];return e(c?c:a)},j,j.exports,a,b,c,d)}return c[g].exports}for(var f="function"==typeof require&&require,g=0;g<d.length;g++)e(d[g]);return e}({1:[function(a){var b="undefined"!=typeof self?self:"undefined"!=typeof window?window:{};b.dagre=a("./index")},{"./index":2}],2:[function(a,b,c){c.Digraph=a("graphlib").Digraph,c.Graph=a("graphlib").Graph,c.layout=a("./lib/layout"),c.version=a("./lib/version")},{"./lib/layout":3,"./lib/version":18,graphlib:24}],3:[function(a,b){var c=a("./util"),d=a("./rank"),e=a("./order"),f=a("graphlib").CGraph,g=a("graphlib").CDigraph;b.exports=function(){function b(a){var b=new g;a.eachNode(function(a,c){void 0===c&&(c={}),b.addNode(a,{width:c.width,height:c.height}),c.hasOwnProperty("rank")&&(b.node(a).prefRank=c.rank)}),a.parent&&a.nodes().forEach(function(c){b.parent(c,a.parent(c))}),a.eachEdge(function(a,c,d,e){void 0===e&&(e={});var f={e:a,minLen:e.minLen||1,width:e.width||0,height:e.height||0,points:[]};b.addEdge(null,c,d,f)});var c=a.graph()||{};return b.graph({rankDir:c.rankDir||n.rankDir,orderRestarts:c.orderRestarts}),b}function h(a){var f,g=p.rankSep();try{return f=c.time("initLayoutGraph",b)(a),0===f.order()?f:(f.eachEdge(function(a,b,c,d){d.minLen*=2}),p.rankSep(g/2),c.time("rank.run",d.run)(f,n.rankSimplex),c.time("normalize",i)(f),c.time("order",e)(f,n.orderMaxSweeps),c.time("position",o.run)(f),c.time("undoNormalize",j)(f),c.time("fixupEdgePoints",k)(f),c.time("rank.restoreEdges",d.restoreEdges)(f),c.time("createFinalGraph",l)(f,a.isDirected()))}finally{p.rankSep(g)}}function i(a){var b=0;a.eachEdge(function(c,d,e,f){var g=a.node(d).rank,h=a.node(e).rank;if(h>g+1){for(var i=d,j=g+1,k=0;h>j;++j,++k){var l="_D"+ ++b,m={width:f.width,height:f.height,edge:{id:c,source:d,target:e,attrs:f},rank:j,dummy:!0};0===k?m.index=0:j+1===h&&(m.index=1),a.addNode(l,m),a.addEdge(null,i,l,{}),i=l}a.addEdge(null,i,e,{}),a.delEdge(c)}})}function j(a){a.eachNode(function(b,c){if(c.dummy){if("index"in c){var d=c.edge;a.hasEdge(d.id)||a.addEdge(d.id,d.source,d.target,d.attrs);var e=a.edge(d.id).points;e[c.index]={x:c.x,y:c.y,ul:c.ul,ur:c.ur,dl:c.dl,dr:c.dr}}a.delNode(b)}})}function k(a){a.eachEdge(function(a,b,c,d){d.reversed&&d.points.reverse()})}function l(a,b){var c=b?new g:new f;c.graph(a.graph()),a.eachNode(function(a,b){c.addNode(a,b)}),a.eachNode(function(b){c.parent(b,a.parent(b))}),a.eachEdge(function(a,b,d,e){c.addEdge(e.e,b,d,e)});var d=0,e=0;return a.eachNode(function(b,c){a.children(b).length||(d=Math.max(d,c.x+c.width/2),e=Math.max(e,c.y+c.height/2))}),a.eachEdge(function(a,b,c,f){var g=Math.max.apply(Math,f.points.map(function(a){return a.x})),h=Math.max.apply(Math,f.points.map(function(a){return a.y}));d=Math.max(d,g+f.width/2),e=Math.max(e,h+f.height/2)}),c.graph().width=d,c.graph().height=e,c}function m(a){return function(){return arguments.length?(a.apply(null,arguments),p):a()}}var n={debugLevel:0,orderMaxSweeps:e.DEFAULT_MAX_SWEEPS,rankSimplex:!1,rankDir:"TB"},o=a("./position")(),p={};return p.orderIters=c.propertyAccessor(p,n,"orderMaxSweeps"),p.rankSimplex=c.propertyAccessor(p,n,"rankSimplex"),p.nodeSep=m(o.nodeSep),p.edgeSep=m(o.edgeSep),p.universalSep=m(o.universalSep),p.rankSep=m(o.rankSep),p.rankDir=c.propertyAccessor(p,n,"rankDir"),p.debugAlignment=m(o.debugAlignment),p.debugLevel=c.propertyAccessor(p,n,"debugLevel",function(a){c.log.level=a,o.debugLevel(a)}),p.run=c.time("Total layout",h),p._normalize=i,p}},{"./order":4,"./position":9,"./rank":10,"./util":17,graphlib:24}],4:[function(a,b){function c(a,b){function c(){a.eachNode(function(a,b){n[a]=b.order})}arguments.length<2&&(b=o);var d=a.graph().orderRestarts||0,e=l(a);e.forEach(function(b){b=b.filterNodes(function(b){return!a.children(b).length})});for(var g,h=0,i=Number.MAX_VALUE,n={},p=0;p<Number(d)+1&&0!==i;++p){g=Number.MAX_VALUE,m(a,d>0),j.log(2,"Order phase start cross count: "+a.graph().orderInitCC);var q,r,s;for(q=0,r=0;4>r&&b>q&&g>0;++q,++r,++h)f(a,e,q),s=k(a),g>s&&(r=0,g=s,i>s&&(c(),i=s)),j.log(3,"Order phase start "+p+" iter "+q+" cross count: "+s)}Object.keys(n).forEach(function(b){a.children&&a.children(b).length||(a.node(b).order=n[b])}),a.graph().orderCC=i,j.log(2,"Order iterations: "+h),j.log(2,"Order phase best cross count: "+a.graph().orderCC)}function d(a,b){var c={};return b.forEach(function(b){c[b]=a.inEdges(b).map(function(b){return a.node(a.source(b)).order})}),c}function e(a,b){var c={};return b.forEach(function(b){c[b]=a.outEdges(b).map(function(b){return a.node(a.target(b)).order})}),c}function f(a,b,c){0===c%2?g(a,b,c):h(a,b,c)}function g(a,b){var c;for(i=1;i<b.length;++i)c=n(b[i],c,d(a,b[i].nodes()))}function h(a,b){var c;for(i=b.length-2;i>=0;--i)n(b[i],c,e(a,b[i].nodes()))}var j=a("./util"),k=a("./order/crossCount"),l=a("./order/initLayerGraphs"),m=a("./order/initOrder"),n=a("./order/sortLayer");b.exports=c;var o=24;c.DEFAULT_MAX_SWEEPS=o},{"./order/crossCount":5,"./order/initLayerGraphs":6,"./order/initOrder":7,"./order/sortLayer":8,"./util":17}],5:[function(a,b){function c(a){for(var b=0,c=e.ordering(a),f=1;f<c.length;++f)b+=d(a,c[f-1],c[f]);return b}function d(a,b,c){var d=[];b.forEach(function(b){var c=[];a.outEdges(b).forEach(function(b){c.push(a.node(a.target(b)).order)}),c.sort(function(a,b){return a-b}),d=d.concat(c)});for(var e=1;e<c.length;)e<<=1;var f=2*e-1;e-=1;for(var g=[],h=0;f>h;++h)g[h]=0;var i=0;return d.forEach(function(a){var b=a+e;for(++g[b];b>0;)b%2&&(i+=g[b+1]),b=b-1>>1,++g[b]}),i}var e=a("../util");b.exports=c},{"../util":17}],6:[function(a,b){function c(a){function b(d){if(null===d)return a.children(d).forEach(function(a){b(a)}),void 0;var f=a.node(d);f.minRank="rank"in f?f.rank:Number.MAX_VALUE,f.maxRank="rank"in f?f.rank:Number.MIN_VALUE;var g=new e;return a.children(d).forEach(function(c){var d=b(c);g=e.union([g,d]),f.minRank=Math.min(f.minRank,a.node(c).minRank),f.maxRank=Math.max(f.maxRank,a.node(c).maxRank)}),"rank"in f&&g.add(f.rank),g.keys().forEach(function(a){a in c||(c[a]=[]),c[a].push(d)}),g}var c=[];b(null);var f=[];return c.forEach(function(b,c){f[c]=a.filterNodes(d(b))}),f}var d=a("graphlib").filter.nodesFromList,e=a("cp-data").Set;b.exports=c},{"cp-data":19,graphlib:24}],7:[function(a,b){function c(a,b){var c=[];a.eachNode(function(b,d){var e=c[d.rank];a.children&&a.children(b).length>0||(e||(e=c[d.rank]=[]),e.push(b))}),c.forEach(function(c){b&&e.shuffle(c),c.forEach(function(b,c){a.node(b).order=c})});var f=d(a);a.graph().orderInitCC=f,a.graph().orderCC=Number.MAX_VALUE}var d=a("./crossCount"),e=a("../util");b.exports=c},{"../util":17,"./crossCount":5}],8:[function(a,b){function c(a,b,c){var e=[],f={};a.eachNode(function(a,b){e[b.order]=a;var g=c[a];g.length&&(f[a]=d.sum(g)/g.length)});var g=a.nodes().filter(function(a){return void 0!==f[a]});g.sort(function(b,c){return f[b]-f[c]||a.node(b).order-a.node(c).order});for(var h=0,i=0,j=g.length;j>i;++h)void 0!==f[e[h]]&&(a.node(g[i++]).order=h)}var d=a("../util");b.exports=c},{"../util":17}],9:[function(a,b){var c=a("./util");b.exports=function(){function a(a){a=a.filterNodes(c.filterNonSubgraphs(a));var b=c.ordering(a),g=d(a,b),h={};["u","d"].forEach(function(c){"d"===c&&b.reverse(),["l","r"].forEach(function(d){"r"===d&&k(b);var i=c+d,l=e(a,b,g,"u"===c?"predecessors":"successors");h[i]=f(a,b,l.pos,l.root,l.align),s.debugLevel>=3&&r(c+d,a,b,h[i]),"r"===d&&j(h[i]),"r"===d&&k(b)}),"d"===c&&b.reverse()}),i(a,b,h),a.eachNode(function(b){var c=[];for(var d in h){var e=h[d][b];p(d,a,b,e),c.push(e)}c.sort(function(a,b){return a-b}),o(a,b,(c[1]+c[2])/2)});var n=0,t="BT"===a.graph().rankDir||"RL"===a.graph().rankDir;b.forEach(function(b){var d=c.max(b.map(function(b){return m(a,b)}));n+=d/2,b.forEach(function(b){q(a,b,t?-n:n)}),n+=d/2+s.rankSep});var u=c.min(a.nodes().map(function(b){return o(a,b)-l(a,b)/2})),v=c.min(a.nodes().map(function(b){return q(a,b)-m(a,b)/2}));a.eachNode(function(b){o(a,b,o(a,b)-u),q(a,b,q(a,b)-v)})}function b(a,b){return b>a?a.toString().length+":"+a+"-"+b:b.toString().length+":"+b+"-"+a}function d(a,c){function d(a){var c=k[a];(g>c||c>i)&&(j[b(f[h],a)]=!0)}var e,f,g,h,i,j={},k={};if(c.length<=2)return j;c[1].forEach(function(a,b){k[a]=b});for(var l=1;l<c.length-1;++l){e=c[l],f=c[l+1],g=0,h=0;for(var m=0;m<f.length;++m){var n=f[m];if(k[n]=m,i=void 0,a.node(n).dummy){var o=a.predecessors(n)[0];void 0!==o&&a.node(o).dummy&&(i=k[o])}if(void 0===i&&m===f.length-1&&(i=e.length-1),void 0!==i){for(;m>=h;++h)a.predecessors(f[h]).forEach(d);g=i}}}return j}function e(a,c,d,e){var f={},g={},h={};return c.forEach(function(a){a.forEach(function(a,b){g[a]=a,h[a]=a,f[a]=b})}),c.forEach(function(c){var i=-1;c.forEach(function(c){var j,k=a[e](c);k.length>0&&(k.sort(function(a,b){return f[a]-f[b]}),j=(k.length-1)/2,k.slice(Math.floor(j),Math.ceil(j)+1).forEach(function(a){h[c]===c&&!d[b(a,c)]&&i<f[a]&&(h[a]=c,h[c]=g[c]=g[a],i=f[a])}))})}),{pos:f,root:g,align:h}}function f(a,b,d,e,f){function g(a,b,c){j[a][b]=b in j[a]?Math.min(j[a][b],c):c}function h(b){if(!(b in m)){m[b]=0;var c=b;do{if(d[c]>0){var j=e[l[c]];h(j),i[b]===b&&(i[b]=i[j]);var k=n(a,l[c])+n(a,c);i[b]!==i[j]?g(i[j],i[b],m[b]-m[j]-k):m[b]=Math.max(m[b],m[j]+k)}c=f[c]}while(c!==b)}}var i={},j={},k={},l={},m={};return b.forEach(function(a){a.forEach(function(b,c){i[b]=b,j[b]={},c>0&&(l[b]=a[c-1])})}),c.values(e).forEach(function(a){h(a)}),b.forEach(function(a){a.forEach(function(a){if(m[a]=m[e[a]],a===e[a]&&a===i[a]){var b=0;a in j&&Object.keys(j[a]).length>0&&(b=c.min(Object.keys(j[a]).map(function(b){return j[a][b]+(b in k?k[b]:0)}))),k[a]=b}})}),b.forEach(function(a){a.forEach(function(a){m[a]+=k[i[e[a]]]||0})}),m}function g(a,b,d){return c.min(b.map(function(a){var b=a[0];return d[b]}))}function h(a,b,d){return c.max(b.map(function(a){var b=a[a.length-1];return d[b]}))}function i(a,b,c){function d(a){c[l][a]+=j[l]}var e,f={},i={},j={},k=Number.POSITIVE_INFINITY;for(var l in c){var m=c[l];f[l]=g(a,b,m),i[l]=h(a,b,m);var n=i[l]-f[l];k>n&&(k=n,e=l)}["u","d"].forEach(function(a){["l","r"].forEach(function(b){var c=a+b;j[c]="l"===b?f[e]-f[c]:i[e]-i[c]})});for(l in c)a.eachNode(d)}function j(a){for(var b in a)a[b]=-a[b]}function k(a){a.forEach(function(a){a.reverse()})}function l(a,b){switch(a.graph().rankDir){case"LR":return a.node(b).height;case"RL":return a.node(b).height;default:return a.node(b).width}}function m(a,b){switch(a.graph().rankDir){case"LR":return a.node(b).width;case"RL":return a.node(b).width;default:return a.node(b).height}}function n(a,b){if(null!==s.universalSep)return s.universalSep;var c=l(a,b),d=a.node(b).dummy?s.edgeSep:s.nodeSep;return(c+d)/2}function o(a,b,c){if("LR"===a.graph().rankDir||"RL"===a.graph().rankDir){if(arguments.length<3)return a.node(b).y;a.node(b).y=c}else{if(arguments.length<3)return a.node(b).x;a.node(b).x=c}}function p(a,b,c,d){if("LR"===b.graph().rankDir||"RL"===b.graph().rankDir){if(arguments.length<3)return b.node(c)[a];b.node(c)[a]=d}else{if(arguments.length<3)return b.node(c)[a];b.node(c)[a]=d}}function q(a,b,c){if("LR"===a.graph().rankDir||"RL"===a.graph().rankDir){if(arguments.length<3)return a.node(b).x;a.node(b).x=c}else{if(arguments.length<3)return a.node(b).y;a.node(b).y=c}}function r(a,b,c,d){c.forEach(function(c,e){var f,g;c.forEach(function(c){var h=d[c];if(f){var i=n(b,f)+n(b,c);i>h-g&&console.log("Position phase: sep violation. Align: "+a+". Layer: "+e+". "+"U: "+f+" V: "+c+". Actual sep: "+(h-g)+" Expected sep: "+i)}f=c,g=h})})}var s={nodeSep:50,edgeSep:10,universalSep:null,rankSep:30},t={};return t.nodeSep=c.propertyAccessor(t,s,"nodeSep"),t.edgeSep=c.propertyAccessor(t,s,"edgeSep"),t.universalSep=c.propertyAccessor(t,s,"universalSep"),t.rankSep=c.propertyAccessor(t,s,"rankSep"),t.debugLevel=c.propertyAccessor(t,s,"debugLevel"),t.run=a,t}},{"./util":17}],10:[function(a,b,c){function d(a,b){f(a),l.time("constraints.apply",p.apply)(a),g(a),l.time("acyclic",m)(a);var c=a.filterNodes(l.filterNonSubgraphs(a));n(c),r(c).forEach(function(a){var d=c.filterNodes(s.nodesFromList(a));j(d,b)}),l.time("constraints.relax",p.relax(a)),l.time("reorientEdges",i)(a)}function e(a){m.undo(a)}function f(a){a.eachEdge(function(b,c,d,e){if(c===d){var f=h(a,b,c,d,e,0,!1),g=h(a,b,c,d,e,1,!0),i=h(a,b,c,d,e,2,!1);a.addEdge(null,f,c,{minLen:1,selfLoop:!0}),a.addEdge(null,f,g,{minLen:1,selfLoop:!0}),a.addEdge(null,c,i,{minLen:1,selfLoop:!0}),a.addEdge(null,g,i,{minLen:1,selfLoop:!0}),a.delEdge(b)}})}function g(a){a.eachEdge(function(b,c,d,e){if(c===d){var f=e.originalEdge,g=h(a,f.e,f.u,f.v,f.value,0,!0);a.addEdge(null,c,g,{minLen:1}),a.addEdge(null,g,d,{minLen:1}),a.delEdge(b)}})}function h(a,b,c,d,e,f,g){return a.addNode(null,{width:g?e.width:0,height:g?e.height:0,edge:{id:b,source:c,target:d,attrs:e},dummy:!0,index:f})}function i(a){a.eachEdge(function(b,c,d,e){a.node(c).rank>a.node(d).rank&&(a.delEdge(b),e.reversed=!0,a.addEdge(b,d,c,e))})}function j(a,b){var c=o(a);b&&(l.log(1,"Using network simplex for ranking"),q(a,c)),k(a)}function k(a){var b=l.min(a.nodes().map(function(b){return a.node(b).rank}));a.eachNode(function(a,c){c.rank-=b})}var l=a("./util"),m=a("./rank/acyclic"),n=a("./rank/initRank"),o=a("./rank/feasibleTree"),p=a("./rank/constraints"),q=a("./rank/simplex"),r=a("graphlib").alg.components,s=a("graphlib").filter;c.run=d,c.restoreEdges=e},{"./rank/acyclic":11,"./rank/constraints":12,"./rank/feasibleTree":13,"./rank/initRank":14,"./rank/simplex":16,"./util":17,graphlib:24}],11:[function(a,b){function c(a){function b(e){e in d||(d[e]=c[e]=!0,a.outEdges(e).forEach(function(d){var g,h=a.target(d);e===h?console.error('Warning: found self loop "'+d+'" for node "'+e+'"'):h in c?(g=a.edge(d),a.delEdge(d),g.reversed=!0,++f,a.addEdge(d,h,e,g)):b(h)}),delete c[e])}var c={},d={},f=0;return a.eachNode(function(a){b(a)}),e.log(2,"Acyclic Phase: reversed "+f+" edge(s)"),f}function d(a){a.eachEdge(function(b,c,d,e){e.reversed&&(delete e.reversed,a.delEdge(b),a.addEdge(b,d,c,e))})}var e=a("../util");b.exports=c,b.exports.undo=d},{"../util":17}],12:[function(a,b,c){function d(a){return"min"!==a&&"max"!==a&&0!==a.indexOf("same_")?(console.error("Unsupported rank type: "+a),!1):!0}function e(a,b,c,d){a.inEdges(b).forEach(function(b){var e,f=a.edge(b);e=f.originalEdge?f:{originalEdge:{e:b,u:a.source(b),v:a.target(b),value:f},minLen:a.edge(b).minLen},f.selfLoop&&(d=!1),d?(a.addEdge(null,c,a.source(b),e),e.reversed=!0):a.addEdge(null,a.source(b),c,e)})}function f(a,b,c,d){a.outEdges(b).forEach(function(b){var e,f=a.edge(b);e=f.originalEdge?f:{originalEdge:{e:b,u:a.source(b),v:a.target(b),value:f},minLen:a.edge(b).minLen},f.selfLoop&&(d=!1),d?(a.addEdge(null,a.target(b),c,e),e.reversed=!0):a.addEdge(null,c,a.target(b),e)})}function g(a,b,c){void 0!==c&&a.children(b).forEach(function(b){b===c||a.outEdges(c,b).length||a.node(b).dummy||a.addEdge(null,c,b,{minLen:0})})}function h(a,b,c){void 0!==c&&a.children(b).forEach(function(b){b===c||a.outEdges(b,c).length||a.node(b).dummy||a.addEdge(null,b,c,{minLen:0})})}c.apply=function(a){function b(c){var i={};a.children(c).forEach(function(g){if(a.children(g).length)return b(g),void 0;var h=a.node(g),j=h.prefRank;if(void 0!==j){if(!d(j))return;j in i?i.prefRank.push(g):i.prefRank=[g];var k=i[j];void 0===k&&(k=i[j]=a.addNode(null,{originalNodes:[]}),a.parent(k,c)),e(a,g,k,"min"===j),f(a,g,k,"max"===j),a.node(k).originalNodes.push({u:g,value:h,parent:c}),a.delNode(g)}}),g(a,c,i.min),h(a,c,i.max)}b(null)},c.relax=function(a){var b=[];a.eachEdge(function(a,c,d,e){var f=e.originalEdge;f&&b.push(f)}),a.eachNode(function(b,c){var d=c.originalNodes;d&&(d.forEach(function(b){b.value.rank=c.rank,a.addNode(b.u,b.value),a.parent(b.u,b.parent)}),a.delNode(b))}),b.forEach(function(b){a.addEdge(b.e,b.u,b.v,b.value)})}},{}],13:[function(a,b){function c(a){function b(c){var e=!0;return a.predecessors(c).forEach(function(f){g.has(f)&&!d(a,f,c)&&(g.has(c)&&(h.addNode(c,{}),g.remove(c),h.graph({root:c})),h.addNode(f,{}),h.addEdge(null,f,c,{reversed:!0}),g.remove(f),b(f),e=!1)}),a.successors(c).forEach(function(f){g.has(f)&&!d(a,c,f)&&(g.has(c)&&(h.addNode(c,{}),g.remove(c),h.graph({root:c})),h.addNode(f,{}),h.addEdge(null,c,f,{}),g.remove(f),b(f),e=!1)}),e}function c(){var b=Number.MAX_VALUE;g.keys().forEach(function(c){a.predecessors(c).forEach(function(e){if(!g.has(e)){var f=d(a,e,c);Math.abs(f)<Math.abs(b)&&(b=-f)}}),a.successors(c).forEach(function(e){if(!g.has(e)){var f=d(a,c,e);Math.abs(f)<Math.abs(b)&&(b=f)}})}),h.eachNode(function(c){a.node(c).rank-=b})}var g=new e(a.nodes()),h=new f;if(1===g.size()){var i=a.nodes()[0];return h.addNode(i,{}),h.graph({root:i}),h}for(;g.size();){for(var j=h.order()?h.nodes():g.keys(),k=0,l=j.length;l>k&&b(j[k]);++k);g.size()&&c()}return h}function d(a,b,c){var d=a.node(c).rank-a.node(b).rank,e=g.max(a.outEdges(b,c).map(function(b){return a.edge(b).minLen}));return d-e}var e=a("cp-data").Set,f=a("graphlib").Digraph,g=a("../util");b.exports=c},{"../util":17,"cp-data":19,graphlib:24}],14:[function(a,b){function c(a){var b=e(a);b.forEach(function(b){var c=a.inEdges(b);if(0===c.length)return a.node(b).rank=0,void 0;var e=c.map(function(b){return a.node(a.source(b)).rank+a.edge(b).minLen});a.node(b).rank=d.max(e)})}var d=a("../util"),e=a("graphlib").alg.topsort;b.exports=c},{"../util":17,graphlib:24}],15:[function(a,b){function c(a,b,c,d){return Math.abs(a.node(b).rank-a.node(c).rank)-d}b.exports={slack:c}},{}],16:[function(a,b){function c(a,b){for(d(a,b);;){var c=h(b);if(null===c)break;var e=i(a,b,c);j(a,b,c,e)}}function d(a,b){function c(d){var e=b.successors(d);for(var g in e){var h=e[g];c(h)}d!==b.graph().root&&f(a,b,d)}e(b),b.eachEdge(function(a,b,c,d){d.cutValue=0}),c(b.graph().root)}function e(a){function b(d){var e=a.successors(d),f=c;for(var g in e){var h=e[g];b(h),f=Math.min(f,a.node(h).low)}a.node(d).low=f,a.node(d).lim=c++}var c=0;b(a.graph().root)}function f(a,b,c){var d=b.inEdges(c)[0],e=[],f=b.outEdges(c);for(var h in f)e.push(b.target(f[h]));var i,j=0,k=0,l=0,m=0,n=0,o=a.outEdges(c);for(var p in o){var q=a.target(o[p]);for(i in e)g(b,q,e[i])&&k++;g(b,q,c)||m++}var r=a.inEdges(c);for(var s in r){var t=a.source(r[s]);for(i in e)g(b,t,e[i])&&l++;g(b,t,c)||n++}var u=0;for(i in e){var v=b.edge(f[i]).cutValue;b.edge(f[i]).reversed?u-=v:u+=v}b.edge(d).reversed?j-=u-k+l-m+n:j+=u-k+l-m+n,b.edge(d).cutValue=j}function g(a,b,c){return a.node(c).low<=a.node(b).lim&&a.node(b).lim<=a.node(c).lim}function h(a){var b=a.edges();for(var c in b){var d=b[c],e=a.edge(d);if(e.cutValue<0)return d}return null}function i(a,b,c){var d,e=b.source(c),f=b.target(c),h=b.node(f).lim<b.node(e).lim?f:e,i=!b.edge(c).reversed,j=Number.POSITIVE_INFINITY;if(i?a.eachEdge(function(e,f,i,k){if(e!==c&&g(b,f,h)&&!g(b,i,h)){var l=n.slack(a,f,i,k.minLen);j>l&&(j=l,d=e)}}):a.eachEdge(function(e,f,i,k){if(e!==c&&!g(b,f,h)&&g(b,i,h)){var l=n.slack(a,f,i,k.minLen);j>l&&(j=l,d=e)}}),void 0===d){var k=[],l=[];throw a.eachNode(function(a){g(b,a,h)?l.push(a):k.push(a)}),new Error("No edge found from outside of tree to inside")}return d}function j(a,b,c,e){function f(a){var c=b.inEdges(a);for(var d in c){var e=c[d],g=b.source(e),h=b.edge(e);f(g),b.delEdge(e),h.reversed=!h.reversed,b.addEdge(e,a,g,h)}}b.delEdge(c);var g=a.source(e),h=a.target(e);f(h);for(var i=g,j=b.inEdges(i);j.length>0;)i=b.source(j[0]),j=b.inEdges(i);b.graph().root=i,b.addEdge(null,g,h,{cutValue:0}),d(a,b),k(a,b)}function k(a,b){function c(d){var e=b.successors(d);e.forEach(function(b){var e=l(a,d,b);a.node(b).rank=a.node(d).rank+e,c(b)})}c(b.graph().root)}function l(a,b,c){var d=a.outEdges(b,c);if(d.length>0)return m.max(d.map(function(b){return a.edge(b).minLen}));var e=a.inEdges(b,c);return e.length>0?-m.max(e.map(function(b){return a.edge(b).minLen})):void 0}var m=a("../util"),n=a("./rankUtil");b.exports=c},{"../util":17,"./rankUtil":15}],17:[function(a,b,c){function d(a,b){return function(){var c=(new Date).getTime();try{return b.apply(null,arguments)}finally{e(1,a+" time: "+((new Date).getTime()-c)+"ms")}}}function e(a){e.level>=a&&console.log.apply(console,Array.prototype.slice.call(arguments,1))}c.min=function(a){return Math.min.apply(Math,a)},c.max=function(a){return Math.max.apply(Math,a)},c.all=function(a,b){for(var c=0;c<a.length;++c)if(!b(a[c]))return!1;return!0},c.sum=function(a){return a.reduce(function(a,b){return a+b},0)},c.values=function(a){return Object.keys(a).map(function(b){return a[b]})},c.shuffle=function(a){for(i=a.length-1;i>0;--i){var b=Math.floor(Math.random()*(i+1)),c=a[b];a[b]=a[i],a[i]=c}},c.propertyAccessor=function(a,b,c,d){return function(e){return arguments.length?(b[c]=e,d&&d(e),a):b[c]}},c.ordering=function(a){var b=[];return a.eachNode(function(a,c){var d=b[c.rank]||(b[c.rank]=[]);d[c.order]=a}),b},c.filterNonSubgraphs=function(a){return function(b){return 0===a.children(b).length}},d.enabled=!1,c.time=d,e.level=0,c.log=e},{}],18:[function(a,b){b.exports="0.4.5"},{}],19:[function(a,b,c){c.Set=a("./lib/Set"),c.PriorityQueue=a("./lib/PriorityQueue"),c.version=a("./lib/version")},{"./lib/PriorityQueue":20,"./lib/Set":21,"./lib/version":23}],20:[function(a,b){function c(){this._arr=[],this._keyIndices={}}b.exports=c,c.prototype.size=function(){return this._arr.length},c.prototype.keys=function(){return this._arr.map(function(a){return a.key})},c.prototype.has=function(a){return a in this._keyIndices},c.prototype.priority=function(a){var b=this._keyIndices[a];return void 0!==b?this._arr[b].priority:void 0},c.prototype.min=function(){if(0===this.size())throw new Error("Queue underflow");return this._arr[0].key},c.prototype.add=function(a,b){var c=this._keyIndices;if(!(a in c)){var d=this._arr,e=d.length;return c[a]=e,d.push({key:a,priority:b}),this._decrease(e),!0}return!1},c.prototype.removeMin=function(){this._swap(0,this._arr.length-1);var a=this._arr.pop();return delete this._keyIndices[a.key],this._heapify(0),a.key},c.prototype.decrease=function(a,b){var c=this._keyIndices[a];if(b>this._arr[c].priority)throw new Error("New priority is greater than current priority. Key: "+a+" Old: "+this._arr[c].priority+" New: "+b);this._arr[c].priority=b,this._decrease(c)},c.prototype._heapify=function(a){var b=this._arr,c=2*a,d=c+1,e=a;c<b.length&&(e=b[c].priority<b[e].priority?c:e,d<b.length&&(e=b[d].priority<b[e].priority?d:e),e!==a&&(this._swap(a,e),this._heapify(e)))},c.prototype._decrease=function(a){for(var b,c=this._arr,d=c[a].priority;0!==a&&(b=a>>1,!(c[b].priority<d));)this._swap(a,b),a=b},c.prototype._swap=function(a,b){var c=this._arr,d=this._keyIndices,e=c[a],f=c[b];c[a]=f,c[b]=e,d[f.key]=a,d[e.key]=b}},{}],21:[function(a,b){function c(a){if(this._size=0,this._keys={},a)for(var b=0,c=a.length;c>b;++b)this.add(a[b])}function d(a){var b,c=Object.keys(a),d=c.length,e=new Array(d);for(b=0;d>b;++b)e[b]=a[c[b]];return e}var e=a("./util");b.exports=c,c.intersect=function(a){if(0===a.length)return new c;for(var b=new c(e.isArray(a[0])?a[0]:a[0].keys()),d=1,f=a.length;f>d;++d)for(var g=b.keys(),h=e.isArray(a[d])?new c(a[d]):a[d],i=0,j=g.length;j>i;++i){var k=g[i];h.has(k)||b.remove(k)}return b},c.union=function(a){for(var b=e.reduce(a,function(a,b){return a+(b.size?b.size():b.length)},0),d=new Array(b),f=0,g=0,h=a.length;h>g;++g)for(var i=a[g],j=e.isArray(i)?i:i.keys(),k=0,l=j.length;l>k;++k)d[f++]=j[k];return new c(d)},c.prototype.size=function(){return this._size},c.prototype.keys=function(){return d(this._keys)},c.prototype.has=function(a){return a in this._keys},c.prototype.add=function(a){return a in this._keys?!1:(this._keys[a]=a,++this._size,!0)},c.prototype.remove=function(a){return a in this._keys?(delete this._keys[a],--this._size,!0):!1}},{"./util":22}],22:[function(a,b,c){c.isArray=Array.isArray?Array.isArray:function(a){return"[object Array]"===Object.prototype.toString.call(a)},c.reduce="function"!=typeof Array.prototype.reduce?function(a,b,c){"use strict";if(null===a||"undefined"==typeof a)throw new TypeError("Array.prototype.reduce called on null or undefined");if("function"!=typeof b)throw new TypeError(b+" is not a function");var d,e,f=a.length>>>0,g=!1;for(1<arguments.length&&(e=c,g=!0),d=0;f>d;++d)a.hasOwnProperty(d)&&(g?e=b(e,a[d],d,a):(e=a[d],g=!0));if(!g)throw new TypeError("Reduce of empty array with no initial value");return e}:function(a,b,c){return a.reduce(b,c)}},{}],23:[function(a,b){b.exports="1.1.3"},{}],24:[function(a,b,c){c.Graph=a("./lib/Graph"),c.Digraph=a("./lib/Digraph"),c.CGraph=a("./lib/CGraph"),c.CDigraph=a("./lib/CDigraph"),a("./lib/graph-converters"),c.alg={isAcyclic:a("./lib/alg/isAcyclic"),components:a("./lib/alg/components"),dijkstra:a("./lib/alg/dijkstra"),dijkstraAll:a("./lib/alg/dijkstraAll"),findCycles:a("./lib/alg/findCycles"),floydWarshall:a("./lib/alg/floydWarshall"),postorder:a("./lib/alg/postorder"),preorder:a("./lib/alg/preorder"),prim:a("./lib/alg/prim"),tarjan:a("./lib/alg/tarjan"),topsort:a("./lib/alg/topsort")},c.converter={json:a("./lib/converter/json.js")};var d=a("./lib/filter");c.filter={all:d.all,nodesFromList:d.nodesFromList},c.version=a("./lib/version")},{"./lib/CDigraph":26,"./lib/CGraph":27,"./lib/Digraph":28,"./lib/Graph":29,"./lib/alg/components":30,"./lib/alg/dijkstra":31,"./lib/alg/dijkstraAll":32,"./lib/alg/findCycles":33,"./lib/alg/floydWarshall":34,"./lib/alg/isAcyclic":35,"./lib/alg/postorder":36,"./lib/alg/preorder":37,"./lib/alg/prim":38,"./lib/alg/tarjan":39,"./lib/alg/topsort":40,"./lib/converter/json.js":42,"./lib/filter":43,"./lib/graph-converters":44,"./lib/version":46}],25:[function(a,b){function c(){this._value=void 0,this._nodes={},this._edges={},this._nextId=0}function d(a,b,c){(a[b]||(a[b]=new f)).add(c)}function e(a,b,c){var d=a[b];d.remove(c),0===d.size()&&delete a[b]}var f=a("cp-data").Set;b.exports=c,c.prototype.order=function(){return Object.keys(this._nodes).length},c.prototype.size=function(){return Object.keys(this._edges).length},c.prototype.graph=function(a){return 0===arguments.length?this._value:(this._value=a,void 0)},c.prototype.hasNode=function(a){return a in this._nodes},c.prototype.node=function(a,b){var c=this._strictGetNode(a);return 1===arguments.length?c.value:(c.value=b,void 0)},c.prototype.nodes=function(){var a=[];return this.eachNode(function(b){a.push(b)}),a},c.prototype.eachNode=function(a){for(var b in this._nodes){var c=this._nodes[b];a(c.id,c.value)}},c.prototype.hasEdge=function(a){return a in this._edges},c.prototype.edge=function(a,b){var c=this._strictGetEdge(a);return 1===arguments.length?c.value:(c.value=b,void 0)},c.prototype.edges=function(){var a=[];return this.eachEdge(function(b){a.push(b)}),a},c.prototype.eachEdge=function(a){for(var b in this._edges){var c=this._edges[b];a(c.id,c.u,c.v,c.value)}},c.prototype.incidentNodes=function(a){var b=this._strictGetEdge(a);return[b.u,b.v]},c.prototype.addNode=function(a,b){if(void 0===a||null===a){do a="_"+ ++this._nextId;while(this.hasNode(a))}else if(this.hasNode(a))throw new Error("Graph already has node '"+a+"'");return this._nodes[a]={id:a,value:b},a},c.prototype.delNode=function(a){this._strictGetNode(a),this.incidentEdges(a).forEach(function(a){this.delEdge(a)},this),delete this._nodes[a]},c.prototype._addEdge=function(a,b,c,e,f,g){if(this._strictGetNode(b),this._strictGetNode(c),void 0===a||null===a){do a="_"+ ++this._nextId;while(this.hasEdge(a))}else if(this.hasEdge(a))throw new Error("Graph already has edge '"+a+"'");return this._edges[a]={id:a,u:b,v:c,value:e},d(f[c],b,a),d(g[b],c,a),a},c.prototype._delEdge=function(a,b,c){var d=this._strictGetEdge(a);e(b[d.v],d.u,a),e(c[d.u],d.v,a),delete this._edges[a]},c.prototype.copy=function(){var a=new this.constructor;return a.graph(this.graph()),this.eachNode(function(b,c){a.addNode(b,c)}),this.eachEdge(function(b,c,d,e){a.addEdge(b,c,d,e)}),a._nextId=this._nextId,a},c.prototype.filterNodes=function(a){var b=new this.constructor;return b.graph(this.graph()),this.eachNode(function(c,d){a(c)&&b.addNode(c,d)}),this.eachEdge(function(a,c,d,e){b.hasNode(c)&&b.hasNode(d)&&b.addEdge(a,c,d,e)}),b},c.prototype._strictGetNode=function(a){var b=this._nodes[a];if(void 0===b)throw new Error("Node '"+a+"' is not in graph");return b},c.prototype._strictGetEdge=function(a){var b=this._edges[a];if(void 0===b)throw new Error("Edge '"+a+"' is not in graph");
return b}},{"cp-data":19}],26:[function(a,b){var c=a("./Digraph"),d=a("./compoundify"),e=d(c);b.exports=e,e.fromDigraph=function(a){var b=new e,c=a.graph();return void 0!==c&&b.graph(c),a.eachNode(function(a,c){void 0===c?b.addNode(a):b.addNode(a,c)}),a.eachEdge(function(a,c,d,e){void 0===e?b.addEdge(null,c,d):b.addEdge(null,c,d,e)}),b},e.prototype.toString=function(){return"CDigraph "+JSON.stringify(this,null,2)}},{"./Digraph":28,"./compoundify":41}],27:[function(a,b){var c=a("./Graph"),d=a("./compoundify"),e=d(c);b.exports=e,e.fromGraph=function(a){var b=new e,c=a.graph();return void 0!==c&&b.graph(c),a.eachNode(function(a,c){void 0===c?b.addNode(a):b.addNode(a,c)}),a.eachEdge(function(a,c,d,e){void 0===e?b.addEdge(null,c,d):b.addEdge(null,c,d,e)}),b},e.prototype.toString=function(){return"CGraph "+JSON.stringify(this,null,2)}},{"./Graph":29,"./compoundify":41}],28:[function(a,b){function c(){e.call(this),this._inEdges={},this._outEdges={}}var d=a("./util"),e=a("./BaseGraph"),f=a("cp-data").Set;b.exports=c,c.prototype=new e,c.prototype.constructor=c,c.prototype.isDirected=function(){return!0},c.prototype.successors=function(a){return this._strictGetNode(a),Object.keys(this._outEdges[a]).map(function(a){return this._nodes[a].id},this)},c.prototype.predecessors=function(a){return this._strictGetNode(a),Object.keys(this._inEdges[a]).map(function(a){return this._nodes[a].id},this)},c.prototype.neighbors=function(a){return f.union([this.successors(a),this.predecessors(a)]).keys()},c.prototype.sources=function(){var a=this;return this._filterNodes(function(b){return 0===a.inEdges(b).length})},c.prototype.sinks=function(){var a=this;return this._filterNodes(function(b){return 0===a.outEdges(b).length})},c.prototype.source=function(a){return this._strictGetEdge(a).u},c.prototype.target=function(a){return this._strictGetEdge(a).v},c.prototype.inEdges=function(a,b){this._strictGetNode(a);var c=f.union(d.values(this._inEdges[a])).keys();return arguments.length>1&&(this._strictGetNode(b),c=c.filter(function(a){return this.source(a)===b},this)),c},c.prototype.outEdges=function(a,b){this._strictGetNode(a);var c=f.union(d.values(this._outEdges[a])).keys();return arguments.length>1&&(this._strictGetNode(b),c=c.filter(function(a){return this.target(a)===b},this)),c},c.prototype.incidentEdges=function(a,b){return arguments.length>1?f.union([this.outEdges(a,b),this.outEdges(b,a)]).keys():f.union([this.inEdges(a),this.outEdges(a)]).keys()},c.prototype.toString=function(){return"Digraph "+JSON.stringify(this,null,2)},c.prototype.addNode=function(a,b){return a=e.prototype.addNode.call(this,a,b),this._inEdges[a]={},this._outEdges[a]={},a},c.prototype.delNode=function(a){e.prototype.delNode.call(this,a),delete this._inEdges[a],delete this._outEdges[a]},c.prototype.addEdge=function(a,b,c,d){return e.prototype._addEdge.call(this,a,b,c,d,this._inEdges,this._outEdges)},c.prototype.delEdge=function(a){e.prototype._delEdge.call(this,a,this._inEdges,this._outEdges)},c.prototype._filterNodes=function(a){var b=[];return this.eachNode(function(c){a(c)&&b.push(c)}),b}},{"./BaseGraph":25,"./util":45,"cp-data":19}],29:[function(a,b){function c(){e.call(this),this._incidentEdges={}}var d=a("./util"),e=a("./BaseGraph"),f=a("cp-data").Set;b.exports=c,c.prototype=new e,c.prototype.constructor=c,c.prototype.isDirected=function(){return!1},c.prototype.neighbors=function(a){return this._strictGetNode(a),Object.keys(this._incidentEdges[a]).map(function(a){return this._nodes[a].id},this)},c.prototype.incidentEdges=function(a,b){return this._strictGetNode(a),arguments.length>1?(this._strictGetNode(b),b in this._incidentEdges[a]?this._incidentEdges[a][b].keys():[]):f.union(d.values(this._incidentEdges[a])).keys()},c.prototype.toString=function(){return"Graph "+JSON.stringify(this,null,2)},c.prototype.addNode=function(a,b){return a=e.prototype.addNode.call(this,a,b),this._incidentEdges[a]={},a},c.prototype.delNode=function(a){e.prototype.delNode.call(this,a),delete this._incidentEdges[a]},c.prototype.addEdge=function(a,b,c,d){return e.prototype._addEdge.call(this,a,b,c,d,this._incidentEdges,this._incidentEdges)},c.prototype.delEdge=function(a){e.prototype._delEdge.call(this,a,this._incidentEdges,this._incidentEdges)}},{"./BaseGraph":25,"./util":45,"cp-data":19}],30:[function(a,b){function c(a){function b(c,d){e.has(c)||(e.add(c),d.push(c),a.neighbors(c).forEach(function(a){b(a,d)}))}var c=[],e=new d;return a.nodes().forEach(function(a){var d=[];b(a,d),d.length>0&&c.push(d)}),c}var d=a("cp-data").Set;b.exports=c},{"cp-data":19}],31:[function(a,b){function c(a,b,c,e){function f(b){var d=a.incidentNodes(b),e=d[0]!==i?d[0]:d[1],f=g[e],k=c(b),l=j.distance+k;if(0>k)throw new Error("dijkstra does not allow negative edge weights. Bad edge: "+b+" Weight: "+k);l<f.distance&&(f.distance=l,f.predecessor=i,h.decrease(e,l))}var g={},h=new d;c=c||function(){return 1},e=e||(a.isDirected()?function(b){return a.outEdges(b)}:function(b){return a.incidentEdges(b)}),a.eachNode(function(a){var c=a===b?0:Number.POSITIVE_INFINITY;g[a]={distance:c},h.add(a,c)});for(var i,j;h.size()>0&&(i=h.removeMin(),j=g[i],j.distance!==Number.POSITIVE_INFINITY);)e(i).forEach(f);return g}var d=a("cp-data").PriorityQueue;b.exports=c},{"cp-data":19}],32:[function(a,b){function c(a,b,c){var e={};return a.eachNode(function(f){e[f]=d(a,f,b,c)}),e}var d=a("./dijkstra");b.exports=c},{"./dijkstra":31}],33:[function(a,b){function c(a){return d(a).filter(function(a){return a.length>1})}var d=a("./tarjan");b.exports=c},{"./tarjan":39}],34:[function(a,b){function c(a,b,c){var d={},e=a.nodes();return b=b||function(){return 1},c=c||(a.isDirected()?function(b){return a.outEdges(b)}:function(b){return a.incidentEdges(b)}),e.forEach(function(f){d[f]={},d[f][f]={distance:0},e.forEach(function(a){f!==a&&(d[f][a]={distance:Number.POSITIVE_INFINITY})}),c(f).forEach(function(c){var e=a.incidentNodes(c),g=e[0]!==f?e[0]:e[1],h=b(c);h<d[f][g].distance&&(d[f][g]={distance:h,predecessor:f})})}),e.forEach(function(a){var b=d[a];e.forEach(function(c){var f=d[c];e.forEach(function(c){var d=f[a],e=b[c],g=f[c],h=d.distance+e.distance;h<g.distance&&(g.distance=h,g.predecessor=e.predecessor)})})}),d}b.exports=c},{}],35:[function(a,b){function c(a){try{d(a)}catch(b){if(b instanceof d.CycleException)return!1;throw b}return!0}var d=a("./topsort");b.exports=c},{"./topsort":40}],36:[function(a,b){function c(a,b,c){function e(b,d){if(f.has(b))throw new Error("The input graph is not a tree: "+a);f.add(b),a.neighbors(b).forEach(function(a){a!==d&&e(a,b)}),c(b)}var f=new d;if(a.isDirected())throw new Error("This function only works for undirected graphs");e(b)}var d=a("cp-data").Set;b.exports=c},{"cp-data":19}],37:[function(a,b){function c(a,b,c){function e(b,d){if(f.has(b))throw new Error("The input graph is not a tree: "+a);f.add(b),c(b),a.neighbors(b).forEach(function(a){a!==d&&e(a,b)})}var f=new d;if(a.isDirected())throw new Error("This function only works for undirected graphs");e(b)}var d=a("cp-data").Set;b.exports=c},{"cp-data":19}],38:[function(a,b){function c(a,b){function c(c){var d=a.incidentNodes(c),e=d[0]!==f?d[0]:d[1],g=i.priority(e);if(void 0!==g){var j=b(c);g>j&&(h[e]=f,i.decrease(e,j))}}var f,g=new d,h={},i=new e;if(0===a.order())return g;a.eachNode(function(a){i.add(a,Number.POSITIVE_INFINITY),g.addNode(a)}),i.decrease(a.nodes()[0],0);for(var j=!1;i.size()>0;){if(f=i.removeMin(),f in h)g.addEdge(null,f,h[f]);else{if(j)throw new Error("Input graph is not connected: "+a);j=!0}a.incidentEdges(f).forEach(c)}return g}var d=a("../Graph"),e=a("cp-data").PriorityQueue;b.exports=c},{"../Graph":29,"cp-data":19}],39:[function(a,b){function c(a){function b(g){var h=e[g]={onStack:!0,lowlink:c,index:c++};if(d.push(g),a.successors(g).forEach(function(a){a in e?e[a].onStack&&(h.lowlink=Math.min(h.lowlink,e[a].index)):(b(a),h.lowlink=Math.min(h.lowlink,e[a].lowlink))}),h.lowlink===h.index){var i,j=[];do i=d.pop(),e[i].onStack=!1,j.push(i);while(g!==i);f.push(j)}}if(!a.isDirected())throw new Error("tarjan can only be applied to a directed graph. Bad input: "+a);var c=0,d=[],e={},f=[];return a.nodes().forEach(function(a){a in e||b(a)}),f}b.exports=c},{}],40:[function(a,b){function c(a){function b(g){if(g in e)throw new d;g in c||(e[g]=!0,c[g]=!0,a.predecessors(g).forEach(function(a){b(a)}),delete e[g],f.push(g))}if(!a.isDirected())throw new Error("topsort can only be applied to a directed graph. Bad input: "+a);var c={},e={},f=[],g=a.sinks();if(0!==a.order()&&0===g.length)throw new d;return a.sinks().forEach(function(a){b(a)}),f}function d(){}b.exports=c,c.CycleException=d,d.prototype.toString=function(){return"Graph has at least one cycle"}},{}],41:[function(a,b){function c(a){function b(){a.call(this),this._parents={},this._children={},this._children[null]=new d}return b.prototype=new a,b.prototype.constructor=b,b.prototype.parent=function(a,b){if(this._strictGetNode(a),arguments.length<2)return this._parents[a];if(a===b)throw new Error("Cannot make "+a+" a parent of itself");null!==b&&this._strictGetNode(b),this._children[this._parents[a]].remove(a),this._parents[a]=b,this._children[b].add(a)},b.prototype.children=function(a){return null!==a&&this._strictGetNode(a),this._children[a].keys()},b.prototype.addNode=function(b,c){return b=a.prototype.addNode.call(this,b,c),this._parents[b]=null,this._children[b]=new d,this._children[null].add(b),b},b.prototype.delNode=function(b){var c=this.parent(b);return this._children[b].keys().forEach(function(a){this.parent(a,c)},this),this._children[c].remove(b),delete this._parents[b],delete this._children[b],a.prototype.delNode.call(this,b)},b.prototype.copy=function(){var b=a.prototype.copy.call(this);return this.nodes().forEach(function(a){b.parent(a,this.parent(a))},this),b},b.prototype.filterNodes=function(b){function c(a){var b=d.parent(a);return null===b||e.hasNode(b)?(f[a]=b,b):b in f?f[b]:c(b)}var d=this,e=a.prototype.filterNodes.call(this,b),f={};return e.eachNode(function(a){e.parent(a,c(a))}),e},b}var d=a("cp-data").Set;b.exports=c},{"cp-data":19}],42:[function(a,b,c){function d(a){return Object.prototype.toString.call(a).slice(8,-1)}var e=a("../Graph"),f=a("../Digraph"),g=a("../CGraph"),h=a("../CDigraph");c.decode=function(a,b,c){if(c=c||f,"Array"!==d(a))throw new Error("nodes is not an Array");if("Array"!==d(b))throw new Error("edges is not an Array");if("string"==typeof c)switch(c){case"graph":c=e;break;case"digraph":c=f;break;case"cgraph":c=g;break;case"cdigraph":c=h;break;default:throw new Error("Unrecognized graph type: "+c)}var i=new c;return a.forEach(function(a){i.addNode(a.id,a.value)}),i.parent&&a.forEach(function(a){a.children&&a.children.forEach(function(b){i.parent(b,a.id)})}),b.forEach(function(a){i.addEdge(a.id,a.u,a.v,a.value)}),i},c.encode=function(a){var b=[],c=[];a.eachNode(function(c,d){var e={id:c,value:d};if(a.children){var f=a.children(c);f.length&&(e.children=f)}b.push(e)}),a.eachEdge(function(a,b,d,e){c.push({id:a,u:b,v:d,value:e})});var d;if(a instanceof h)d="cdigraph";else if(a instanceof g)d="cgraph";else if(a instanceof f)d="digraph";else{if(!(a instanceof e))throw new Error("Couldn't determine type of graph: "+a);d="graph"}return{nodes:b,edges:c,type:d}}},{"../CDigraph":26,"../CGraph":27,"../Digraph":28,"../Graph":29}],43:[function(a,b,c){var d=a("cp-data").Set;c.all=function(){return function(){return!0}},c.nodesFromList=function(a){var b=new d(a);return function(a){return b.has(a)}}},{"cp-data":19}],44:[function(a){var b=a("./Graph"),c=a("./Digraph");b.prototype.toDigraph=b.prototype.asDirected=function(){var a=new c;return this.eachNode(function(b,c){a.addNode(b,c)}),this.eachEdge(function(b,c,d,e){a.addEdge(null,c,d,e),a.addEdge(null,d,c,e)}),a},c.prototype.toGraph=c.prototype.asUndirected=function(){var a=new b;return this.eachNode(function(b,c){a.addNode(b,c)}),this.eachEdge(function(b,c,d,e){a.addEdge(b,c,d,e)}),a}},{"./Digraph":28,"./Graph":29}],45:[function(a,b,c){c.values=function(a){var b,c=Object.keys(a),d=c.length,e=new Array(d);for(b=0;d>b;++b)e[b]=a[c[b]];return e}},{}],46:[function(a,b){b.exports="0.7.4"},{}]},{},[1]),joint.layout.DirectedGraph={layout:function(a,b){b=b||{};var c=this._prepareData(a),d=dagre.layout();b.debugLevel&&d.debugLevel(b.debugLevel),b.rankDir&&d.rankDir(b.rankDir),b.rankSep&&d.rankSep(b.rankSep),b.edgeSep&&d.edgeSep(b.edgeSep),b.nodeSep&&d.nodeSep(b.nodeSep);var e=d.run(c);return e.eachNode(function(b,c){c.dummy||a.get("cells").get(b).set("position",{x:c.x-c.width/2,y:c.y-c.height/2})}),b.setLinkVertices&&e.eachEdge(function(b,c,d,e){var f=a.get("cells").get(b);f&&a.get("cells").get(b).set("vertices",e.points)}),{width:e.graph().width,height:e.graph().height}},_prepareData:function(a){var b=new dagre.Digraph;return _.each(a.getElements(),function(a){b.hasNode(a.id)||b.addNode(a.id,{width:a.get("size").width,height:a.get("size").height,rank:a.get("rank")})}),_.each(a.getLinks(),function(a){if(!b.hasEdge(a.id)){var c=a.get("source").id,d=a.get("target").id;b.addEdge(a.id,c,d,{minLen:a.get("minLen")||1})}}),b}};