/*
 * Project: irond
 * Package: src.de.fhhannover.inform.iron.mapserver.exceptions
 * File:    InvalidIdentifierException.java
 *
 * Copyright (C) 2010-2011 Fachhochschule Hannover
 * Ricklinger Stadtweg 118, 30459 Hannover, Germany 
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.fhhannover.inform.iron.mapserver.exceptions;

/**
 * Exception if a Identifier could not be constructed correctly.
 * 
 * This exception is thrown if a Identifier is constructed with
 * wrong parameters.
 * 
 * @author aw
 * 
 * @version 0.1
 * 
 * created: 26.11.09
 * changes:
 *  26.11.09 aw - Created first version of this class
 *  22.12.09 aw - Removed reason in favor for message from
 *  	the base class. Removed overwritten hashCode() function.
 *
 */
public class InvalidIdentifierException extends Exception {
	
	/**
	 * autogenerated
	 */
	private static final long serialVersionUID = -8920150477108790113L;

	public InvalidIdentifierException(String message) {
		super(message);
	}
}
