USE cmon;
#alter table cmon_mysql_counters add unique key (cid, var);

alter table alarm_hosts add exit_message char(8) DEFAULT 'N/A';
alter table alarm_hosts add cluster_state char(8) DEFAULT 'N/A';
alter table alarm_hosts add alarm_last_sent datetime;

alter table alarm_hosts add column nodeid integer default 0;
alter table alarm  add column hostid integer default 0;
-- alter table alarm_hosts drop key cid;
-- alter table alarm_hosts add unique key (`cid`,`hostid`,`alarm_name`,`component`);

alter table cluster_state add uptime bigint default 0;
alter table cluster_state add downtime bigint default 0;

alter table cluster_state add sla_starttime datetime DEFAULT NULL;
alter table cluster_state add sla_started integer DEFAULT '0';

alter table hosts add column cmon_version varchar(16);
alter table hosts add column cmon_status timestamp;

alter table disk_stats add column await double default 0 ;
alter table disk_stats add column svctm double default 0 ;
alter table disk_stats add column util double default 0 ;

alter table disk_stats_history add column await double default 0 ;
alter table disk_stats_history add column svctm double default 0 ;
alter table disk_stats_history  add column util double default 0 ;
alter table cluster change type type enum('mysqlcluster','replication','galera') default NULL;

alter table cmon_host_log add column hostid integer; 
create unique index ix_cidhostid  on  cmon_host_log(cid,hostid,filename);
alter table mysql_slow_queries change count cnt integer unsigned;

alter table mysql_repl_link add column hostid integer;
create index ix_cidhostid  on  mysql_repl_link(cid,hostid);
alter table mysql_slave_status modify Last_SQL_Error varchar(1024);
alter table mysql_slave_status modify Last_IO_Error varchar(1024);
alter table mysql_slave_status modify Last_Error varchar(1024);

alter table alarm change severity severity enum('WARNING','CRITICAL','INFO') DEFAULT 'WARNING';

alter table mysql_repl_link add column read_master_log_pos bigint default 0;
alter table mysql_repl_link add column exec_master_log_pos bigint default 0;
alter table mysql_repl_link add column curr_state integer default 0;

alter table mysql_repl_link change column io_state   io_state enum('REPL_IO_STARTED', 'REPL_IO_CONNECTING', 'REPL_IO_STOPPED', 'REPL_IO_NOT_DEF') DEFAULT 'REPL_IO_NOT_DEF';
alter table mysql_repl_link change column sql_state   sql_state enum('REPL_SQL_STARTED', 'REPL_SQL_STOPPED', 'REPL_SQL_NOT_DEF') DEFAULT 'REPL_SQL_NOT_DEF';

alter table mysql_explains change xfiltered xfiltered varchar(8) not null default '';
alter table mysql_explains change xkey_len xkey_len integer not null default 0;

alter table cluster_state add mc_lcp_status varchar(255) default '';
alter table cluster_state add mc_lcp_time timestamp;


drop table host_process_map;
drop table processes;

drop table if exists  cmon_uploads;
CREATE TABLE if not exists `cmon_uploads` (
  `cid` int(11),
  `packageid` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `cluster_type` varchar(64) NOT NULL,
  `version_tag` varchar(64) NOT NULL,
  `md5sum` varchar(1024) NOT NULL,
  `filesize` int(11) NOT NULL,
  `selected` int(11) DEFAULT 0,
  `report_ts` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`cid`,`packageid`, `filename`),
  KEY `ix_cluster_type` (`cid`, `cluster_type`, `packageid`),
  KEY `version_tag` (`version_tag`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE cpu_stats RENAME TO cpu_stats_history;

CREATE TABLE IF NOT EXISTS `cpu_stats` (
  `cid` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  `coreid` int(11) NOT NULL DEFAULT '65535',
  `loadavg1` float NOT NULL,
  `loadavg5` float NOT NULL,
  `loadavg15` float NOT NULL,
  `sys` float NOT NULL,
  `usr` float NOT NULL,
  `idle` float NOT NULL,
  `iowait` float NOT NULL,
  `uptime` float NOT NULL,
  `report_ts` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`cid`,`id`,`coreid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DELETE FROM alarms;
