
/*!
 * Stylus - Page
 * Copyright(c) 2010 LearnBoost <dev@learnboost.com>
 * MIT Licensed
 */

/**
 * Module dependencies.
 */

var Node = require('./node');

/**
 * Initialize a new `Page` with the given `selector` and `block`.
 *
 * @param {Selector} selector
 * @param {Block} block
 * @api public
 */

var Page = module.exports = function Page(selector, block){
  Node.call(this);
  this.selector = selector;
  this.block = block;
};

/**
 * Inherit from `Node.prototype`.
 */

Page.prototype.__proto__ = Node.prototype;

/**
 * Return `@page name`.
 *
 * @return {String}
 * @api public
 */

Page.prototype.toString = function(){
  return '@page ' + this.selector;
};
