linux:
  network:
    enabled: false
    hostname: linux
    fqdn: linux.ci.local
  system:
    enabled: true
    at:
      enabled: false
      user:
        root:
          enabled: true
        testuser:
          enabled: true
    cron:
      enabled: false
      user:
        root:
          enabled: false
    cluster: default
    name: linux
    domain: ci.local
    environment: prd
    purge_repos: true
    directory:
      /tmp/test:
        makedirs: true
    apparmor:
      enabled: false
    haveged:
      enabled: true
    prompt:
      default: "linux.ci.local$"
    package:
      htop:
        version: latest
    repo:
      disabled_repo:
        source: "deb [arch=amd64] https://download.docker.com/linux/ubuntu xenial stable"
        enabled: false
      disabled_repo_left_proxy:
        source: "deb [arch=amd64] https://download.docker.com/linux/ubuntu xenial stable"
        enabled: false
        proxy:
          enabled: true
          https: https://127.0.5.1:443
      saltstack:
        source: "deb [arch=amd64] http://mirror.mirantis.com/update/2019.2.0/saltstack-2017.7/xenial xenial main"
        key_url: "http://mirror.mirantis.com/update/2019.2.0/saltstack-2017.7/xenial/SALTSTACK-GPG-KEY.pub"
        architectures: amd64
        clean_file: true
        pinning:
          10:
            enabled: true
            pin: 'release o=SaltStack'
            priority: 50
            package: 'libsodium18'
          20:
            enabled: true
            pin: 'release o=SaltStack'
            priority: 1100
            package: '*'
      apt-salt-nightly:
        source: "deb http://mirror.mirantis.com/update/nightly/salt-2017.7.8/xenial xenial main"
        key_url: http://mirror.mirantis.com/update/nightly/salt-2017.7.8/xenial/archive-salt-2017.7.8.key
        architectures: amd64
        proxy:
          enabled: false
      apt-extra-nightly:
        source: "deb http://mirror.mirantis.com/update/nightly/extra/xenial xenial main"
        key_url: http://mirror.mirantis.com/update/nightly/extra/xenial/archive-extra.key
        architectures: amd64
      duo:
        key: |
          -----BEGIN PGP PUBLIC KEY BLOCK-----
          Version: GnuPG v2.0.22 (GNU/Linux)

          mQINBF68XyMBEACtnqumd2ocG1qM8BZToRr+BLbWDwa1XWWovuonKupP2Im7F9a6
          C71lSbD1QX0N0jvesMldrvLHnXFjOOKweNZlMSSzvB0TwSRgLugwaA/LI/g3R4IO
          AMg4pKKbjguJ9nTAlHj0xQ2aWYI5dep6uks5tB5SCoyaqDc0eGzkkytuwNKLjEhd
          GNFTH1cBIQsYYKdsfrNh9C3i4ps9jf3Gb3PtpTGdCvxIC1w66wxQO2w2yjD4wYdc
          VMi5Uy/q8OjxX58YwA5RHt91B75wp6oQa6rKlzyu64H8bffzVn6ukGTLfKepY9WF
          Hd106D/3lzO9jBXUj125ATIDFl3ObVG9JtiUVkmRl44Sgp4nLJWpejWWgDxGN6sd
          U3l3bltPYZH/yrlNGaJEshshBSEL8PFRSxx3i+NKdUZhe5yzcxKFT1ZTSPZiKc7m
          9hr9BP0+54HzhgZScUsehQXvNe9TwOZccGmyn0Hix3zXBW1LsswFr396RUfKo8IO
          82hgaOnlYko8Y/dwPZcc3CEYiEwwQ13PagdO5c/YufZpWB4cq1r95tAzE3QHTOoQ
          lFQ3yr3HV30LAn//PL2QWePB5nt7qFZwt1RrmUly3a9OA5fyhsyXg22SA7CwZaCI
          gQc3HAYFNwPXCqiUlPdLbIb6OMSPI2Vd4U4IDb7bR726hWKYCIOcJQLm3QARAQAB
          tDJEdW8gU2VjdXJpdHkgUGFja2FnZSBTaWduaW5nIDxkZXZAZHVvc2VjdXJpdHku
          Y29tPokCPwQTAQIAKQUCXrxfIwIbAwUJEswDAAcLCQgHAwIBBhUIAgkKCwQWAgMB
          Ah4BAheAAAoJEHpFCGTBoHqF0qAP/RmAz9B2RydA3DAdLuqBIcswOi6gLAH/mzDh
          bisq4VXxLyIk1OfLVIdehvVKX3KINC54Pu9BltQpka8n0sBWPBXp5rp+EEB4epf4
          kp5OlJqm2CNZq5lBFlGXNtoC33o+cOachmWKnoqrc5iuOKyQCqpgpP3TxcyDQlyJ
          g18mrv0oN2LQjvTYZoYGQCEwe9iOYEnk+Dn5DNGtTuNTv5b2s1+TEGLuxlZeeHZz
          pItFEKTqYG2BA+dje2H4/eweuYDxKRJ4Y6NgsLMJRwvopfTNgIg4VV5DJ//jqabc
          0HWJ+x95d09ecBZBk+gKiGfU+r5zaVoVKBlHN4q1S3P/cXitaMEKqb9UdicCsB5u
          pA+Lu9KW5qKyElk3LdsMA5LFErlFRBNup3icuDZ9YP8582T0SXyGpALS2X6symdi
          3EZ587sCfEtI3cOZ/WQ7im05f/xu5x0RaZTUegOn6byFjyuKxIkQcAmtY2NvKpMI
          7cY1YOuYHGodiV/YQkaoZDFnbxMwI0JeboF9zuYMVqwC0tDvU92+NNaqcdJycwYQ
          s5byXHB0TycUmIYxcRcuRYXeFa7T94fXY8IwsK6TWMEE04phsbujKzZ8IXxZ/5p4
          j6dmGJf5OG0WC0KYZBAV5RuSWrGoVv1AS7WO511VP9gkUVZ9Ua9M62TdZ4FVqz7s
          NBJXY7eBuQINBF68XyMBEACWjR4yUiDiQy/MTABjeI9PU80HUipGYe/CM0FXNhO6
          D7M9150UgYICGFEyHXI4puVGV05WhG+/Be7UNcxO4OQpagz3b+a/OrTShEAev7Ck
          /Sxw7qhGIpDt8A4duwNscPsLWnAcKetGOxw8YieR2NE11gYdp0xhPao1MUs2tTKM
          nWqd/mr1KzAaPjx8FcKbUc1kQf0LHmxwzpZfh4+xWeNQ9GjLyXFvPvGl/YTjJz3k
          SygADIqHcPgWnO5t9vEFuVCAFd6oIYcnhJOYjxh5Rv0XWAA0do4gxOT0HfKrOeYM
          hpCFkJ1HgcqmO29yWJq6y0psEdyUBThhX+JEhRa3WMu1NkwV8g1MucPV7DYuPDPw
          43sGABU7KLhng4Lqw2r/2hwYsPNCdBZ9HBEfsnhXi0fL24jT8VBULCLt+OdRuQsx
          xBz2JIhul1FqmjPJLMMmfv6anMNXr8qAOCED74lE/8GKee+/r3TbWanrMMnWvwau
          2L7KxUAPcPM/Y8iSMFRlTmMN9ZuTomiZTIT+kkTea2lW6JG9r6kBeRglcqy9Hg+g
          ooab9QR7hftSQ2WWc4Ru5/ki2+PbDHm7Mw90sMBH43/JVPNowG51WvzK2ACJUA7G
          ET7cfxi2QLmtgnKk3F04+QRHvV9dV8o88sPZxp7GpparojEAmhBxXcZdz5wkc8bu
          RQARAQABiQIkBBgBAgAPBQJevF8jAhsMBQkSzAMAAAoJEHpFCGTBoHqFsvIP9Rzo
          nSPena6p1GVkUvfO3N71atjnqgjajKjNaD1XmLTaXXb12p1pB+0Y7fgKZY6JUWbD
          BHHAUTadwl2t43I1hRycj9APPpYjJtFZQqdxMKJsE61q7LMgMDfgKVb/XDg7ApKz
          jwdHEbvSnmyK//5aedv60wFP0mJJnIvchcwyRM+azn2BoHtEIYvicPSOiKA0aG/U
          6RT5UkKbqfviyEdkke6JA8795LeagJ4tQlbUT66HskADRD9MFQgRXFYk6fgby77Q
          a/ni4UZLPkplcPvxKviC23pcx4JyJoskNVvt9ZgAVxZqY3ntdhcYE0U+xx2ENfXV
          T5eoOwnbu6+lL4oq/ev1m7VAYQCPWLCrjWi++ZZoxpu4IgLrJICuEFkvtRxRZYsg
          9dQ8RcuOC8HguLrblEl7DeO81D+bTQz3eT/+In2vjk40XXW0ReA6LZiaHfQYValj
          3ntKqlYqgtNEYdXFsxhP1xvsG9DSRiCrTkccaE2BZs9V9MnVP/RVxHdaGRupuc90
          gHsnKT25loh6PuJBw7SPZxitXqAmbeDl49GpfuAodxBihuemz5KT16VIoQy1OpHX
          ZLkCAcK8FH6+FUT8y1E/gzs4Kc+lN473B8OJs2XU5XwN56PcVPQuFJK4k7v4jySy
          MXBqsE6g78e0L2b31PujvG2DyNa0myrqfmNFKBk=
          =SZIy
          -----END PGP PUBLIC KEY BLOCK-----
        source: "deb [arch=amd64] http://pkg.duosecurity.com/Ubuntu xenial main"
        architectures: amd64
    locale:
      en_US:
        enabled: true
        default: true
      cs_CZ:
        enabled: true
    autoupdates:
      enabled: true
    sudo:
      enabled: false
    env:
      BOB_VARIABLE: Alice
      LANG: C
      LC_ALL: C
    login_defs:
      PASS_MAX_DAYS:
        value: 99
    shell:
      umask: '027'
      timeout: 900
    profile:
      vi_flavors.sh: |
        export PAGER=view
        alias vi=vim
      locales: |
        export LANG=en_US
        export LC_ALL=en_US.UTF-8
    auth:
      enabled: true
      duo:
        enabled: true
        duo_host: localhost
        duo_ikey: DUO-INTEGRATION-KEY
        duo_skey: DUO-SECRET-KEY
    ssd_scheduler:
      enabled: false
      name: cfq
