linux:
  network:
    enabled: true
    hostname: linux
    fqdn: linux.ci.local
  system:
    enabled: true
    banner:
      enabled: true
      contents: |
        ================= WARNING =================
        This is tcpcloud network.
        Unauthorized access is strictly prohibited.
        ===========================================
    file:
      /tmp/sample.txt:
        source: http://techslides.com/demos/samples/sample.txt
        source_hash: 5452459724e85b4e12277d5f8aab8fc9
      sample2.txt:
        name: /tmp/sample2.txt
        source: http://techslides.com/demos/samples/sample.txt
      sample3.tar.gz:
        name: /tmp/sample3.tar.gz
        secured_source:
          protocol: http #optional
          user: username
          password: password
          url: wordpress.org/latest.tar.gz
        secured_hash: #optional
          url: wordpress.org/latest.tar.gz.md5
      test2:
        name: /tmp/test2.txt
        contents: |
          line1
          line2
        user: root
        group: root
        mode: 700
        dir_mode: 700
        encoding: utf-8
        makedirs: true
      test3:
        name: /tmp/test3.txt
        source: salt://linux/files/test/file_template.jinja
        template: jinja
      test4:
        decode: True
        name: /tmp/test4.txt
        encoded_data: dGVzdDQK
    apt:
      preferences:
        enabled: true
        rules:
          100:
            enabled: true
            name: 'Ubuntu origin'
            pin: 'release o=Ubuntu'
            priority: 1100
            package: '*'
          5:
            enabled: true
            name: 'Ubuntu origin'
            pin: 'release o=Ubuntu'
            priority: 1100
            package: '*'
    at:
      enabled: true
      user:
        root:
          enabled: true
        testuser:
          enabled: true
    cron:
      enabled: true
      user:
        root:
          enabled: true
        testuser:
          enabled: true
    cluster: default
    name: linux
    domain: ci.local
    environment: prd
    purge_repos: true
    service:
      apt-daily.timer:
        status: dead
      tgt:
        name: tgt
        status: running
        enabled: True
        override:
          50:
            target: tgt.service.d
            content: |
              [Service]
              ExecStart=
              ExecStart=/usr/sbin/tgtd -f --iscsi portal=127.0.0.1:5555
    directory:
      /tmp/test:
        makedirs: true
    apparmor:
      enabled: false
    haveged:
      enabled: true
    prompt:
      default: "linux.ci.local$"
    kernel:
      isolcpu: 1,2,3,4
      elevator: deadline
      boot_options:
        - pti=off
        - spectre_v2=auto
      module:
        module_1:
          install:
            command: /bin/true
          remove:
            enabled: false
            command: /bin/false
        module_2:
          install:
            enabled: false
            command: /bin/false
          remove:
            command: /bin/true
        module_3:
          blacklist: true
        module_4:
          blacklist: false
          alias:
            "module*":
              enabled: true
            "module_*":
              enabled: false
        module_5:
          softdep:
            pre:
              1:
                value: module_1
              2:
                value: module_2
                enabled: false
            post:
              1:
                value: module_3
              2:
                value: module_4
                enabled: false
        module_6:
          option:
            opt_1: 111
            opt_2: 222
        module_7:
          option:
            opt_3:
              value: 333
            opt_4:
              enabled: true
              value: 444
            opt_5:
              enabled: false
    cgroup:
      group:
        group_1:
          controller:
            cpu:
              shares:
                value: 250
          mapping:
            subjects:
            - '@group1'
    sysfs:
      enable_apply: true
      scheduler:
        block/sda/queue/scheduler: deadline
      power:
        mode:
          power/state: 0660
        owner:
          power/state: "root:power"
        devices/system/cpu/cpu0/cpufreq/scaling_governor: powersave
    motd:
      - warning: |
          #!/bin/sh
          printf "WARNING: This is tcpcloud network.\n"
          printf "  Unauthorized access is strictly prohibited.\n"
          printf "\n"
      - info: |
          #!/bin/sh
          printf -- "--[tcp cloud]---------------------------\n"
          printf " Hostname  |  ${linux:system:name}\n"
          printf " Domain    |  ${linux:system:domain}\n"
          printf " System    |  %s\n" "$(lsb_release -s -d)"
          printf " Kernel    |  %s\n" "$(uname -r)"
          printf -- "----------------------------------------\n"
          printf "\n"
    user:
      root:
        enabled: true
        home: /root
        name: root
        maxdays: 365
      testuser:
        enabled: true
        name: testuser
        password: passw0rd
        sudo: true
        uid: 9999
        full_name: Test User
        home: /home/test
        unique: false
        groups:
          - db-ops
          - salt-ops
        optional_groups:
        - docker
      salt_user1:
        enabled: true
        name: saltuser1
        sudo: false
        uid: 9991
        full_name: Salt User1
        home: /home/saltuser1
        home_dir_mode: 755
      salt_user2:
        enabled: true
        name: saltuser2
        sudo: false
        uid: 9992
        full_name: Salt Sudo User2
        home: /home/saltuser2
        groups:
          - sudogroup1
      example:
        enabled: false
        name: example
        sudo: false
        full_name: disabled
        home: /home/example
        email: disabled
        force_delete: True
    group:
      testgroup:
        enabled: true
        name: testgroup
        gid: 9999
        system: true
        addusers:
          - salt_user1
          - salt_user2
      db-ops:
        enabled: true
        delusers:
          - salt_user1
          - dontexistatall
      salt-ops:
        enabled: true
        name: salt-ops
      sudogroup1:
        enabled: true
        name: sudogroup1
      sudogroup2:
        enabled: true
        name: sudogroup2
      sudogroup3:
        enabled: false
        name: sudogroup3
    job:
      test:
        enabled: true
        command: "/bin/sleep 3"
        user: testuser
        minute: 0
        hour: 13
    package:
      htop:
        version: latest
    repo:
      disabled_repo:
        source: "deb [arch=amd64] https://download.docker.com/linux/ubuntu xenial stable"
        enabled: false
      disabled_repo_left_proxy:
        source: "deb [arch=amd64] https://download.docker.com/linux/ubuntu xenial stable"
        enabled: false
        proxy:
          enabled: true
          https: https://127.0.5.1:443
      saltstack:
        source: "deb [arch=amd64] http://mirror.mirantis.com/update/2019.2.0/saltstack-2017.7/xenial xenial main"
        key_url: "http://mirror.mirantis.com/update/2019.2.0/saltstack-2017.7/xenial/SALTSTACK-GPG-KEY.pub"
        name: 'human readable saltstack reponame'
        architectures: amd64
        clean_file: true
        pinning:
          10:
            enabled: true
            pin: 'release o=SaltStack'
            priority: 50
            package: 'libsodium18'
          20:
            enabled: true
            pin: 'release o=SaltStack'
            priority: 1100
            package: '*'
      opencontrail:
        source: "deb http://ppa.launchpad.net/tcpcloud/contrail-3.0/ubuntu xenial main"
        keyid: E79EE90C
        keyserver: keyserver.ubuntu.com
        architectures: amd64
        proxy:
          enabled: true
          https: https://127.0.5.1:443
          #http: http://127.0.5.2:8080
      apt-salt-nightly:
        source: "deb http://mirror.mirantis.com/update/nightly/salt-2017.7.8/xenial xenial main"
        key_url: http://mirror.mirantis.com/update/nightly/salt-2017.7.8/xenial/archive-salt-2017.7.8.key
        architectures: amd64
        proxy:
          enabled: false
      apt-extra-nightly:
        source: "deb http://mirror.mirantis.com/update/nightly/extra/xenial xenial main"
        key_url: http://mirror.mirantis.com/update/nightly/extra/xenial/archive-extra.key
        architectures: amd64
    locale:
      en_US:
        enabled: true
        default: true
      cs_CZ:
        enabled: true
    autoupdates:
      enabled: true
    sudo:
      enabled: true
      alias:
        runas:
          DBA:
          - postgres
          - mysql
          SALT:
          - root
        host:
          LOCAL:
          - localhost
          PRODUCTION:
          - db1
          - db2
        command:
          SUDO_RESTRICTED_SU:
          - /bin/vi /etc/sudoers
          - /bin/su - root
          - /bin/su -
          - /bin/su
          - /usr/sbin/visudo
          SUDO_SHELLS:
          - /bin/sh
          - /bin/ksh
          - /bin/bash
          - /bin/rbash
          - /bin/dash
          - /bin/zsh
          - /bin/csh
          - /bin/fish
          - /bin/tcsh
          - /usr/bin/login
          - /usr/bin/su
          - /usr/su
          SUDO_SALT_SAFE:
          - /usr/bin/salt state*
          - /usr/bin/salt service*
          - /usr/bin/salt pillar*
          - /usr/bin/salt grains*
          - /usr/bin/salt saltutil*
          - /usr/bin/salt-call state*
          - /usr/bin/salt-call service*
          - /usr/bin/salt-call pillar*
          - /usr/bin/salt-call grains*
          - /usr/bin/salt-call saltutil*
          SUDO_SALT_TRUSTED:
          - /usr/bin/salt*
      users:
        saltuser1: {}
        saltuser2:
          hosts:
          - LOCAL
        # User Alias:
        DBA:
          hosts:
          - ALL
          commands:
          - SUDO_SALT_SAFE
      groups:
        db-ops:
          hosts:
          - ALL
          - '!PRODUCTION'
          runas:
          - DBA
          commands:
          - /bin/cat *
          - /bin/less *
          - /bin/ls *
          - SUDO_SALT_SAFE
          - '!SUDO_SHELLS'
          - '!SUDO_RESTRICTED_SU'
        salt-ops:
          hosts:
          - 'ALL'
          runas:
          - SALT
          commands:
          - SUDO_SALT_TRUSTED
        salt-ops2:
          name: salt-ops
          runas:
          - DBA
          commands:
          - SUDO_SHELLS
        sudogroup1:
          commands:
            - ALL
        sudogroup2:
          commands:
            - ALL
          hosts:
            - localhost
          users:
            - test
          nopasswd: false
        sudogroup3:
          commands:
            - ALL
    env:
      BOB_VARIABLE: Alice
      BOB_PATH:
        - /srv/alice/bin
        - /srv/bob/bin
      HTTPS_PROXY: https://127.0.4.1:443
      http_proxy: http://127.0.4.2:80
      ftp_proxy: ftp://127.0.4.3:2121
      no_proxy:
        - 192.168.0.1
        - 192.168.0.2
        - .saltstack.com
        - .ubuntu.com
        - .mirantis.com
        - .launchpad.net
        - .dummy.net
        - .local
      LANG: C
      LC_ALL: C
    login_defs:
      PASS_MAX_DAYS:
        value: 99
    shell:
      umask: '027'
      timeout: 900
    profile:
      vi_flavors.sh: |
        export PAGER=view
        alias vi=vim
      locales: |
        export LANG=en_US
        export LC_ALL=en_US.UTF-8

    # pillar for proxy configuration
    proxy:
      # for package managers
      pkg:
        enabled: true
        https: https://127.0.2.1:4443
        #http: http://127.0.2.2
        ftp: none
      # fallback, system defaults
      https: https://127.0.1.1:443
      #http: http://127.0.1.2
      ftp: ftp://127.0.1.3
      noproxy:
        - host1
        - host2
        - .local

    # pillars for netconsole setup
    netconsole:
      enabled: true
      port: 514
      loglevel: debug
      target:
        192.168.0.1:
          mac: "ff:ff:ff:ff:ff:ff"
          interface: bond0
    atop:
      enabled: true
      interval: 20
      logpath: "/var/mylog/atop"
      outfile: "/var/mylog/atop/daily.log"
    mcelog:
      enabled: true
      logging:
        syslog: true
        syslog_error: true
    ssd_scheduler:
      enabled: false
      name: cfq
