keystone:
# Server state
  server:
    enabled: true
    version: liberty
    service_name: apache2
    service_token: RANDOMSTRINGTOKEN
    service_tenant: service
    admin_project:
      name: projectname
      domain: project
    admin_tenant: admin
    admin_name: admin
    admin_password: passw0rd
    admin_email: root@localhost
    enable_proxy_headers_parsing: True
    cors:
      allowed_origin: 'https://horizon.example.com'
      allow_credentials: True
      expose_headers: 'X-Auth-Token,X-Openstack-Request-Id,X-Subject-Token'
      allow_headers: 'X-Auth-Token,X-Openstack-Request-Id,X-Subject-Token,X-Project-Id,X-Project-Name,X-Project-Domain-Id,X-Project-Domain-Name,X-Domain-Id,X-Domain-Name'
      max_age: 3600
      allow_methods: 'GET,PUT,POST,DELETE,PATCH'
    auth_methods:
    - password
    - token
    federation:
      oidc:
        remote_id_attribute: HTTP_OIDC_ISS
        remote_id_attribute_value: remote_id_attribute_value
        oidc_claim_prefix: oidc_claim_prefix
        oidc_client_id: oidc_client_id
        oidc_client_secret: oidc_client_secret
        oidc_crypto_passphrase: oidc_crypto_passphrase
        oidc_redirect_uri: oidc_redirect_uri
        oidc_provider_metadata_url: oidc_provider_metadata_url
        oidc_response_type: oidc_response_type
        oidc_scope: oidc_scope
        oidc_ssl_validate_server: oidc_ssl_validate_server
        oidc_oauth_ssl_validate_server: oidc_oauth_ssl_validate_server
        oidc_oauth_introspection_endpoint: oidc_oauth_introspection_endpoint
        oidc_oauth_introspection_token_param_name: oidc_oauth_introspection_token_param_name
        oidc_oauth_remote_user_claim: oidc_oauth_remote_user_claim
        oidc_oauth_verify_jwks_uri: oidc_oauth_verify_jwks_uri
        odic_token_iat_slack: odic_token_iat_slack
        oidc_provider_issuer: oidc_provider_issuer
        oidc_provider_authorization_endpoint: oidc_provider_authorization_endpoint
        oidc_provider_token_endpoint: oidc_provider_token_endpoint
        oidc_provider_token_endpoint_auth: oidc_provider_token_endpoint_auth
        oidc_provider_user_info_endpoint: oidc_provider_user_info_endpoint
        oidc_provider_jwks_uri: oidc_provider_jwks_uri
        protocol: oidc
      saml2:
        remote_id_attribute: HTTP_OIDC_ISS
        protocol: saml2
    bind:
      address: 0.0.0.0
      private_address: 127.0.0.1
      private_port: 35357
      public_address: 127.0.0.1
      public_port: 5000
    region: RegionOne
    database:
      engine: mysql
      host: 127.0.0.1
      name: keystone
      password: passw0rd
      user: keystone
    tokens:
      engine: fernet
      expiration: 86400
      location: /etc/keystone/fernet-keys/
      allow_expired_window: 86400
    notification: true
    notification_format: cadf
    security_compliance:
      disable_user_account_days_inactive: 90
      lockout_failure_attempts: 60
      lockout_duration: 600
      password_expires_days: 730
      unique_last_password_count: 5
      minimum_password_age: 0
      password_regex: '^[a-zA-Z0-9]{32,}$$'
      password_regex_description: |
        Your password could contains capital letters, lowercase letters, digits and have a minimum length of 32 characters
      change_password_upon_first_use: False
    logging:
      debug: true
      log_file: 'logfile.log'
      log_dir: logdir
      use_syslog: true
      syslog_log_facility: LOG_USER
      log_appender: true
      log_handlers:
        watchedfile:
          enabled: true
        fluentd:
          enabled: false
        ossyslog:
          enabled: false
    extra_config:
      federation:
        cache_group_membership_in_db: true
    message_queue:
      engine: rabbitmq
      host: 127.0.0.1
      port: 5672
      user: openstack
      password: password
      virtual_host: '/openstack'
      ha_queues: true
      rabbit_ha_queues: true
      rpc_conn_pool_size: 30
      conn_pool_min_size: 2
      conn_pool_ttl: 1200
      rpc_poll_timeout: 1
      rpc_thread_pool_size: 100
      rpc_message_ttl: 300
      rpc_use_acks: false
      rpc_ack_timeout_base: 15
      rpc_ack_timeout_multiplier: 2
      rpc_retry_attempts: 3
      executor_thread_pool_size: 64
      rpc_response_timeout: 60
      control_exchange: openstack
      ssl:
        version: TLSv1_2
        cacert_file: ssl_ca_certs
      x509:
        key_file: kombu_ssl_keyfile
        cert_file: kombu_ssl_certfile
      rabbit_retry_interval: 1
      rabbit_retry_backoff: 2
      rabbit_interval_max: 30
      rabbit_transient_queues_ttl: 1800
      heartbeat_timeout_threshold: 60
      heartbeat_rate: 2
      channel_max: 2
      frame_max: 2
      heartbeat_interval: 3
      socket_timeout: 10
      tcp_user_timeout: 10
      host_connection_reconnect_delay: 10
      connection_factory: single
      pool_max_size: 30
      pool_max_overflow: 0
      pool_timeout: 30
      pool_recycle: 600
      pool_stale: 60
      default_serializer_type: json
      notification_persistence: false
      default_notification_exchange: exchange
      notification_listener_prefetch_count: 100
      default_notification_retry_attempts: 1
      notification_retry_delay: 10
      rpc_queue_expiration: 60
      default_rpc_exchange: rpc_exchange
      rpc_reply_exchange: rpc_reply_exchange
      rpc_listener_prefetch_count: 100
      rpc_reply_listener_prefetch_count: 100
      rpc_reply_retry_attempts: 10
      rpc_reply_retry_delay: 10
      default_rpc_retry_attempts: 10
      rpc_retry_delay: 10
      rabbit_qos_prefetch_count: 64
    healthcheck:
      path: '/healthcheck'
    max_request_body_size: 114688
    profiler:
      enabled: True
    cache:
      enabled: True
      host: 127.0.0.1
      port: 11211
    policy:
      policy_file: 'policy.json'
    domain:
      testing:
        description: "Test domain"
        backend: ldap
        identity:
          backend: ldap
          driver: ldap
        assignment:
          backend: sql
          driver: keystone.assignment.backends.sql.Assignment
        ldap:
          group_mapping: False
          url: "ldaps://idm.domain.com"
          suffix: "dc=cloud,dc=domain,dc=com"
          uid: keystone
          password: password
          query_scope: "sub"
          bind_user: "CN=lab,CN=users,${keystone:server:domain:testing:ldap:suffix}"
          filter:
            user: "(memberOf=CN=Grp-atm-admins,CN=Users,${keystone:server:domain:testing:ldap:suffix})"
          user_tree_dn: "CN=users,${keystone:server:domain:testing:ldap:suffix}"
          user_id_attribute: "sAMAccountName"
          user_name_attribute: "sAMAccountName"
          user_pass_attribute: ""
          user_enabled_default: 512
          user_enabled_mask: 2
          user_enabled_attribute: "userAccountControl"
          user_attribute_ignore: "password,tenant_id,tenants"

# Client state
  client:
    enabled: false
    os_client_config:
      enabled: true
      cfgs:
        root:
          content:
            clouds:
              admin_identity:
                region_name: RegionOne
                identity_api_version: '3'
                interface: 'internal'
                auth:
                  username: 'admin'
                  password: passw0rd
                  user_domain_name: 'Default'
                  project_name: 'admin'
                  project_domain_name: 'Default'
                  auth_url: 'http://127.0.0.1:5000'
    server:
      admin_identity:
        admin:
          user: admin
          password: passw0rd
          project: admin
          host: localhost
          port: 5000
          region_name: RegionOne
          use_keystoneauth: true
          protocol: http
      identity:
        admin:
          host: localhost
          port: 35357
          token: RANDOMSTRINGTOKEN
        roles:
        - admin
        - Member
        project:
          service:
            description: "OpenStack Service tenant"
          admin:
            description: "OpenStack Admin tenant"
            user:
              admin:
                is_admin: true
                password: passw0rd
                email: admin@localhost
        service:
          keystone3:
            type: identity
            description: OpenStack Identity Service v3
            endpoints:
            - region: RegionOne
              public_address: keystone
              public_protocol: http
              public_port: 5000
              public_path: '/v3'
              internal_address: keystone
              internal_port: 5000
              internal_path: '/v3'
              admin_address: keystone
              admin_port: 35357
              admin_path: '/v3'
          keystone:
            type: identity
            description: OpenStack Identity Service
            endpoints:
            - region: RegionOne
              public_address: keystone
              public_protocol: http
              public_port: 5000
              public_path: '/v2.0'
              internal_address: keystone
              internal_port: 5000
              internal_path: '/v2.0'
              admin_address: keystone
              admin_port: 35357
              admin_path: '/v2.0'
apache:
  server:
    enabled: true
    default_mpm: event
    mpm:
      prefork:
        enabled: true
        servers:
          start: 5
          spare:
            min: 2
            max: 10
        max_requests: 0
        max_clients: 20
        limit: 20
    site:
      keystone:
        enabled: true
        type: keystone
        name: wsgi
        host:
          name: localhost
    pkgs:
      - apache2
    modules:
      - wsgi
# CI related dependencies
mysql:
  client:
    enabled: true
    version: '5.7'
    admin:
      host: localhost
      port: 3306
      user: admin
      password: password
      encoding: utf8
  server:
    enabled: true
    version: "5.7"
    force_encoding: utf8
    bind:
      address: 0.0.0.0
      port: 3306
      protocol: tcp
    database:
      keystone:
        encoding: utf8
        users:
        - host: '%'
          name: keystone
          password: passw0rd
          rights: all
        - host: 127.0.0.1
          name: keystone
          password: passw0rd
          rights: all
