ssl_enabled = attribute('ssl', default: false)

keystone_default_ssl = {
  'conn_pool_min_size'           => '2',
  'conn_pool_ttl'                => '1200',
  'control_exchange'             => 'openstack',
  'debug'                        => 'True',
  'executor_thread_pool_size'    => '64',
  'log_config_append'            => '/etc/keystone/logging.conf',
  'log_dir'                      => 'logdir',
  'log_file'                     => 'logfile.log',
  'notification_format'          => 'cadf',
  'rpc_ack_timeout_base'         => '15',
  'rpc_ack_timeout_multiplier'   => '2',
  'rpc_conn_pool_size'           => '30',
  'rpc_message_ttl'              => '300',
  'rpc_poll_timeout'             => '1',
  'rpc_response_timeout'         => '60',
  'rpc_retry_attempts'           => '3',
  'rpc_thread_pool_size'         => '100',
  'rpc_use_acks'                 => 'False',
  'syslog_log_facility'          => 'LOG_USER',
  'transport_url'                => 'rabbit://openstack:password@127.0.0.1:5671//openstack',
  'use_syslog'                   => 'True',
}

keystone_default = {
  'conn_pool_min_size'           => '2',
  'conn_pool_ttl'                => '1200',
  'control_exchange'             => 'openstack',
  'debug'                        => 'True',
  'executor_thread_pool_size'    => '64',
  'log_config_append'            => '/etc/keystone/logging.conf',
  'log_dir'                      => 'logdir',
  'log_file'                     => 'logfile.log',
  'notification_format'          => 'cadf',
  'rpc_ack_timeout_base'         => '15',
  'rpc_ack_timeout_multiplier'   => '2',
  'rpc_conn_pool_size'           => '30',
  'rpc_message_ttl'              => '300',
  'rpc_poll_timeout'             => '1',
  'rpc_response_timeout'         => '60',
  'rpc_retry_attempts'           => '3',
  'rpc_thread_pool_size'         => '100',
  'rpc_use_acks'                 => 'False',
  'syslog_log_facility'          => 'LOG_USER',
  'transport_url'                => 'rabbit://openstack:password@127.0.0.1:5672//openstack',
  'use_syslog'                   => 'True',
}

keystone_assignment = {
  'driver' => 'sql'
}

keystone_auth = {
  'methods' => 'password,token',
  'oidc'    => 'keystone.auth.plugins.mapped.Mapped',
  'saml2'   => 'keystone.auth.plugins.mapped.Mapped',
}

keystone_catalog = {
  'template_file' => 'default_catalog.templates',
  'driver'        => 'sql',
}

keystone_credential = {
  'key_repository' => '/var/lib/keystone/credential-keys'
}

keystone_fernet_tokens = {
  'key_repository'  => '/etc/keystone/fernet-keys/',
  'max_active_keys' => '3',
}

keystone_identity = {
  'driver'                          => 'sql',
}

keystone_token = {
  'expiration'     => '86400',
  'provider'       => 'fernet',
  'caching'        => 'false',
  'hash_algorithm' => 'sha256',
}

keystone_cache = {
  'backend'                      => 'oslo_cache.memcache_pool',
  'enabled'                      => 'True',
}

keystone_oslo_messaging_rabbit = {
  'heartbeat_rate'                       => '2',
}

keystone_oslo_messaging_rabbit_ssl = {
  'channel_max'                          => '2',
  'connection_factory'                   => 'single',
  'default_notification_exchange'        => 'exchange',
  'default_notification_retry_attempts'  => '1',
  'default_rpc_exchange'                 => 'rpc_exchange',
  'default_rpc_retry_attempts'           => '10',
  'default_serializer_type'              => 'json',
  'frame_max'                            => '2',
  'heartbeat_interval'                   => '3',
  'heartbeat_rate'                       => '2',
  'heartbeat_timeout_threshold'          => '60',
  'host_connection_reconnect_delay'      => '10',
  'notification_listener_prefetch_count' => '100',
  'notification_persistence'             => 'False',
  'notification_retry_delay'             => '10',
  'pool_max_overflow'                    => '0',
  'pool_max_size'                        => '30',
  'pool_recycle'                         => '600',
  'pool_stale'                           => '60',
  'pool_timeout'                         => '30',
  'rabbit_ha_queues'                     => 'True',
  'rabbit_interval_max'                  => '30',
  'rabbit_qos_prefetch_count'            => '64',
  'rabbit_retry_backoff'                 => '2',
  'rabbit_retry_interval'                => '1',
  'rabbit_transient_queues_ttl'          => '1800',
  'rpc_listener_prefetch_count'          => '100',
  'rpc_queue_expiration'                 => '60',
  'rpc_reply_exchange'                   => 'rpc_reply_exchange',
  'rpc_reply_listener_prefetch_count'    => '100',
  'rpc_reply_retry_attempts'             => '10',
  'rpc_reply_retry_delay'                => '10',
  'rpc_retry_delay'                      => '10',
  'socket_timeout'                       => '10',
  'ssl'                                  => 'true',
  'ssl_ca_file'                          => '/etc/keystone/ssl/mysql/ca-cert.pem',
  'ssl_version'                          => 'TLSv1_2',
  'tcp_user_timeout'                     => '10',
}

keystone_database = {
  'connection'              => 'mysql+pymysql://keystone:passw0rd@127.0.0.1/keystone?charset=utf8',
  'max_overflow'            => '30',
  'max_pool_size'           => '10',
  'max_retries'             => '-1',
}

keystone_database_ssl = {
  'connection'              => 'mysql+pymysql://keystone:passw0rd@127.0.0.1/keystone?charset=utf8&ssl_ca=/etc/keystone/ssl/mysql/ca-cert.pem&ssl_cert=/etc/keystone/ssl/mysql/client-cert.pem&ssl_key=/etc/keystone/ssl/mysql/client-key.pem',
  'max_overflow'            => '30',
  'max_pool_size'           => '10',
  'max_retries'             => '-1',
  'connection_recycle_time' => '280',
}

keystone_oslo_middleware = {
  'max_request_body_size'        => '114688',
  'enable_proxy_headers_parsing' => 'True',
}

keystone_cors = {
  'allowed_origin'    => 'https://horizon.example.com',
  'allow_credentials' => 'True',
  'expose_headers'    => 'X-Auth-Token,X-Openstack-Request-Id,X-Subject-Token',
  'max_age'           => '3600',
  'allow_methods'     => 'GET,PUT,POST,DELETE,PATCH',
  'allow_headers'     => 'X-Auth-Token,X-Openstack-Request-Id,X-Subject-Token,X-Project-Id,X-Project-Name,X-Project-Domain-Id,X-Project-Domain-Name,X-Domain-Id,X-Domain-Name',
}

keystone_oidc = {
  'remote_id_attribute' => 'HTTP_OIDC_ISS'
}

keystone_saml2 = {
  'remote_id_attribute' => 'HTTP_OIDC_ISS'
}

keystone_security_compliance = {
  'disable_user_account_days_inactive' => '90',
  'lockout_failure_attempts'           => '60',
  'lockout_duration'                   => '600',
  'password_expires_days'              => '730',
  'unique_last_password_count'         => '5',
  'minimum_password_age'               => '0',
  'password_regex'                     => '^[a-zA-Z0-9]{32,}$$',
  'password_regex_description'         => 'Your password could contains capital letters, lowercase letters, digits and have a minimum length of 32 characters',
  'change_password_upon_first_use'     => 'False',
}

keystone_federation = {
  'cache_group_membership_in_db' => 'True',
}

keystone_resource = {
  'admin_project_domain_name' => 'project',
  'admin_project_name'        => 'projectname',
}

keystone_oslo_middleware = {
  'max_request_body_size'  => '114688',
}

control 'Keystone' do

  describe parse_config_file('/etc/keystone/keystone.conf') do

    describe 'Keystone messaging' do

      if ssl_enabled
        keystone_oslo_messaging_rabbit.merge!(keystone_oslo_messaging_rabbit_ssl)
        keystone_default.merge!(keystone_default_ssl)
        describe 'SSL' do
          its('DEFAULT') {
            should include(keystone_default)
          }
          its('oslo_messaging_rabbit') {
            should include(keystone_oslo_messaging_rabbit)
          }
        end
      else
        describe 'non SSL' do
          its('DEFAULT') {
            should include(keystone_default)
          }
          its('oslo_messaging_rabbit') {
            should include(keystone_oslo_messaging_rabbit)
          }
        end
      end

    end

    describe 'Keystone database' do

      if ssl_enabled
        keystone_database.merge!(keystone_database_ssl)
        describe 'SSL' do
          its('database') {
            should include(keystone_database)
          }
        end
      else
        describe 'non SSL' do
          its('database') {
            should include(keystone_database)
          }
        end
      end

    end

    describe 'Keystone config' do

      its('DEFAULT') {
        should include(keystone_default)
      }
      its('assignment') {
        should include(keystone_assignment)
      }
      its('auth') {
        should include(keystone_auth)
      }
      its('catalog') {
        should include(keystone_catalog)
      }
      its('credential') {
        should include(keystone_credential)
      }
      its('fernet_tokens') {
        should include(keystone_fernet_tokens)
      }
      its('identity') {
        should include(keystone_identity)
      }
      its('token') {
        should include(keystone_token)
      }
      its('cors') {
        should include(keystone_cors)
      }
      its('oidc') {
        should include(keystone_oidc)
      }
      its('saml2') {
        should include(keystone_saml2)
      }
      its('security_compliance') {
        should include(keystone_security_compliance)
      }
      its('federation') {
        should include(keystone_federation)
      }
      its('resource') {
        should include(keystone_resource)
      }
      its('oslo_middleware') {
        should include(keystone_oslo_middleware)
      }
      its('cache') {
        should include(keystone_cache)
      }

    end
  end
end
