ssl_enabled = attribute("ssl", default: false)

keystone_default_ssl = {
  'transport_url' => 'rabbit://openstack:password@127.0.0.1:5671//openstack',
  'log_config_append'         => '/etc/keystone/logging.conf',
  'debug'                     => 'false',
  'notification_format'       => 'cadf',
  'admin_token'               => 'RANDOMSTRINGTOKEN',
  'log_dir'                   => '/var/log/keystone',
  'secure_proxy_ssl_header'   => 'HTTP_X_FORWARDED_PROTO',
  'verbose'                   => 'true',
}

keystone_default = {
  'transport_url' => 'rabbit://openstack:password@127.0.0.1:5672//openstack',
  'log_config_append'         => '/etc/keystone/logging.conf',
  'debug'                     => 'false',
  'notification_format'       => 'cadf',
  'admin_token'               => 'RANDOMSTRINGTOKEN',
  'log_dir'                   => '/var/log/keystone',
  'secure_proxy_ssl_header'   => 'HTTP_X_FORWARDED_PROTO',
  'verbose'                   => 'true',
}

keystone_assignment = {
  'driver' => 'sql'
}

keystone_auth = {
  'methods' => 'password,token',
  'oidc'    => 'keystone.auth.plugins.mapped.Mapped',
  'saml2'   => 'keystone.auth.plugins.mapped.Mapped',
}

keystone_catalog = {
  'template_file' => 'default_catalog.templates',
  'driver'        => 'sql',
}

keystone_credential = {
  'key_repository' => '/var/lib/keystone/credential-keys'
}

keystone_fernet_tokens = {
  'key_repository'  => '/etc/keystone/fernet-keys/',
  'max_active_keys' => '3',
}

keystone_identity = {
  'driver'                          => 'sql',
}

keystone_token = {
  'expiration'     => '86400',
  'provider'       => 'keystone.token.providers.fernet.Provider',
  'caching'        => 'false',
  'hash_algorithm' => 'sha256',
  'driver'         => 'keystone.token.persistence.backends.memcache_pool.Token',
  'revoke_by_id'   => 'False',
}

keystone_cache = {
  'backend'          => 'oslo_cache.memcache_pool',
  'enabled'          => 'True',
  'memcache_servers' => '127.0.0.1:11211',
}

keystone_oslo_messaging_rabbit = {
  'heartbeat_timeout_threshold' => '0',
  'heartbeat_rate'              => '2',
}

keystone_oslo_messaging_rabbit_ssl = {
  'rabbit_use_ssl'     => 'true',
  'kombu_ssl_version'  => 'TLSv1_2',
  'kombu_ssl_ca_certs' => '/etc/keystone/ssl/mysql/ca-cert.pem',
}

keystone_database = {
  'connection'              => 'mysql+pymysql://keystone:passw0rd@127.0.0.1/keystone',
  'max_pool_size'           => '10',
  'max_retries'             => '-1',
  'max_overflow'            => '30',
  'idle_timeout'            => '3600',
}

keystone_database_ssl = {
  'connection'              => 'mysql+pymysql://keystone:passw0rd@127.0.0.1/keystone?ssl_ca=/etc/keystone/ssl/mysql/ca-cert.pem',
  'max_pool_size'           => '10',
  'max_retries'             => '-1',
  'max_overflow'            => '30',
  'idle_timeout'            => '3600',
}

keystone_oslo_middleware = {
  'max_request_body_size'        => '114688',
  'enable_proxy_headers_parsing' => 'True',
}

keystone_cors = {
  'allowed_origin'    => 'https://horizon.example.com',
  'allow_credentials' => 'True',
  'expose_headers'    => 'X-Auth-Token,X-Openstack-Request-Id,X-Subject-Token',
  'max_age'           => '3600',
  'allow_methods'     => 'GET,PUT,POST,DELETE,PATCH',
  'allow_headers'     => 'X-Auth-Token,X-Openstack-Request-Id,X-Subject-Token,X-Project-Id,X-Project-Name,X-Project-Domain-Id,X-Project-Domain-Name,X-Domain-Id,X-Domain-Name',
}

keystone_profiler = {
  'enabled' => 'True',
}

keystone_oidc = {
  'remote_id_attribute' => 'HTTP_OIDC_ISS'
}

keystone_saml2 = {
  'remote_id_attribute' => 'HTTP_OIDC_ISS'
}

keystone_security_compliance = {
  'disable_user_account_days_inactive' => '90',
  'lockout_failure_attempts'           => '5',
  'lockout_duration'                   => '600',
  'password_expires_days'              => '90',
  'unique_last_password_count'         => '10',
  'minimum_password_age'               => '0',
  'password_regex'                     => '^(?=.*\d)(?=.*[a-zA-Z]).{7,}$$',
  'password_regex_description'         => 'Your password must contains at least 1 letter, 1 digit, and have a minimum length of 7 characters',
  'change_password_upon_first_use'     => 'True',
}

keystone_federation = {
  'cache_group_membership_in_db' => 'True',
}

keystone_resource = {
  'admin_project_domain_name' => 'project',
  'admin_project_name'        => 'projectname',
}

keystone_extra_headers = {
  'Distribution'          => 'Ubuntu',
}

control 'Keystone' do

  describe parse_config_file('/etc/keystone/keystone.conf') do

    describe 'Keystone messaging' do

      if ssl_enabled
        keystone_oslo_messaging_rabbit.merge!(keystone_oslo_messaging_rabbit_ssl)
        keystone_default.merge!(keystone_default_ssl)
        describe 'SSL' do
          its('DEFAULT') {
            should include(keystone_default)
          }
          its('oslo_messaging_rabbit') {
            should include(keystone_oslo_messaging_rabbit)
          }
        end
      else
        describe 'non SSL' do
          its('DEFAULT') {
            should include(keystone_default)
          }
          its('oslo_messaging_rabbit') {
            should include(keystone_oslo_messaging_rabbit)
          }
        end
      end

    end

    describe 'Keystone database' do

      if ssl_enabled
        keystone_database.merge!(keystone_database_ssl)
        describe 'SSL' do
          its('database') {
            should include(keystone_database)
          }
        end
      else
        describe 'non SSL' do
          its('database') {
            should include(keystone_database)
          }
        end
      end

    end

    describe 'Keystone config' do

      its('DEFAULT') {
        should include(keystone_default)
      }
      its('assignment') {
        should include(keystone_assignment)
      }
      its('auth') {
        should include(keystone_auth)
      }
      its('catalog') {
        should include(keystone_catalog)
      }
      its('credential') {
        should include(keystone_credential)
      }
      its('fernet_tokens') {
        should include(keystone_fernet_tokens)
      }
      its('identity') {
        should include(keystone_identity)
      }
      its('token') {
        should include(keystone_token)
      }
      its('cors') {
        should include(keystone_cors)
      }
      its('oidc') {
        should include(keystone_oidc)
      }
      its('saml2') {
        should include(keystone_saml2)
      }
      its('security_compliance') {
        should include(keystone_security_compliance)
      }
      its('federation') {
        should include(keystone_federation)
      }
      its('resource') {
        should include(keystone_resource)
      }
      its('extra_headers') {
        should include(keystone_extra_headers)
      }

    end
  end
end
