keystone:
  server:
    enabled: true
    version: liberty
    service_token: token
    service_tenant: service
    admin_tenant: admin
    admin_name: admin
    admin_password: passw0rd
    admin_email: root@localhost
    bind:
      address: 0.0.0.0
      private_address: 127.0.0.1
      private_port: 35357
      public_address: 127.0.0.1
      public_port: 5000
    region: RegionOne
    database:
      engine: mysql
      host: 127.0.0.1
      name: keystone
      password: passw0rd
      user: keystone
    tokens:
      engine: cache
      expiration: 86400
      allow_expired_window: 86400
      location: /etc/keystone/fernet-keys/
    notification: false
    notification_format: cadf
    security_compliance:
      disable_user_account_days_inactive: 90
      lockout_failure_attempts: 60
      lockout_duration: 600
      password_expires_days: 730
      unique_last_password_count: 5
      minimum_password_age: 0
      password_regex: '^[a-zA-Z0-9]{32,}$$'
      password_regex_description: |
        Your password could contains capital letters, lowercase letters, digits and have a minimum length of 32 characters
      change_password_upon_first_use: False
    logging:
      log_appender: false
      log_handlers:
        watchedfile:
          enabled: true
        fluentd:
          enabled: false
        ossyslog:
          enabled: false
    message_queue:
      engine: rabbitmq
      host: 127.0.0.1
      port: 5672
      user: openstack
      password: passw0rd
      virtual_host: '/openstack'
      ha_queues: true
    cache:
      engine: memcached
      expiration_time: 600
      backend_argument:
        memcached_expire_time:
          value: 660
      members:
      - host: 127.0.0.1
        port: 11211
      - host: 127.0.0.1
        port: 11211
      - host: 127.0.0.1
        port: 11211
    domain:
      test:
        description: "Test domain"
        identity:
          list_limit: 20
    federation:
      oidc:
        idp_protocols_auth_url: '/idp/auth/url'
        idp_protocols_websso_url: '/idp/websso/url'
        websso_url: '/websso/url'
    extra_config:
      federation:
        cache_group_membership_in_db: true
    configmap:
      DEFAULT:
        debug: true
        rate_limit_except_level: debug
      auth:
        methods: 'external,password,token'
      tokenless_auth:
        trusted_issuer:
          type: 'MultiOpt'
          values:
            value1: 'O=Mirantis,L=Prague,CN=Salt Master CA,C=cz'
            value2: 'O=Mirantis,L=Kharkiv,CN=Salt Master CA2,C=ua'
