include:
  - single

keystone:
  client:
    resources:
      v3:
        enabled: true
        cloud_name: 'admin_identity'
        domains:
          'Default':
            enabled: True
            status: present
            projects:
              service:
                status: present
                description: "OpenStack Service tenant"
              admin:
                status: absent
                description: "OpenStack Admin tenant"
          'User_domain':
            enabled: True
            status: absent
            projects:
              user_domain_service:
                status: present
                description: "OpenStack Service tenant"
              user_domain_admin:
                status: absent
                description: "OpenStack Admin tenant"
          'User_domain_0':
            enabled: True
            status: absent
            force_delete: True
            projects:
              user_domain_0_service:
                status: present
                description: "OpenStack Service tenant"
              user_domain_0_admin:
                status: absent
                description: "OpenStack Admin tenant"
          'User_domain_1':
            enabled: False
            status: absent
            projects:
              user_domain_1_service:
                status: present
                description: "OpenStack Service tenant"
              user_domain_1_admin:
                status: absent
                description: "OpenStack Admin tenant"
        roles:
          service_admin:
            name: admin
            enabled: true
            status: present
          global_Member:
            name: Member
            enabled: true
            status: absent
          global_Member_0:
            name: Member
            enabled: False
            status: absent
        users:
          admin:
            enabled: true
            status: present
            password: passw0rd
            email: root@localhost
            roles:
              service_admin:
                status: assigned
                name: admin
                project_id: admin
          user:
            enabled: true
            status: absent
            password: passw0rd
            email: root@localhost
            roles:
              global_Member:
                status: unassigned
                name: user
                project_id: user
          user0:
            enabled: False
            status: absent
            password: passw0rd
            email: root@localhost
            roles:
              global_Member:
                status: unassigned
                name: user
                project_id: user
        services:
          keystone:
            enabled: True
            status: present
            type: 'identity'
            description: "OpenStack Identity Service"
            endpoints:
              keystone_public:
                status: present
                interface: 'public'
                url: https://127.0.0.1:5000/
                region: RegionOne
              keystone_internal:
                status: absent
                interface: 'internal'
                url: https://127.0.0.1:5000/
                region: RegionOne
          keystone_0:
            enabled: True
            status: absent
            type: 'identity'
            description: "OpenStack Identity Service"
            endpoints:
              keystone_0_public:
                status: present
                interface: 'public'
                url: https://127.0.0.1:5000/
                region: RegionOne
              keystone_0_internal:
                status: absent
                interface: 'internal'
                url: https://127.0.0.1:5000/
                region: RegionOne
          keystone_1:
            enabled: False
            status: absent
            type: 'identity'
            description: "OpenStack Identity Service"
            endpoints:
              keystone_1_public:
                status: present
                interface: 'public'
                url: https://127.0.0.1:5000/
                region: RegionOne
              keystone_1_internal:
                status: absent
                interface: 'internal'
                url: https://127.0.0.1:5000/
                region: RegionOne

