keycloak:
  server:
    enabled: true
    realm:
      ldap-realm:
        enabled: true
        id: ldap-realm
        additional_params:
          registrationAllowed: false
          registrationEmailAsUsername: false
          resetPasswordAllowed: false
          accessTokenLifespan: 60
          ssoSessionIdleTimeout: 600
        client:
          ldap-app:
            enabled: true
            base_url: /ldap-portal
            redirect_uris:
            - /ldap-portal/*
            web_origins:
            - "*"
            public_client: false
            admin_url: /ldap-portal
            secret: password
            protocol_mapper:
              oidc-usermodel-property-mapper:
                username:
                  name: username
                  user_attribute: username
                  claim_name: preferred_username
                given_name:
                  name: given name
                  user_attribute: firstName
                  claim_name: given_name
                family_name:
                  name: family name
                  user_attribute: lastName
                  claim_name: family_name
                email:
                  name: email
                  user_attribute: email
                  claim_name: email
              oidc-full-name-mapper:
                full_name:
                  name: full_name
        federation_provider:
          ldap:
            display_name: ldap-server
            users_dn: ou=people,dc=keycloak,dc=org
            user_object_classes: inetOrgPerson, organizationalPerson
            username_ldap_attribute: uid
            bind_dn: cn=admin,dc=keycloak,dc=org
            bind_credential: password
            rdn_ldap_attribute: uid
            edit_mode: READ_ONLY
            uuid_ldap_attribute: entryUUID
            connection_url: ldap://localhost:10389
            sync_registrations: false
        federation_mapper:
          user-attribute-ldap-mapper:
            username:
              name: username
              provider_display_name: ldap-server
              ldap_attribute: uid
              model_attribute: username
              mandatory: true
              read_only: false
              always_read: false
            first_name:
              name: first name
              provider_display_name: ldap-server
              ldap_attribute: cn
              model_attribute: firstName
              mandatory: true
              read_only: false
              always_read: false
            last_name:
              name: last name
              provider_display_name: ldap-server
              ldap_attribute: sn
              model_attribute: lastName
              mandatory: true
              read_only: false
              always_read: false
            email:
              name: email
              provider_display_name: ldap-server
              ldap_attribute: mail
              model_attribute: email
              mandatory: false
              read_only: false
              always_read: false
          role-ldap-mapper:
            realm_roles:
              name: realm roles
              provider_display_name: ldap-server
              roles_dn: ou=groups,dc=cicd,dc=local
              membership_ldap_attribute: member
              role_name_ldap_attribute: cn
              role_object_classes: groupOfNames
              mode: LDAP_ONLY
              realm_roles_mapping: true
