ironic:
  conductor:
    version: ocata
    enabled: true
    tftp_root: '/var/lib/tftpboot'
    message_queue:
      engine: rabbitmq
      host: '127.0.0.1'
      port: 5672
      user: openstack
      password: workshop
      virtual_host: '/openstack'
    database:
      engine: mysql
      host: '127.0.0.1'
      port: 3306
      name: ironic
      user: ironic
      password: workshop
    identity:
      engine: 'noauth'
    http_root: '/var/www/httproot'
    console:
      terminal: shellinaboxd
      terminal_cert_dir: /tmp/ca
      terminal_timeout: 10
      subprocess_checking_interval: 1
      subprocess_timeout: 10
      socat_address: 127.0.0.1
    pxe_append_params: nofb nomodeset vga=normal
    configmap:
      DEFAULT:
        enabled_drivers: pxe_ipmitool
        enabled_hardware_types: ipmi
        enabled_boot_interfaces: pxe
      disk_partitioner:
        check_device_interval: 1
        check_device_max_retries: 20
      disk_utils:
        efi_system_partition_size: 200
        bios_boot_partition_size: 1
  tftpd_hpa:
    server:
      bind:
        address: '0.0.0.0'
        port: 69
      username: 'ironic'
      path: ${ironic:conductor:tftp_root}
      options:
        - secure
        - map-file: '${ironic:conductor:tftp_root}/map-file'
