ironic:
  api:
    enabled: true
    api_type: deploy
    version: mitaka
    bind:
      address: '0.0.0.0'
      port: 6385
    message_queue:
      engine: rabbitmq
      host: '127.0.0.1'
      port: 5672
      user: openstack
      password: workshop
      virtual_host: '/openstack'
    database:
      engine: mysql
      host: '127.0.0.1'
      port: 3306
      name: ironic
      user: ironic
      password: workshop
    identity:
      engine: 'noauth'
    cache:
      engine: memcached
      members:
      - host: 127.0.0.1
        port: 11211
      - host: 127.0.0.1
        port: 11211
      security:
        enabled: true
        strategy: ENCRYPT
        secret_key: secret
    configmap:
      DEFAULT:
        enabled_drivers: pxe_ipmitool
        enabled_hardware_types: ipmi
        enabled_boot_interfaces: pxe
      api:
        host_ip: 0.0.0.0
        port: 6385
        max_limit: 1000
    policy:
      'baremetal:node:create': 'rule:is_admin'
      'baremetal:node:delete': 'rule:is_admin'
      # Add key without value to remove line from policy.json
      'baremetal:node:update':
