ssl_enabled = attribute("ssl", default: false)

oslo_messaging_rabbit = {
  'rabbit_host' => '127.0.0.1',
  'rabbit_port' => '5672'
}

service_sink = {
  'enabled_notification_handlers' => 'nova_fixed, neutron_floatingip'
}

handler_nova_fixed = {
  'zone_id'             => '5186883b-91fb-4891-bd49-e6769234a8fc',
  'notification_topics' => 'notifications',
  'control_exchange'    => "'nova'",
  'formatv4'            => "'%(hostname)s.%(zone)s'",
  'formatv6'            => "'%(hostname)s.%(zone)s'",
}

handler_neutron_floatingip = {
  'zone_id'             => '5186883b-91fb-4891-bd49-e6769234a8fc',
  'notification_topics' => 'notifications',
  'control_exchange'    => "'neutron'",
  'formatv4'            => "'%(hostname)s.%(zone)s'",
  'formatv6'            => "'%(hostname)s.%(zone)s'",
}

section1 = {
  'default_soa_refresh_min' => '3500',
  'default_soa_refresh_max' => '3600',
  'default_soa_minimum'     => '3600',
}

section2_subsection1 = {
  'admin_username'    => 'admin',
  'admin_password'    => 'password',
  'admin_tenant_name' => 'tenant1',
}

control 'Designate' do

  describe parse_config_file('/etc/designate/designate.conf') do

    describe 'Designate messaging' do

      if ssl_enabled
        # SSL not supported in Ocata
        describe 'SSL' do
        end
      else
        describe 'non SSL' do
          its('oslo_messaging_rabbit') do
            should include(oslo_messaging_rabbit)
          end
        end
      end

    end

    describe 'Designate notification handlers' do

      its('service:sink') do
        should include(service_sink)
      end

      its('handler:nova_fixed') do
        should include(handler_nova_fixed)
      end

      its('handler:neutron_floatingip') do
        should include(handler_neutron_floatingip)
      end

    end

    describe 'Custom configmap settings' do

      its('section1') do
        should include(section1)
      end

      its('section2:subsection1') do
        should include(section2_subsection1)
      end

    end

  end
end
