from cinderv3.common import send
from cinderv3.arg_converter import get_by_name_or_uuid_multiple

try:
    from urllib.parse import urlencode
except ImportError:
    from urllib import urlencode


@send("post")
def volume_create(size, **kwargs):
    url = '/volumes'
    json = {'volume': {
        'size': size,
    }}
    json['volume'].update(kwargs)
    return url, json


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send("get")
def volume_get_details(volume_id, **kwargs):
    url = '/volumes/{}'.format(volume_id)
    return url, None


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send("put")
def volume_update(volume_id, **kwargs):
    url = '/volumes/{}'.format(volume_id)
    json = {'volume': kwargs}
    return url, json


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send("delete")
def volume_delete(volume_id, **kwargs):
    url = '/volumes/{}'.format(volume_id)
    return url, None


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send("post")
def volume_metadata_create(volume_id, metadata, **kwargs):
    url = '/volumes/{}/metadata'.format(volume_id)
    json = {
        'metadata': metadata,
    }
    return url, json


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send("get")
def volume_metadata_show(volume_id, **kwargs):
    url = '/volumes/{}/metadata'.format(volume_id)
    return url, None


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send("put")
def volume_metadata_update(volume_id, metadata, **kwargs):
    url = '/volumes/{}/metadata'.format(volume_id)
    json = {
        'metadata': metadata,
    }
    return url, json


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send("get")
def volume_metadata_show_key(volume_id, key, **kwargs):
    url = '/volumes/{}/metadata/{}'.format(volume_id, key)
    return url, None


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send("delete")
def volume_metadata_delete(volume_id, key):
    url = '/volumes/{}/metadata/{}'.format(volume_id, key)
    return url, None


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send("put")
def volume_metadata_update_key(volume_id, key, meta, **kwargs):
    url = '/volumes/{}/metadata/{}'.format(volume_id, key)
    json = {
        'meta': meta,
    }
    return url, json
