from cinderv3.common import send
from cinderv3.arg_converter import get_by_name_or_uuid_multiple

try:
    from urllib.parse import urlencode
except ImportError:
    from urllib import urlencode


@get_by_name_or_uuid_multiple([('volume', 'volume_id')])
@send('post')
def image_upload_volume(volume_id, image_name, **kwargs):
    url = '/volumes/{}/action'.format(volume_id)
    json = {
        'os-volume_upload_image': {
            'image_name': image_name,
        }
    }
    json['os-volume_upload_image'].update(kwargs)
    return url, json
