from cinderv3.common import send

try:
    from urllib.parse import urlencode
except ImportError:
    from urllib import urlencode


@send("get")
def volume_list(**kwargs):
    """
    Return list of cinder volumes.
    """
    url = '/volumes?{}'.format(urlencode(kwargs))
    return url, None


@send("get")
def volume_list_get_details(**kwargs):
    url = '/volumes/detail?{}'.format(urlencode(kwargs))
    return url, None


@send("get")
def volume_type_list(**kwargs):
    """
    Return list of volume types
    """
    url = '/types?{}'.format(urlencode(kwargs))
    return url, None


@send("get")
def service_list(**kwargs):
    """
    Return list of Cinder services.
    """
    url = '/os-services?{}'.format(urlencode(kwargs))
    return url, None
