try:
    import os_client_config
    REQUIREMENTS_MET = True
except ImportError:
    REQUIREMENTS_MET = False

from cinderv3 import lists
from cinderv3 import volumes
from cinderv3 import volume_types
from cinderv3 import volume_actions
from cinderv3 import services

volume_list = lists.volume_list
volume_list_get_details = lists.volume_list_get_details
volume_create = volumes.volume_create
volume_get_details = volumes.volume_get_details
volume_update = volumes.volume_update
volume_delete = volumes.volume_delete
volume_metadata_create = volumes.volume_metadata_create
volume_metadata_show = volumes.volume_metadata_show
volume_metadata_update = volumes.volume_metadata_update
volume_metadata_show_key = volumes.volume_metadata_show_key
volume_metadata_delete = volumes.volume_metadata_delete
volume_metadata_update_key = volumes.volume_metadata_update_key
volume_type_list = lists.volume_type_list
volume_type_get_details = volume_types.volume_type_get_details
volume_type_create = volume_types.volume_type_create
volume_type_delete = volume_types.volume_type_delete
keys_volume_type_get = volume_types.keys_volume_type_get
keys_volume_type_set = volume_types.keys_volume_type_set
image_upload_volume = volume_actions.image_upload_volume
service_list = lists.service_list
service_update = services.service_update
service_wait = services.wait_for_service

__all__ = ('volume_list', 'volume_create', 'volume_delete',
           'volume_get_details', 'volume_list_get_details', 'volume_update',
           'volume_metadata_create', 'volume_metadata_delete',
           'volume_metadata_show', 'volume_metadata_show_key',
           'volume_metadata_update', 'volume_metadata_update_key',
           'volume_type_list', 'volume_type_get_details',
           'volume_type_create', 'keys_volume_type_get',
           'keys_volume_type_set', 'volume_type_delete',
           'image_upload_volume', 'service_list', 'service_update', 'service_wait')

def __virtual__():
    if REQUIREMENTS_MET:
        return 'cinderv3'
    else:
        return False, ("The cinderv3 execution module cannot be loaded: "
                       "os_client_config are unavailable.")
