from cinderv3.common import send
from cinderv3.arg_converter import get_by_name_or_uuid_multiple
try:
    from urllib.parse import urlencode
except ImportError:
    from urllib import urlencode


@get_by_name_or_uuid_multiple([('volume_type', 'volume_type_id')])
@send("get")
def volume_type_get_details(volume_type_id, **kwargs):
    """
    Returns id of the specified volume type name
    """
    url = "/types/{volume_type_id}".format(volume_type_id=volume_type_id)
    return url, None


@get_by_name_or_uuid_multiple([('volume_type', 'volume_type_id')])
@send("delete")
def volume_type_delete(volume_type_id, **kwargs):
    """
    delete the specified volume type
    """
    url = "/types/{volume_type_id}".format(volume_type_id=volume_type_id)
    return url, None


@send("post")
def volume_type_create(name, **kwargs):
    """
    Create cinder volume type
    """
    url = "/types"
    req = {"volume_type": {"name": name}}
    return url, req


@get_by_name_or_uuid_multiple([('volume_type', 'volume_type_id')])
@send("get")
def keys_volume_type_get(volume_type_id, **kwargs):
    """
    Return extra specs of the specified volume type.
    """
    url = "/types/{volume_type_id}/extra_specs".format(
        volume_type_id=volume_type_id)
    return url, None


@send("put")
def _key_volume_type_set(type_id, key, value, **kwargs):
    url = "/types/{volume_type_id}/extra_specs/{key}".format(
        volume_type_id=type_id, key=key)
    return url, {str(key): str(value)}


@get_by_name_or_uuid_multiple([('volume_type', 'volume_type_id')])
def keys_volume_type_set(volume_type_id, keys=None, **kwargs):
    """
    Set extra specs of the specified volume type.
    """
    if keys is None:
        keys = {}
    cloud_name = kwargs["cloud_name"]
    cur_keys = keys_volume_type_get(
        volume_type_id, cloud_name=cloud_name)["extra_specs"]

    for k, v in keys.items():
        if (k, v) in cur_keys.items():
            continue
        resp = _key_volume_type_set(volume_type_id, k, v, cloud_name=cloud_name)
        if resp.get("result") is False:
            return resp

    return {"result": True}
