import uuid
from cinderv3 import common
from cinderv3 import lists


class CheckId(object):
    def check_id(self, val):
        try:
            return str(uuid.UUID(val)) == val
        except (TypeError, ValueError, AttributeError):
            return False


def named_checker(resource, ref, cloud_name, **kwargs):
    resp_key = response_keys[resource]
    resp = resource_lists[resource](
        name=ref, cloud_name=cloud_name, **kwargs)[resp_key]
    if len(resp) == 0:
        raise common.ResourceNotFound(resp_key, ref)
    elif len(resp) > 1:
        raise common.MultipleResourcesFound(resp_key, ref)
    return resp[0]['id']


def nameless_checker(resource, ref, cloud_name, **kwargs):
    item_id = None
    resp_key = response_keys[resource]
    resp = resource_lists[resource](
        cloud_name=cloud_name, **kwargs)[resp_key]
    for item in resp:
        if item["name"] == ref:
            if item_id is not None:
                raise common.MultipleResourcesFound(resp_key, ref)
            item_id = item["id"]
    if not item_id:
        raise common.ResourceNotFound(resp_key, ref)
    return item_id



resource_lists = {
    'volume': lists.volume_list,
    'volume_type': lists.volume_type_list
}


response_keys = {
    'volume': 'volumes',
    'volume_type': 'volume_types',
}


name_checkers = {
    'volume': named_checker,
    'volume_type': nameless_checker,
}


def get_by_name_or_uuid_multiple(resource_arg_name_pairs):
    def wrap(func):
        def wrapped_f(*args, **kwargs):
            results = []
            args_start = 0
            connection_params = kwargs.pop('connection_params', {}) or {}
            for index, (resource, arg_name) in enumerate(
                    resource_arg_name_pairs):
                if arg_name in kwargs:
                    ref = kwargs.pop(arg_name, None)
                else:
                    ref = args[index]
                    args_start += 1
                cloud_name = kwargs['cloud_name']
                checker = CheckId()
                if checker.check_id(ref):
                    results.append(ref)
                else:
                    # Then we have name not uuid
                    res = name_checkers[resource](resource, ref, cloud_name,
                                                  connection_params=connection_params)
                    results.append(res)
                results.extend(args[args_start:])
            return func(*results, **kwargs)
        return wrapped_f
    return wrap
