#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements. See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership. The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License. You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied. See the License for the
# specific language governing permissions and limitations
# under the License.
#

#
# Autogenerated by Thrift
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#

require 'thrift'
require 'thrift/protocol'
require File.dirname(__FILE__) + '/Benchmark_types'

    module ThriftBenchmark
      module BenchmarkService
        class Client
          include ::Thrift::Client

          def fibonacci(n)
            send_fibonacci(n)
            return recv_fibonacci()
          end

          def send_fibonacci(n)
            send_message('fibonacci', Fibonacci_args, :n => n)
          end

          def recv_fibonacci()
            result = receive_message(Fibonacci_result)
            return result.success unless result.success.nil?
            raise Thrift::ApplicationException.new(Thrift::ApplicationException::MISSING_RESULT, 'fibonacci failed: unknown result')
          end

        end

        class Processor
          include ::Thrift::Processor

          def process_fibonacci(seqid, iprot, oprot)
            args = read_args(iprot, Fibonacci_args)
            result = Fibonacci_result.new()
            result.success = @handler.fibonacci(args.n)
            write_result(result, oprot, 'fibonacci', seqid)
          end

        end

        # HELPER FUNCTIONS AND STRUCTURES

        class Fibonacci_args
          include ::Thrift::Struct
          N = 1

          Thrift::Struct.field_accessor self, :n
          FIELDS = {
            N => {:type => Thrift::Types::BYTE, :name => 'n'}
          }

          def struct_fields; FIELDS; end

          def validate
          end

        end

        class Fibonacci_result
          include ::Thrift::Struct
          SUCCESS = 0

          Thrift::Struct.field_accessor self, :success
          FIELDS = {
            SUCCESS => {:type => Thrift::Types::I32, :name => 'success'}
          }

          def struct_fields; FIELDS; end

          def validate
          end

        end

      end

    end
