#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements. See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership. The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License. You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied. See the License for the
# specific language governing permissions and limitations
# under the License.
#

# CMake 4.0+ removed the FindBoost module (CMP0167). Use OLD behavior to
# preserve compatibility with existing ${Boost_LIBRARIES} usage.
if(POLICY CMP0167)
  cmake_policy(SET CMP0167 OLD)
endif()

# CMake 3.27+ warns and ignores upper-case <PACKAGENAME>_ROOT variables unless
# CMP0144 is set. We pass BOOST_ROOT on Windows builds, so enable NEW behavior.
if(POLICY CMP0144)
  cmake_policy(SET CMP0144 NEW)
endif()

# Force using FindBoost instead of Boost's own BoostConfig.cmake.
# BoostConfig.cmake does not populate ${Boost_LIBRARIES} the same way,
# which causes linking failures on Windows.
set(Boost_NO_BOOST_CMAKE ON)

set(BOOST_MINREV 1.56)

macro(REQUIRE_BOOST_HEADERS)
  find_package(Boost ${BOOST_MINREV} QUIET REQUIRED)
  if (NOT Boost_FOUND)
    message(FATAL_ERROR "Boost ${BOOST_MINREV} or later is required to build sources in ${CMAKE_CURRENT_SOURCE_DIR}")
  endif()
  if (DEFINED Boost_INCLUDE_DIRS)
    # pre-boost 1.70.0 aware cmake, otherwise it is using targets
    include_directories(SYSTEM "${Boost_INCLUDE_DIRS}")
  endif()
endmacro()

macro(REQUIRE_BOOST_LIBRARIES libs)
  message(STATUS "Locating boost libraries required by sources in ${CMAKE_CURRENT_SOURCE_DIR}")
  find_package(Boost ${BOOST_MINREV} REQUIRED COMPONENTS ${${libs}})
  if (NOT Boost_FOUND)
    message(FATAL_ERROR "Boost ${BOOST_MINREV} or later is required to build sources in ${CMAKE_CURRENT_SOURCE_DIR}, or use -DBUILD_TESTING=OFF")
  endif()
endmacro()
