#ifndef T_BASE_TYPE_H
#define T_BASE_TYPE_H

#include "t_type.h"

/**
 * A thrift base type, which must be one of the defined enumerated types inside
 * this definition.
 *
 * @author Mark Slee <mcslee@facebook.com>
 */
class t_base_type : public t_type {
 public:
  /**
   * Enumeration of thrift base types
   */
  enum t_base {
    TYPE_VOID,
    TYPE_STRING,
    TYPE_BOOL,
    TYPE_BYTE,
    TYPE_I16,
    TYPE_I32,
    TYPE_I64,
    TYPE_DOUBLE
  };

  t_base_type(std::string name, t_base base) :
    t_type(name),
    base_(base),
    string_list_(false) {}
    
  t_base get_base() const {
    return base_;
  }

  bool is_void() const {
    return base_ == TYPE_VOID;
  }

  bool is_string() const {
    return base_ == TYPE_STRING;
  }
  
  void set_string_list(bool val) {
    string_list_ = val;
  }

  bool is_string_list() const {
    return base_ == TYPE_STRING && string_list_;
  }

  bool is_base_type() const {
    return true;
  }
    
 private:
  t_base base_;
  bool string_list_;
};

#endif
