/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.thrift;

import java.util.HashSet;

import junit.framework.TestCase;

import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TType;

import thrift.test.OneOfEachZZ;
import thrift.test.UnderscoreSrv;

// Sanity check for the code generated by 'fullcamel'.
//
public class TestFullCamel extends TestCase {

  public void testCamelCaseSyntax() throws Exception {
    TSerializer   binarySerializer   = new   TSerializer(new TBinaryProtocol.Factory());
    TDeserializer binaryDeserializer = new TDeserializer(new TBinaryProtocol.Factory());

    OneOfEachZZ obj = new OneOfEachZZ();
    obj.setABite((byte) 0xae);
    obj.setImFalse(true);
    byte[] serBytes = binarySerializer.serialize(obj);
    binaryDeserializer.deserialize(obj, serBytes);
    assertTrue( obj.getABite() == (byte) 0xae );
    assertTrue( obj.isImFalse() == true );
  }

  public void testCamelCaseRpcMethods() throws Exception {
    final UnderscoreSrv.Iface srv = new UnderscoreSrv.Iface() {
      @Override
      public long someRpcCall(String message) {
        return 1l;
      }
    };
    assertTrue(1l == srv.someRpcCall("test"));
  }
}

