#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from tempest.services.volume.json import snapshots_client


class SnapshotsV2ClientJSON(snapshots_client.BaseSnapshotsClientJSON):
    """Client class to send CRUD Volume V2 API requests."""

    def __init__(self, auth_provider):
        super(SnapshotsV2ClientJSON, self).__init__(auth_provider)

        self.api_version = "v2"
        self.create_resp = 202
