# Copyright 2021 Mirantis Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


import testtools

from tempest.api.volume import base
from tempest import config
from tempest.lib import decorators


CONF = config.CONF


class VolumesFilter(base.BaseVolumeAdminTest):
    @testtools.skipUnless(
        CONF.volume_feature_enabled.instance_locality_enabled,
        "InstanceLocalityFilter test is disabled",
    )
    @testtools.skipUnless(
        CONF.volume_feature_enabled.instance_locality_enabled,
        "InstanceLocalityFilter test is disabled",
    )
    @decorators.idempotent_id("5c13f4f7-5add-4fad-8ef7-dccca0f76295")
    def test_instancelocalityfilter(self):
        # 1. Create instance
        # 2. Create volume by using local_to_instance hint
        # 3. Compare server host and volume host are the same.
        server = self.create_server()
        server_host = self.admin_manager.servers_client.show_server(
            server["id"])["server"]["OS-EXT-SRV-ATTR:host"]
        volume = self.create_volume(hints={"local_to_instance": server["id"]})
        fetched_volume = self.admin_volume_client.show_volume(volume["id"])[
            "volume"]
        self.assertEqual(
            server_host, fetched_volume["os-vol-host-attr:host"].split("@")
            [0],
            "The fetched Volume host is different "
            "from the created instance",)
