#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import time

from tempest.lib import exceptions as lib_exc


def wait_router_interface_removed(
    ports_client, router_id, subnet_id, timeout=30, interval=3):
    """Waits for router inface is removed"""
    start_time = int(time.time())
    while int(time.time()) - start_time < timeout:
        try:
            ports = ports_client.list_ports(
                device_id=router_id,
                fixed_ips=f"subnet_id={subnet_id}")['ports']
            if len(ports) == 0:
                return
            time.sleep(interval)
        except Exception:
            pass
    raise lib_exc.TimeoutException()
