function wait_vm_state {
    local vm_name=$1
    local state=$2
    i=1
    while [[ $(kubectl get vm ${vm_name} -o jsonpath="{.status.printableStatus}") != ${state} ]]; do
        echo "Waiting VM ${vm_name} status ${state}. Attempt ${i}"
        i=$(( i + 1 ))
        sleep 5
    done
}

function wait_vmsnapshot_state {
    local snapshot_name=$1
    local state=$2
    i=1
    while [[ $(kubectl get vmsnapshot ${snapshot_name} -o jsonpath="{.status.phase}") != ${state} ]]; do
        echo "Waiting vmsnapshot ${snapshot_name} phase is ${state}. Attempt ${i}"
        i=$(( i + 1 ))
        sleep 5
    done
}

function wait_vmrestore_completed {
    local restore_name=$1
    i=1
    while [[ $(kubectl get vmrestore ${restore_name} -o jsonpath="{.status.complete}") != "true" ]]; do
        echo "Waiting vmrestore ${restore_name} is completed. Attempt ${i}"
        i=$(( i + 1 ))
        sleep 5
    done
}
