#!/bin/bash

set -ex

LOG_FILE=${LOG_FILE:-"/var/log/build-image.log"}

apt update -y
DEBIAN_FRONTEND=noninteractive apt install -y moreutils

exec > >(ts '[%Y-%m-%d %H:%M:%S]' | tee -a "${LOG_FILE}" )
exec 2> >(ts '[%Y-%m-%d %H:%M:%S]' | tee -a "${LOG_FILE}" >&2)

DEBIAN_FRONTEND=noninteractive apt install -y python3-pip

PIP_BREAK_SYSTEM_PACKAGES=1 pip3 install ansible jmespath

ansible-galaxy collection install bodsch.core
ansible-galaxy collection install bodsch.scm
ansible-galaxy collection install community.docker
ansible-galaxy role install bodsch.k0s
ansible-galaxy role install cloudalchemy.coredns

TOP_DIR="$(cd "$(dirname "$0")" && pwd)"
INVENTORY_FILE="${TOP_DIR}/ansible/inventory/trymosk_single_node.yaml"
HOSTNAME=$(hostname)

sed -i "s/oc-virtual-lab-server-ctl-01/${HOSTNAME}/g" "${INVENTORY_FILE}"

cd ${TOP_DIR}/ansible

ansible-playbook -i "${INVENTORY_FILE}" build-image.yaml -vvv
