EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Creating PVC"
    kubectl apply -f pvc.yaml

    echo "Creating VM"
    kubectl apply -f cirros.yaml

    echo "Starting VM"
    virtctl start cirros-migrate

    echo "Waiting VM is Running."
    wait_vm_state cirros-migrate Running

    kubectl get pods -o wide

    read -p "Press any key to start live migration" -n 1 -r
    virtctl migrate cirros-migrate

    for i in {1..5}; do
        kubectl get pods -o wide
        kubectl get vmim
        sleep 5
    done
}

function cleanup {
    kubectl delete -f cirros.yaml
    kubectl delete -f pvc.yaml
}

pushd $WORKDIR
$command
popd
