EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Creating network attachments"
    kubectl apply -f network-attachment.yaml

    echo "Creating VMs"
    for vm in cirros-net1 cirros-net2; do
        kubectl apply -f $vm.yaml

        echo "Starting VM $vm"
        virtctl start $vm
    done
    echo "Waiting VM is Running."
    wait_vm_state cirros-net1 Running
    wait_vm_state cirros-net2 Running
}

function cleanup {
    for f in $(ls *.yaml); do
        kubectl delete -f $f
    done
}

pushd $WORKDIR
$command
popd
