EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Creating PVC"
    kubectl apply -f pvc.yaml

    echo "Creating VM"
    kubectl apply -f cirros.yaml

    echo "Waiting VM is Running."
    wait_vm_state cirros-snapshot Running

    echo "Login to VM and create some data on the volume. For example run:"
    echo "sudo su"
    echo "mkfs.ext4 /dev/sda"
    echo "mkdir /mnt/vol01"
    echo "mount -t ext4 /dev/sda /mnt/vol01"
    echo "date > /mnt/vol01/here"
    echo "sync"

    read -p "Press any key to create snapshot" -n 1 -r
    echo "Creating snapshot"

    kubectl apply -f snapshot.yaml
    wait_vmsnapshot_state cirros-snapshot Succeeded

    kubectl get vmsnapshot
    kubectl get volumesnapshotcontents

    echo "Login to VM and create some more data on the volume. For example run:"
    echo "sudo su"
    echo "mkdir /mnt/vol01"
    echo "mount -t ext4 /dev/sda /mnt/vol01"
    echo "date > /mnt/vol01/there"
    echo "sync"

    read -p "Press any key to stop VM" -n 1 -r
    virtctl stop cirros-snapshot
    wait_vm_state cirros-snapshot Stopped

    read -p "Press any key to restore VM snapshot" -n 1 -r
    kubectl apply -f restore.yaml

    wait_vmrestore_completed cirros-snapshot


    echo "Starting VM"
    virtctl start cirros-snapshot
    wait_vm_state cirros-snapshot Running

    echo "Login to VM and check data on the volume. For example run:"
    echo "sudo su"
    echo "mkdir /mnt/vol01"
    echo "mount -t ext4 /dev/sda /mnt/vol01"
    echo "ls -lah /mnt/vol01/"
}


function cleanup {
    kubectlt delete -f snapshot.yaml
    kubectl delete -f restore.yaml
    kubectl delete -f pvc.yaml
    kubectl delete -f cirros.yaml
}

pushd $WORKDIR
$command
popd
