#!/usr/bin/env bash

# script is taken from https://gerrit.mcp.mirantis.com/plugins/gitiles/kubernetes/lcm-ansible/+/refs/heads/master/roles/kubernetes-postinstall/templates/calico_disable_offloading.sh
# This script apply a workaround for a bug encountered on Kubernetes with vxlan
# and iptables >= 1.6.2.
# You can find more details on this bug here:
# https://github.com/kubernetes/kubernetes/issues/96868
# https://github.com/projectcalico/calico/issues/3145
#
# The workaround is to disable offloading on vxlan interface

nic_name='vxlan.calico'
if [ -e /etc/system-release ]; then
    #RHEL
    ethtool_cmd="/usr/sbin/ethtool"
    ip_cmd="/usr/sbin/ip"
else
    #Ubuntu
    ethtool_cmd="/sbin/ethtool"
    ip_cmd="/sbin/ip"
fi

_ethtool() {
    $ethtool_cmd "$@"
}

_ip () {
    $ip_cmd "$@"
}

is_nic_available() {
    _ip a show dev $nic_name > /dev/null 2>&1
}

deactivate_offloading() {
    echo "Disabling offloading for ${nic_name}"
    _ethtool --offload $nic_name rx off tx off > /dev/null
}

is_offloading_disabled() {
    # Return an error if at least one offload is enabled (rx or tx)
    if _ethtool --show-offload $nic_name | grep -E '^.x-checksumming:' | grep -q  ': on'; then
        return 1
    else
        return 0
    fi
}

if is_nic_available; then
    if ! is_offloading_disabled; then
        deactivate_offloading
        exit $?
    fi
fi