#!/bin/bash
set -ex

export IMAGE_BASE_URL=${IMAGE_BASE_URL:-"https://cloud-images.ubuntu.com/jammy/current/jammy-server-cloudimg-amd64.img"}
export IMAGE_MD5_URL=${IMAGE_MD5_URL:-"https://cloud-images.ubuntu.com/jammy/current/MD5SUMS"}
export VM_NAME=${VM_NAME:-"trymosk-amd64-$(date +"%Y%m%d%H%M%S").qcow2"}
export PACKER_LOG=${PACKER_LOG:-"1"}
export PACKER_IMAGES_CACHE=${PACKER_IMAGES_CACHE:-"./packer_images_cache"}

mkdir -p "${PACKER_IMAGES_CACHE}"

PACKER_BINARY=${PACKER_BINARY:-"$(which packer)"}

./config_drive.sh

if [[ -f ansible/inventory/build_overrides.yaml ]]; then
    curl --retry 6 --retry-delay 5 -L https://binary-dev-kaas-virtual.mcp.mirantis.com/openstack/bin/utils/yq/yq-v3.3.2 -o yq
    chmod +x yq
    ./yq merge ansible/inventory/build_overrides.yaml ../rockoon/virtual_lab/ansible/inventory/trymosk_single_node.yaml > ansible/inventory/trymosk_single_node.yaml
else
    cp ../rockoon/virtual_lab/ansible/inventory/trymosk_single_node.yaml ansible/inventory/trymosk_single_node.yaml
fi

$PACKER_BINARY build -on-error=cleanup template.json
