EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Creating PVC"
    kubectl apply -f pvc.yaml

    echo "Creating VM"
    kubectl apply -f cirros.yaml

    echo "Starting VM"
    virtctl start cirros-volumes

    echo "Waiting VM is Running."
    wait_vm_state cirros-volumes Running
}

function cleanup {
    kubectl delete -f cirros.yaml
    kubectl delete -f pvc.yaml
}

pushd $WORKDIR
$command
popd
