EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Creating VM"
    kubectl apply -f cirros-pool.yaml

    echo "Waiting VM is Running."
    for i in {0..2}; do
        wait_vm_state cirros-pool-$i Running
    done

    kubectl get vmpools
    kubectl get pods

    echo "Give some time to populate POD metris"
    sleep 15

    echo "Creating HorizontalPodAutoscaler"
    kubectl apply -f hpa.yaml

    echo "To create some load login to VM and run:"
    echo "sudo su"
    echo "dd if=/dev/zero of=/dev/null"
}

function cleanup {
    kubectl delete -f cirros-pool.yaml
    kubectl delete -f hpa.yaml
}

pushd $WORKDIR
$command
popd
