EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Creating PVC with CDI"
    echo "Downloading cirros"
    if [[ ! -f ${TMP_DIR}/cirros-0.6.2-x86_64-disk.img ]]; then
        wget https://download.cirros-cloud.net/0.6.2/cirros-0.6.2-x86_64-disk.img -O ${TMP_DIR}/cirros-0.6.2-x86_64-disk.img
        cp ${TMP_DIR}/cirros-0.6.2-x86_64-disk.img ${TMP_DIR}/disk.img
    fi

    echo "Uploading cirros to PVC."
    UPLOADPROXY_URL=https://$(kubectl get nodes  -o wide| tail -1  | awk '{print $6}'):31119
    virtctl image-upload pvc cirros-add-volume --size 5G --image-path=${TMP_DIR}/disk.img --insecure --uploadproxy-url ${UPLOADPROXY_URL}

    kubectl get pvc
    kubectl get pods

    echo "Creating VM"
    kubectl apply -f cirros-add-volume.yaml

    echo "Waiting VM is Running."
    wait_vm_state cirros-add-volume Running

    read -p "Press any key to add volume" -n 1 -r
    echo "Adding volume"
    virtctl addvolume cirros-add-volume --volume-name=cirros-add-volume

    read -p "Press any key to remove volume" -n 1 -r
    echo "Removing volume"
    virtctl removevolume cirros-add-volume --volume-name=cirros-add-volume
}

function cleanup {
    kubectl delete -f cirros-add-volume.yaml
    kubectl delete datavolume cirros-add-volume
    kubectl delete pvc cirros-add-volume
}

pushd $WORKDIR
$command
popd
