EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)

TMP_DIR=$(cd $(dirname "$0")/../../.workdir/ && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Downloading cirros"
    if [[ ! -f ${TMP_DIR}/cirros-0.6.2-x86_64-disk.img ]]; then
        wget https://download.cirros-cloud.net/0.6.2/cirros-0.6.2-x86_64-disk.img -O ${TMP_DIR}/cirros-0.6.2-x86_64-disk.img
    fi

    echo "Uploading cirros to PVC."
    UPLOADPROXY_URL=https://$(kubectl get nodes  -o wide| tail -1  | awk '{print $6}'):31119
    virtctl image-upload pvc cirros-cdi-pvc --size 5G --image-path=${TMP_DIR}/cirros-0.6.2-x86_64-disk.img --insecure --uploadproxy-url ${UPLOADPROXY_URL}

    kubectl get pvc
    kubectl get pods

    echo "Creating VM"
    kubectl apply -f cirros.yaml

    echo "Starting VM"
    virtctl start cirros-cdi-pvc

    echo "Waiting VM is Running."
    wait_vm_state cirros-cdi-pvc Running
}

function cleanup {
    kubectl delete -f cirros.yaml
    kubectl delete datavolume cirros-cdi-pvc
    kubectl delete pvc cirros-cdi-pvc
}

pushd $WORKDIR
$command
popd
