EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Creating PVC"
    kubectl apply -f pvc.yaml

    echo "Creating VM"
    kubectl apply -f cirros.yaml

    echo "Waiting VM is Running."
    wait_vm_state cirros-clone Running

    echo "Login to VM and create some data on the volume. For example run:"
    echo "sudo su"
    echo "mkfs.ext4 /dev/sda"
    echo "mkdir /mnt/vol01"
    echo "mount -t ext4 /dev/sda /mnt/vol01"
    echo "date > /mnt/vol01/here"
    echo "sync"

    read -p "Press any key to create clone" -n 1 -r
    echo "Creating clone"

    kubectl apply -f clone.yaml

    echo "Waiting clone is created"
    kubectl wait vmclone cirros-clone --for condition=Ready

    kubectl get pvc
    kubectl get vm
}

function cleanup {
    kubectl delete -f cirros.yaml
    kubectl delete -f pvc.yaml
    kubectl delete -f clone.yaml

    kubectl delete vm cirros-clone-target
    kubectl delete vmsnapshot cirros-snapshot
}

pushd $WORKDIR
$command
popd
