#!/bin/bash
set -x
set -e
# allow access to the local variables from prepare-metadata.py
set -a

# ensure we don't re-source this in the same environment
[[ -z "$_INSTALL_SCRIPT" ]] || return 0
declare -r -g _INSTALL_SCRIPT=1

#
# Variables in this block are passed from heat template
#
CONTROL_NETWORK_CIDR=${CONTROL_NETWORK_CIDR:-$control_network_cidr}
PUBLIC_INTERFACE=${PUBLIC_INTERFACE:-$private_floating_interface}
PUBLIC_INTERFACE_IP=${PUBLIC_INTERFACE_IP:-$private_floating_interface_ip}
PUBLIC_INTERFACE_CIDR=${PUBLIC_INTERFACE_CIDR:-$private_floating_network_cidr}
DEFAULT_INTERFACE=${DEFAULT_INTERFACE:-$default_interface}
STORAGE_BACKEND_INTERFACE=${STORAGE_BACKEND_INTERFACE:-$storage_backend_interface}
STORAGE_BACKEND_INTERFACE_IP=${STORAGE_BACKEND_INTERFACE_IP:-$storage_backend_network_interface_ip}
STORAGE_BACKEND_NETWORK=${STORAGE_BACKEND_NETWORK:-$storage_backend_network_cidr}
STORAGE_FRONTEND_INTERFACE=${STORAGE_FRONTEND_INTERFACE:-$storage_frontend_interface}
STORAGE_FRONTEND_INTERFACE_IP=${STORAGE_FRONTEND_INTERFACE_IP:-$storage_frontend_network_interface_ip}
STORAGE_FRONTEND_NETWORK=${STORAGE_FRONTEND_NETWORK:-$storage_frontend_network_cidr}
STORAGE_FRONTEND_NETWORK_NETMASK=$(echo ${STORAGE_FRONTEND_NETWORK} | cut -d'/' -f2)

IRONIC_BAREMETAL_NETWORK=${IRONIC_BAREMETAL_NETWORK:-$ironic_baremetal_network_cidr}
IRONIC_BAREMETAL_INTERFACE_IP=${IRONIC_BAREMETAL_INTERFACE_IP:-$ironic_baremetal_interface_ip}
IRONIC_BAREMETAL_TUNNEL_NETWORK=${IRONIC_BAREMETAL_TUNNEL_NETWORK:-$ironic_baremetal_tunnel_cidr}
TUNNEL_INTERFACE_IP=${TUNNEL_INTERFACE_IP:-$tunnel_interface_ip}
FRR_BGP_NEIGHBORS=${FRR_BGP_NEIGHBORS:-$frr_bgp_neighbors}
FRR_EVPN_TUNNELS_RANGE=${FRR_EVPN_TUNNELS_RANGE:-$frr_evpn_tunnels_range}
FRR_EVPN_VXLAN_DST_PORT=${FRR_EVPN_VXLAN_DST_PORT:-$frr_evpn_vxlan_dst_port}

NODE_TYPE=${NODE_TYPE:-$node_type}
KUBERNETES_INSTALLER=${KUBERNETES_INSTALLER:-$kubernetes_installer}
UCP_MASTER_HOST=${UCP_MASTER_HOST:-$ucp_master_host}
NODE_METADATA=${NODE_METADATA:-'$node_metadata'}
DOCKER_EE_URL=${DOCKER_EE_URL:-$docker_ee_url}
DOCKER_EE_RELEASE=${DOCKER_EE_RELEASE:-$docker_ee_release}
DOCKER_EE_PACKAGES=${DOCKER_EE_PACKAGES:-$docker_ee_packages}
DOCKER_UCP_IMAGE=${DOCKER_UCP_IMAGE:-$docker_ucp_image}
BINARY_BASE_URL=${BINARY_BASE_URL:-$binary_base_url}
UCP_DOCKER_SWARM_DATA_PORT=${UCP_DOCKER_SWARM_DATA_PORT:-$docker_ucp_swarm_data_port}
UCP_AUDIT_LOG_LEVEL=${UCP_AUDIT_LOG_LEVEL:-$ucp_audit_log_level}
FLOATING_NETWORK_PREFIXES=${FLOATING_NETWORK_PREFIXES:-$private_floating_network_cidr}
IRONIC_MT_ENABLED=${IRONIC_MT_ENABLED:-$ironic_mt_enabled}

HUGE_PAGES=${HUGE_PAGES:-$huge_pages}
TUNGSTENFABRIC_ENABLED=${TUNGSTENFABRIC_ENABLED:-$tungstenfabric_enabled}
SINGLE_NODE=${SINGLE_NODE:-$single_node}
DOCKER_DEFAULT_ADDRESS_POOL=${DOCKER_DEFAULT_ADDRESS_POOL:-$docker_default_address_pool}
LVM_LOOP_DEVICE_SIZE=${LVM_LOOP_DEVICE_SIZE:-$lvm_loop_device_size}
CINDER_LVM_LOOP_DEVICE_SIZE=${CINDER_LVM_LOOP_DEVICE_SIZE:-$cinder_lvm_loop_device_size}
SECURE_OVERLAY_ENABLED=${SECURE_OVERLAY_ENABLED:-$secure_overlay_enabled}
KUBECTL_VERSION=${KUBECTL_VERSION:-$kubectl_version}
KUBERNETES_CONTAINER_RUNTIME=${KUBERNETES_CONTAINER_RUNTIME:-$kubernetes_container_runtime}

DEVOPS_UTILS_REFSPEC=${DEVOPS_UTILS_REFSPEC:-$devops_utils_refspec}
K0S_VERSION=${K0S_VERSION:-$k0s_version}
#
# End of block
#

DEVOPS_UTILS_REPO=${DEVOPS_UTILS_REPO:-'https://gerrit.mcp.mirantis.com/oscore-tools/devops-utils'}
DEVOPS_UTILS_REFSPEC=${DEVOPS_UTILS_REFSPEC:-'master'}
DEVOPS_UTILS_DST=/usr/share/devops-utils

#Wait external network
netplan apply
systemctl restart systemd-resolved
sleep 15
curl --connect-timeout 10 --retry 12 --retry-delay 10 ${DEVOPS_UTILS_REPO} || (sleep 1; /bin/false)

if [[ ! -d ${DEVOPS_UTILS_DST} ]]; then
    git clone ${DEVOPS_UTILS_REPO} ${DEVOPS_UTILS_DST}
fi
pushd ${DEVOPS_UTILS_DST}
if echo "$DEVOPS_UTILS_REFSPEC" |grep -q "^refs"; then
    git fetch ${DEVOPS_UTILS_REPO} ${DEVOPS_UTILS_REFSPEC}
    git checkout FETCH_HEAD
else
    git checkout ${DEVOPS_UTILS_REFSPEC}
fi
git log --oneline -10
popd


source ${DEVOPS_UTILS_DST}/de/heat-templates/scripts/functions.sh

function wait_condition_send {
    local status=${1:-SUCCESS}
    local reason=${2:-\"empty\"}
    local data=${3:-\"empty\"}
    local data_binary="{\"status\": \"$status\", \"reason\": \"$reason\", \"data\": $data}"
    echo "Trying to send signal to wait condition 5 times: $data_binary"
    WAIT_CONDITION_NOTIFY_EXIT_CODE=2
    i=0
    while (( ${WAIT_CONDITION_NOTIFY_EXIT_CODE} != 0 && ${i} < 5 )); do
        $wait_condition_notify -k --data-binary "$data_binary" && WAIT_CONDITION_NOTIFY_EXIT_CODE=0 || WAIT_CONDITION_NOTIFY_EXIT_CODE=2
        i=$((i + 1))
        sleep 1
    done
    if (( ${WAIT_CONDITION_NOTIFY_EXIT_CODE} !=0 && "${status}" == "SUCCESS" ))
    then
        status="FAILURE"
        reason="Can't reach metadata service to report about SUCCESS."
    fi
    if [ "$status" == "FAILURE" ]; then
        exit 1
    fi
}

# Exit on any errors
function handle_exit {
    if [ $? != 0 ] ; then
        wait_condition_send "FAILURE" "Script terminated with an error."
    fi
}
trap handle_exit EXIT

if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
    case "$NODE_TYPE" in
        # Please keep the "prepare_metadata_files", "disable-rp-filter", "network_config" and "prepare_network" functions
        # at the very beginning in the same order.
        ucp)
            configure_sysctl_limits
            configure_logind_conf
            disable_unattended_upgr
            setup_bind_mounts
            wait_for_external_network
            prepare_metadata_files
            disable_rp_filter
            network_config
            prepare_network
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                prepare_docker_config
            fi
            install_required_packages
            install_kubectl
            configure_ntp
            configure_atop
            workaround_default_forward_policy
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                install_docker
                swarm_init
                create_ucp_config
                cache_images
                install_ucp
                download_bundles
                rm_ucp_config
            elif [[ "${KUBERNETES_INSTALLER}" == "k0s" ]]; then
                download_k0s
                install_k0s
            fi
            wait_for_node
            set_node_labels
            collect_ceph_metadata
            configure_contrack
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                disable_iptables_for_bridges
            fi
            if [[ "${SINGLE_NODE}" == true ]]; then
                nested_virt_config
                if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                    disable_master_taint
                fi
                collect_interfaces_metadata
            fi
            cron_disable_calico_offloading
            ;;
        master)
            configure_sysctl_limits
            configure_logind_conf
            disable_unattended_upgr
            setup_bind_mounts
            wait_for_external_network
            nested_virt_config
            prepare_metadata_files
            disable_rp_filter
            network_config
            prepare_network
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                prepare_docker_config
            fi
            install_required_packages
            install_kubectl
            configure_ntp
            configure_atop
            workaround_default_forward_policy
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                install_docker
                cache_images
                download_bundles
                join_node manager
            fi
            wait_for_node
            set_node_labels
            collect_ceph_metadata
            configure_contrack
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                disable_iptables_for_bridges
            fi
            collect_interfaces_metadata
            cron_disable_calico_offloading
            increase_iscsi_timeout
            ;;
        worker)
            configure_sysctl_limits
            configure_logind_conf
            disable_unattended_upgr
            setup_bind_mounts
            wait_for_external_network
            if [[ "${CONFIGURE_HUGE_PAGES}" == true ]]; then
                configure_huge_pages
            fi
            nested_virt_config
            prepare_metadata_files
            disable_rp_filter
            network_config
            prepare_network
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                prepare_docker_config
            fi
            install_required_packages
            install_kubectl
            enable_iscsi
            configure_ntp
            configure_atop
            workaround_default_forward_policy
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                install_docker
                cache_images
                download_bundles
                join_node worker
            elif [[ "${KUBERNETES_INSTALLER}" == "k0s" ]]; then
                download_k0s
                download_k8s_metadata
                join_k0s_node worker
            fi
            wait_for_node
            set_node_labels
            collect_ceph_metadata
            configure_contrack
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                disable_iptables_for_bridges
            fi
            collect_interfaces_metadata
            configure_lvm
            cron_disable_calico_offloading
            increase_iscsi_timeout
            ;;
        frr)
            configure_sysctl_limits
            disable_unattended_upgr
            wait_for_external_network
            prepare_metadata_files
            disable_rp_filter
            network_config
            prepare_network
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                prepare_docker_config
            fi
            install_required_packages
            configure_ntp
            configure_atop
            if [[ "${KUBERNETES_INSTALLER}" == "ucp" ]]; then
                install_docker
                cache_images
                download_bundles
            fi
            workaround_default_forward_policy
            configure_contrack
            disable_iptables_for_bridges
            install_frr
            cron_disable_calico_offloading
            increase_iscsi_timeout
            ;;
        *)
            echo "Usage: $0 {ucp|master|worker}"
            exit 1
    esac

    wait_condition_send "SUCCESS" "Instance successfuly started." "${HW_METADATA}"
fi
