set -ex

OS_CODENAME=$(lsb_release -c -s)
DOCKER_DEFAULT_ADDRESS_POOL=10.10.1.0/16
DOCKER_DEFAULT_ADDRESS_SIZE=24


mkdir -p /etc/docker
cat <<EOF > /etc/docker/daemon.json
{
  "default-address-pools": [
    { "base": "${DOCKER_DEFAULT_ADDRESS_POOL}", "size": ${DOCKER_DEFAULT_ADDRESS_SIZE} }
  ],
  "log-driver": "json-file",
  "log-opts": {
    "max-size": "1g",
    "max-file": "3"
  }
}
EOF

curl --retry 6 --retry-delay 5 -fsSL "${DOCKER_EE_URL}/gpg" | sudo apt-key add -
add-apt-repository "deb [arch=amd64] ${DOCKER_EE_URL}/ ${OS_CODENAME} ${DOCKER_EE_RELEASE}"

apt update

DEBIAN_FRONTEND=noninteractive apt install -y docker-ee

image_prefix=${DOCKER_UCP_IMAGE%/*}
if [[ "$image_prefix" =~ .*\.mirantis\.net* ]]; then
    for image in $(docker container run --rm --name ucp -v /var/run/docker.sock:/var/run/docker.sock ${DOCKER_UCP_IMAGE} images --list); do
        docker pull "${image_prefix}/${image##*/}"
        docker tag ${image_prefix}/${image##*/} mirantis/${image##*/}
    done
fi
