EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Creating VM"
    kubectl apply -f cirros-boot-vm.yaml

    echo "Starting VM"
    virtctl start cirros-boot-vm

    echo "Waiting VM is Running."
    wait_vm_state cirros-boot-vm Running
}

function cleanup {
    kubectl delete -f cirros-boot-vm.yaml
}

pushd $WORKDIR
$command
popd
