EXAMPLES_DIR=$(cd $(dirname "$0")/.. && pwd)
WORKDIR=$(cd $(dirname "$0") && pwd)
source ${EXAMPLES_DIR}/lib.sh

command=$1

function run {
    echo "Creating VM"
    kubectl apply -f cirros.yaml

    echo "Starting VM"
    virtctl start cirros-memdump

    echo "Waiting VM is Running."
    wait_vm_state cirros-memdump Running

    echo "Creating memorydump"
    virtctl  memory-dump get cirros-memdump --claim-name=cirros-memdump --create-claim

    sleep 5

    echo "Creating ubuntu pod"
    kubectl apply -f ubuntu.yaml

}

function cleanup {
    kubectl delete pod ubuntu-memdump --force --grace-period=0
    kubectl delete -f cirros.yaml
    kubectl delete -f ubuntu.yaml
    kubectl delete pvc cirros-memdump
}

pushd $WORKDIR
$command
popd
