set -ex

LOCAL_BINARY_PATH='/usr/bin'

declare -A binaries=(
    ["${LOCAL_BINARY_PATH}/yq"]="${BINARY_BASE_URL}/openstack/bin/utils/yq/yq-v3.3.2"
    ["${LOCAL_BINARY_PATH}/cfssl"]="${BINARY_BASE_URL}/openstack/bin/utils/cfssl/cfssl"
    ["${LOCAL_BINARY_PATH}/cfssljson"]="${BINARY_BASE_URL}/openstack/bin/utils/cfssl/cfssljson"
)

function download {
    local url=$1
    local dst=$2
    curl --retry 6 --retry-delay 10 -L ${url} -o ${dst}
    chmod +x ${dst}
}

for bin in "${!binaries[@]}"; do
    download ${binaries[${bin}]} ${bin}
done
