## Base packages and setup
export DEBIAN_FRONTEND=noninteractive
echo "exit 101" > /usr/sbin/policy-rc.d
chmod +x /usr/sbin/policy-rc.d
apt-get clean
apt-get update

# Cleanup old kernels, ensure latest is installed via virtual package
if [ ! -f /tmp/no_install_kernel ]; then
    # Update grub cmdline
    sed -i 's|GRUB_CMDLINE_LINUX_DEFAULT=.*|GRUB_CMDLINE_LINUX_DEFAULT="console=tty0 console=ttyS0,115200n8"|g' /etc/default/grub
    sed -i 's|GRUB_CMDLINE_LINUX=.*|GRUB_CMDLINE_LINUX="console=tty0 console=ttyS0,115200n8"|g' /etc/default/grub
    update-grub
fi

apt-get -y upgrade
apt-get -y dist-upgrade

apt-get autoremove --purge

# Useful tools
apt-get -y install curl wget tmux vim-nox byobu iputils-ping traceroute htop tree lsof

# Tmux fixes
cat << 'EOF' >> /etc/tmux.conf
set -g default-terminal "screen-256color"
set -g set-titles on
set -g xterm-keys on
EOF

# Setup cloud-init
apt-get -y install cloud-init
