#!/bin/bash
set -e
crt="/var/lib/docker/swarm/certificates/swarm-node.crt"
if test -f ${crt} && openssl x509 -checkend 3600 -noout -in ${crt}; then
    echo "WARNING: swarm CA not expired yet."
    echo "WARNING: docker CA WA not applied."
    exit 0
fi
echo 'Re-creating docker stack services!'
systemctl stop docker || true
echo 'Removing outdated certificates'
rm -rf /var/lib/docker/swarm/*
echo 'Starting docker service'
systemctl restart docker
sleep 5
echo 'Creating docker swarm'
docker swarm init --advertise-addr 127.0.0.1
sleep 5
for c in docker aptly; do
  pushd /etc/docker/compose/${c}/
    echo "Starting ${c} docker stack"
    docker stack deploy --compose-file docker-compose.yml ${c};
    echo "Stack ${c} started"
  popd
  sleep 1
done